/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.transceiver;

import crazypants.enderio.ModObject;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.AbstractPoweredTaskEntity;
import crazypants.enderio.machine.ContinuousTask;
import crazypants.enderio.machine.IoMode;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.machine.transceiver.Channel;
import crazypants.enderio.machine.transceiver.ChannelType;
import crazypants.enderio.machine.transceiver.PacketSendRecieveChannelList;
import crazypants.enderio.machine.transceiver.ServerChannelRegister;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.power.BasicCapacitor;
import crazypants.enderio.power.ICapacitor;
import crazypants.enderio.power.PowerDistributor;
import crazypants.enderio.rail.EnderRailController;
import crazypants.util.FluidUtil;
import crazypants.util.ItemUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileTransceiver
extends AbstractPoweredTaskEntity
implements IFluidHandler {
    private static final float MIN_POWER_TO_SEND = 0.5f;
    private final EnumMap<ChannelType, List<Channel>> sendChannels = new EnumMap(ChannelType.class);
    private final EnumMap<ChannelType, List<Channel>> recieveChannels = new EnumMap(ChannelType.class);
    private ICapacitor capacitor = new BasicCapacitor(Config.transceiverMaxIoRF * 2, 500000, Config.transceiverMaxIoRF);
    private boolean sendChannelsDirty = false;
    private boolean recieveChannelsDirty = false;
    private boolean registered = false;
    private Map<ForgeDirection, IFluidHandler> neighbourFluidHandlers = null;
    private PowerDistributor powerDistributor;
    private final EnderRailController railController;
    private boolean inFluidFill = false;
    private boolean inGetTankInfo = false;

    public TileTransceiver() {
        super(new SlotDefinition(8, 8, 0));
        for (ChannelType type : ChannelType.values()) {
            this.sendChannels.put(type, new ArrayList());
            this.recieveChannels.put(type, new ArrayList());
        }
        this.currentTask = new ContinuousTask(Config.transceiverUpkeepCostRF);
        this.railController = new EnderRailController(this);
    }

    public EnderRailController getRailController() {
        return this.railController;
    }

    public boolean isRedstoneChecksPassed() {
        return this.redstoneCheckPassed;
    }

    @Override
    protected boolean processTasks(boolean redstoneChecksPassed) {
        boolean res = super.processTasks(redstoneChecksPassed);
        if (!redstoneChecksPassed) {
            return res;
        }
        this.processPower();
        this.processItems();
        return res;
    }

    @Override
    public void func_145845_h() {
        if (!this.registered && this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            ServerChannelRegister.instance.register(this);
            this.registered = true;
            this.removeUnregsiteredChannels(this.sendChannels);
            this.removeUnregsiteredChannels(this.recieveChannels);
        }
        super.func_145845_h();
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.railController.doTick();
            if (this.sendChannelsDirty) {
                PacketHandler.sendToAllAround(new PacketSendRecieveChannelList(this, true), this, 256);
                this.sendChannelsDirty = false;
            }
            if (this.recieveChannelsDirty) {
                PacketHandler.sendToAllAround(new PacketSendRecieveChannelList(this, false), this, 256);
                this.recieveChannelsDirty = false;
            }
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (this.registered && this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            ServerChannelRegister.instance.dergister(this);
            this.registered = false;
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.registered && this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            ServerChannelRegister.instance.dergister(this);
            this.registered = false;
        }
    }

    private void removeUnregsiteredChannels(EnumMap<ChannelType, List<Channel>> channels) {
        ArrayList<Channel> toRemove = new ArrayList<Channel>();
        for (List<Channel> chans : channels.values()) {
            for (Channel chan : chans) {
                if (ServerChannelRegister.instance.getChannelsForType(chan.getType()).contains(chan)) continue;
                toRemove.add(chan);
            }
        }
        for (Channel chan : toRemove) {
            this.removeChannel(chan, channels);
        }
    }

    @Override
    public String getMachineName() {
        return ModObject.blockTransceiver.unlocalisedName;
    }

    @Override
    public boolean isActive() {
        return this.hasPower();
    }

    @Override
    protected boolean isMachineItemValidForSlot(int i, ItemStack itemstack) {
        return true;
    }

    @Override
    public ICapacitor getCapacitor() {
        return this.capacitor;
    }

    @Override
    public int getPowerUsePerTick() {
        return Config.transceiverUpkeepCostRF;
    }

    public List<Channel> getSendChannels(ChannelType type) {
        return this.sendChannels.get((Object)type);
    }

    public List<Channel> getRecieveChannels(ChannelType type) {
        return this.recieveChannels.get((Object)type);
    }

    public void addSendChanel(Channel channel) {
        this.addChannel(channel, this.sendChannels);
    }

    public void addRecieveChanel(Channel channel) {
        this.addChannel(channel, this.recieveChannels);
    }

    public void removeSendChanel(Channel channel) {
        this.removeChannel(channel, this.sendChannels);
    }

    public void removeRecieveChanel(Channel channel) {
        this.removeChannel(channel, this.recieveChannels);
    }

    private void addChannel(Channel channel, EnumMap<ChannelType, List<Channel>> channels) {
        if (channel == null) {
            return;
        }
        List<Channel> chans = channels.get((Object)channel.getType());
        if (!chans.contains(channel)) {
            chans.add(channel);
            if (channels == this.sendChannels) {
                this.sendChannelsDirty = true;
            } else {
                this.recieveChannelsDirty = true;
            }
        }
    }

    private void removeChannel(Channel channel, EnumMap<ChannelType, List<Channel>> channels) {
        if (channel == null) {
            return;
        }
        List<Channel> chans = channels.get((Object)channel.getType());
        if (chans.contains(channel)) {
            chans.remove(channel);
            if (channels == this.sendChannels) {
                this.sendChannelsDirty = true;
            } else {
                this.recieveChannelsDirty = true;
            }
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbtRoot) {
        super.readCustomNBT(nbtRoot);
        this.railController.readFromNBT(nbtRoot);
        this.currentTask = new ContinuousTask(Config.transceiverUpkeepCostRF);
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbtRoot) {
        super.writeCustomNBT(nbtRoot);
        this.railController.writeToNBT(nbtRoot);
    }

    @Override
    public void readCommon(NBTTagCompound nbtRoot) {
        super.readCommon(nbtRoot);
        TileTransceiver.readChannels(nbtRoot, this.sendChannels, "sendChannels");
        TileTransceiver.readChannels(nbtRoot, this.recieveChannels, "recieveChannels");
    }

    static void readChannels(NBTTagCompound nbtRoot, EnumMap<ChannelType, List<Channel>> readInto, String key) {
        for (ChannelType type : ChannelType.values()) {
            readInto.get((Object)type).clear();
        }
        if (!nbtRoot.func_74764_b(key)) {
            return;
        }
        NBTTagList tags = (NBTTagList)nbtRoot.func_74781_a(key);
        for (int i = 0; i < tags.func_74745_c(); ++i) {
            NBTTagCompound chanelTag = tags.func_150305_b(i);
            Channel channel = Channel.readFromNBT(chanelTag);
            if (channel == null) continue;
            readInto.get((Object)channel.getType()).add(channel);
        }
    }

    @Override
    public void writeCommon(NBTTagCompound nbtRoot) {
        super.writeCommon(nbtRoot);
        NBTTagList channelTags = TileTransceiver.createTagList(this.sendChannels);
        nbtRoot.func_74782_a("sendChannels", (NBTBase)channelTags);
        channelTags = TileTransceiver.createTagList(this.recieveChannels);
        nbtRoot.func_74782_a("recieveChannels", (NBTBase)channelTags);
    }

    static NBTTagList createTagList(EnumMap<ChannelType, List<Channel>> chans) {
        NBTTagList res = new NBTTagList();
        for (List<Channel> chanList : chans.values()) {
            for (Channel channel : chanList) {
                NBTTagCompound chanTag = new NBTTagCompound();
                channel.writeToNBT(chanTag);
                res.func_74742_a((NBTBase)chanTag);
            }
        }
        return res;
    }

    void setSendChannels(EnumMap<ChannelType, List<Channel>> channels) {
        for (ChannelType type : ChannelType.values()) {
            this.sendChannels.get((Object)type).clear();
            this.sendChannels.get((Object)type).addAll((Collection<Channel>)channels.get((Object)type));
        }
    }

    void setRecieveChannels(EnumMap<ChannelType, List<Channel>> channels) {
        for (ChannelType type : ChannelType.values()) {
            this.recieveChannels.get((Object)type).clear();
            this.recieveChannels.get((Object)type).addAll((Collection<Channel>)channels.get((Object)type));
        }
    }

    EnumMap<ChannelType, List<Channel>> getSendChannels() {
        return this.sendChannels;
    }

    EnumMap<ChannelType, List<Channel>> getReceiveChannels() {
        return this.recieveChannels;
    }

    private void processPower() {
        List<Channel> sendTo = this.getSendChannels(ChannelType.POWER);
        int canSend = this.getMaxSendableEnergy();
        if (canSend > 0 && !sendTo.isEmpty()) {
            for (int i = 0; i < sendTo.size() && canSend > 0; ++i) {
                ServerChannelRegister.instance.sendPower(this, canSend, sendTo.get(i));
                canSend = this.getMaxSendableEnergy();
            }
        }
        if ((canSend = this.getMaxSendableEnergy()) > 0 && !this.getRecieveChannels(ChannelType.POWER).isEmpty()) {
            if (this.powerDistributor == null) {
                this.powerDistributor = new PowerDistributor(this.getLocation());
            }
            int used = this.powerDistributor.transmitEnergy(this.field_145850_b, canSend);
            this.usePower(used);
        }
    }

    private int getMaxSendableEnergy() {
        return this.getEnergyStored() - (int)(0.5f * (float)this.getMaxEnergyStored());
    }

    private float getEnergyStoredRatio() {
        return (float)this.getEnergyStored() / (float)this.getMaxEnergyStored();
    }

    @Override
    public void onNeighborBlockChange(Block blockId) {
        super.onNeighborBlockChange(blockId);
        if (this.powerDistributor != null) {
            this.powerDistributor.neighboursChanged();
        }
        this.neighbourFluidHandlers = null;
    }

    private boolean hasRecieveChannel(List<Channel> channels, ChannelType type) {
        boolean hasChannel = false;
        for (Channel chan : channels) {
            if (!this.getRecieveChannels(type).contains(chan)) continue;
            hasChannel = true;
            break;
        }
        return hasChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canFill(ForgeDirection from, Fluid fluid) {
        if (this.inFluidFill) {
            return false;
        }
        try {
            this.inFluidFill = true;
            if (this.getSendChannels(ChannelType.FLUID).isEmpty()) {
                boolean bl = false;
                return bl;
            }
            boolean bl = ServerChannelRegister.instance.canFill(this, this.getSendChannels(ChannelType.FLUID), fluid);
            return bl;
        }
        finally {
            this.inFluidFill = false;
        }
    }

    public boolean canReceive(List<Channel> channels, Fluid fluid) {
        if (this.inFluidFill) {
            return false;
        }
        if (!this.hasRecieveChannel(channels, ChannelType.FLUID)) {
            return false;
        }
        Map<ForgeDirection, IFluidHandler> handlers = this.getNeighbouringFluidHandlers();
        for (Map.Entry<ForgeDirection, IFluidHandler> entry : handlers.entrySet()) {
            if (!entry.getValue().canFill(entry.getKey().getOpposite(), fluid)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (this.inFluidFill) {
            return 0;
        }
        try {
            this.inFluidFill = true;
            if (this.getSendChannels(ChannelType.FLUID).isEmpty() || !this.redstoneCheckPassed || !this.getIoMode(from).canRecieveInput()) {
                int n = 0;
                return n;
            }
            int n = ServerChannelRegister.instance.fill(this, this.getSendChannels(ChannelType.FLUID), resource, doFill);
            return n;
        }
        finally {
            this.inFluidFill = false;
        }
    }

    public int recieveFluid(List<Channel> channels, FluidStack resource, boolean doFill) {
        if (this.inFluidFill) {
            return 0;
        }
        if (!this.hasRecieveChannel(channels, ChannelType.FLUID) || !this.redstoneCheckPassed) {
            return 0;
        }
        Map<ForgeDirection, IFluidHandler> handlers = this.getNeighbouringFluidHandlers();
        for (Map.Entry<ForgeDirection, IFluidHandler> entry : handlers.entrySet()) {
            int res;
            IoMode mode = this.getIoMode(entry.getKey());
            if (!mode.canOutput() || (res = entry.getValue().fill(entry.getKey().getOpposite(), resource, doFill)) <= 0) continue;
            return res;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        if (this.inGetTankInfo) {
            return new FluidTankInfo[0];
        }
        try {
            this.inGetTankInfo = true;
            FluidTankInfo[] fluidTankInfoArray = ServerChannelRegister.instance.getTankInfoForChannels(this, this.getSendChannels(ChannelType.FLUID));
            return fluidTankInfoArray;
        }
        finally {
            this.inGetTankInfo = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getRecieveTankInfo(List<FluidTankInfo> infos, List<Channel> channels) {
        if (this.inGetTankInfo) {
            return;
        }
        try {
            this.inGetTankInfo = true;
            if (!this.hasRecieveChannel(channels, ChannelType.FLUID)) {
                return;
            }
            Map<ForgeDirection, IFluidHandler> fluidHandlers = this.getNeighbouringFluidHandlers();
            for (Map.Entry<ForgeDirection, IFluidHandler> entry : fluidHandlers.entrySet()) {
                FluidTankInfo[] tanks = entry.getValue().getTankInfo(entry.getKey().getOpposite());
                if (tanks == null) continue;
                for (FluidTankInfo info : tanks) {
                    infos.add(info);
                }
            }
        }
        finally {
            this.inGetTankInfo = false;
        }
    }

    Map<ForgeDirection, IFluidHandler> getNeighbouringFluidHandlers() {
        if (this.neighbourFluidHandlers == null) {
            this.neighbourFluidHandlers = FluidUtil.getNeighbouringFluidHandlers((IBlockAccess)this.field_145850_b, this.getLocation());
        }
        return this.neighbourFluidHandlers;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    private void processItems() {
        List<Channel> sendItemChannels = this.getSendChannels(ChannelType.ITEM);
        if (!sendItemChannels.isEmpty()) {
            for (int i = this.slotDefinition.minInputSlot; i <= this.slotDefinition.maxInputSlot; ++i) {
                ItemStack toSend = this.func_70301_a(i);
                if (toSend == null) continue;
                ServerChannelRegister.instance.sendItem(this, sendItemChannels, i, toSend);
            }
        }
    }

    @Override
    public boolean func_102007_a(int slot, ItemStack itemstack, int j) {
        block4: {
            block3: {
                if (itemstack == null) {
                    return false;
                }
                if (!this.slotDefinition.isInputSlot(slot)) break block3;
                for (int i = this.slotDefinition.getMinInputSlot(); i <= this.slotDefinition.getMaxInputSlot(); ++i) {
                    if (i == slot || !ItemUtil.areStacksEqual(itemstack, this.func_70301_a(i))) continue;
                    return false;
                }
                break block4;
            }
            if (!this.slotDefinition.isOutputSlot(slot)) break block4;
            for (int i = this.slotDefinition.getMinOutputSlot(); i <= this.slotDefinition.getMaxOutputSlot(); ++i) {
                if (i == slot || !ItemUtil.areStacksEqual(itemstack, this.func_70301_a(i))) continue;
                return false;
            }
        }
        return super.func_102007_a(slot, itemstack, j);
    }
}

