/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.transceiver.gui;

import crazypants.enderio.config.Config;
import crazypants.enderio.gui.ITabPanel;
import crazypants.enderio.gui.IconEIO;
import crazypants.enderio.machine.power.PowerDisplayUtil;
import crazypants.enderio.machine.transceiver.gui.ContainerTransceiver;
import crazypants.enderio.machine.transceiver.gui.GuiTransceiver;
import crazypants.gui.GuiToolTip;
import crazypants.render.ColorUtil;
import crazypants.render.RenderUtil;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import org.lwjgl.opengl.GL11;

public class GeneralTab
implements ITabPanel {
    private static final int SEND_BAR_OFFSET = 13;
    ContainerTransceiver container;
    GuiTransceiver parent;
    GuiToolTip sendPowerBarTT;

    public GeneralTab(GuiTransceiver guiTransceiver) {
        this.parent = guiTransceiver;
        this.container = this.parent.container;
        this.sendPowerBarTT = new GuiToolTip(new Rectangle(this.parent.getPowerX() + 13, this.parent.getPowerY(), this.parent.getPowerWidth(), this.parent.getPowerHeight()), new String[]{""}){

            @Override
            protected void updateText() {
                this.text.clear();
                if (GeneralTab.this.parent.renderPowerBar()) {
                    GeneralTab.this.updateSendPowerBarTooltip(this.text);
                }
            }
        };
        this.parent.addToolTip(this.sendPowerBarTT);
    }

    @Override
    public void onGuiInit(int x, int y, int width, int height) {
        this.container.setPlayerInventory(true);
    }

    @Override
    public void deactivate() {
        this.container.setPlayerInventory(false);
    }

    @Override
    public IconEIO getIcon() {
        return IconEIO.IO_CONFIG_UP;
    }

    @Override
    public void render(float par1, int par2, int par3) {
        int top = this.parent.getGuiTop();
        int left = this.parent.getGuiLeft();
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        RenderUtil.bindTexture("enderio:textures/gui/transceiver.png");
        Point invRoot = this.container.getPlayerInventoryOffset();
        this.parent.func_73729_b(left + invRoot.x - 1, top + invRoot.y - 1, 24, 180, 162, 76);
        invRoot = this.container.getItemInventoryOffset();
        this.parent.func_73729_b(left + invRoot.x - 1, top + invRoot.y - 1, 24, 180, 72, 36);
        this.parent.func_73729_b(left + invRoot.x - 1 + 72 + this.container.getItemBufferSpacing(), top + invRoot.y - 1, 24, 180, 72, 36);
        FontRenderer fr = this.parent.getFontRenderer();
        String sendTxt = "Send";
        int x = left + invRoot.x + 36 - fr.func_78256_a(sendTxt) / 2;
        int y = top + invRoot.y - fr.field_78288_b - 3;
        fr.func_78261_a(sendTxt, x, y, ColorUtil.getRGB(Color.WHITE));
        String recText = "Receive";
        x = left + invRoot.x + 72 + this.container.getItemBufferSpacing() + 36 - fr.func_78256_a(recText) / 2;
        fr.func_78261_a(recText, x, y, ColorUtil.getRGB(Color.WHITE));
        this.parent.renderSlotHighlights();
        RenderUtil.bindTexture("enderio:textures/gui/transceiver.png");
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        x = left + this.parent.getPowerX() - 1;
        y = top + this.parent.getPowerY() - 1;
        int maxHeight = this.parent.getPowerHeight();
        this.parent.func_73729_b(x, y, 233, 196, 12, maxHeight + 2);
        this.parent.func_73729_b(x + 13, y, 233, 196, 12, maxHeight + 2);
        int totalPixelHeight = this.parent.transceiver.getEnergyStoredScaled(maxHeight * 2);
        int fillHeight = Math.min(totalPixelHeight, maxHeight);
        int fillY = y + 1 + this.parent.getPowerHeight() - fillHeight;
        this.parent.func_73729_b(++x, fillY, this.parent.getPowerU(), this.parent.getPowerV(), this.parent.getPowerWidth(), fillHeight);
        fillHeight = Math.max(0, totalPixelHeight - maxHeight);
        fillY = y + 1 + this.parent.getPowerHeight() - fillHeight;
        this.parent.func_73729_b(x + 13, fillY, this.parent.getPowerU() - 25, this.parent.getPowerV(), this.parent.getPowerWidth(), fillHeight);
    }

    public void updatePowerBarTooltip(List<String> text) {
        text.add("Local Buffer");
        text.add("Upkeep: " + PowerDisplayUtil.formatPowerPerTick(this.parent.getPowerOutputValue()));
        int maxEnergy = this.parent.transceiver.getCapacitor().getMaxEnergyStored() / 2;
        int energyStored = Math.min(this.parent.transceiver.getEnergyStored(), maxEnergy);
        text.add(PowerDisplayUtil.formatStoredPower(energyStored, maxEnergy));
    }

    private void updateSendPowerBarTooltip(List<String> text) {
        text.add("Send/Recieve Buffer");
        text.add("Max IO: " + PowerDisplayUtil.formatPowerPerTick(Config.transceiverMaxIoRF));
        int maxEnergy = this.parent.transceiver.getCapacitor().getMaxEnergyStored() / 2;
        int energyStored = Math.max(0, this.parent.transceiver.getEnergyStored() - maxEnergy);
        text.add(PowerDisplayUtil.formatStoredPower(energyStored, maxEnergy));
    }

    @Override
    public void actionPerformed(GuiButton guiButton) {
    }

    @Override
    public void mouseClicked(int x, int y, int par3) {
    }

    @Override
    public void updateScreen() {
    }

    @Override
    public void keyTyped(char par1, int par2) {
    }
}

