/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.transceiver.gui;

import crazypants.enderio.config.Config;
import crazypants.enderio.gui.IGuiOverlay;
import crazypants.enderio.gui.ITabPanel;
import crazypants.enderio.gui.IconEIO;
import crazypants.enderio.machine.GuiMachineBase;
import crazypants.enderio.machine.transceiver.ChannelType;
import crazypants.enderio.machine.transceiver.TileTransceiver;
import crazypants.enderio.machine.transceiver.gui.ChannelTab;
import crazypants.enderio.machine.transceiver.gui.ContainerTransceiver;
import crazypants.enderio.machine.transceiver.gui.GeneralTab;
import crazypants.render.RenderUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.InventoryPlayer;
import org.lwjgl.opengl.GL11;

public class GuiTransceiver
extends GuiMachineBase {
    private static final int TAB_HEIGHT = 24;
    TileTransceiver entity;
    private int activeTab = 0;
    private final List<ITabPanel> tabs = new ArrayList<ITabPanel>();
    private int tabYOffset = 4;
    ContainerTransceiver container;
    TileTransceiver transceiver;
    GeneralTab generalTab;

    public GuiTransceiver(InventoryPlayer par1InventoryPlayer, TileTransceiver te) {
        super(te, new ContainerTransceiver(par1InventoryPlayer, te));
        this.entity = te;
        this.container = (ContainerTransceiver)this.field_147002_h;
        this.transceiver = te;
        this.generalTab = new GeneralTab(this);
        this.tabs.add(this.generalTab);
        this.tabs.add(new ChannelTab(this, ChannelType.POWER));
        this.tabs.add(new ChannelTab(this, ChannelType.ITEM));
        this.tabs.add(new ChannelTab(this, ChannelType.FLUID));
        if (Config.enderRailEnabled) {
            this.tabs.add(new ChannelTab(this, ChannelType.RAIL));
        }
    }

    @Override
    protected void updatePowerBarTooltip(List<String> text) {
        this.generalTab.updatePowerBarTooltip(text);
    }

    @Override
    protected boolean showRecipeButton() {
        return false;
    }

    @Override
    public int getXSize() {
        return 256;
    }

    public void func_73876_c() {
        for (int i = 0; i < this.tabs.size(); ++i) {
            if (i != this.activeTab) continue;
            this.tabs.get(i).updateScreen();
            return;
        }
    }

    @Override
    protected void func_73869_a(char par1, int par2) {
        if (par2 == 1) {
            for (IGuiOverlay overlay : this.overlays) {
                if (!overlay.isVisible()) continue;
                overlay.setVisible(false);
                return;
            }
            this.field_146297_k.field_71439_g.func_71053_j();
        }
        for (int i = 0; i < this.tabs.size(); ++i) {
            if (i != this.activeTab) continue;
            this.tabs.get(i).keyTyped(par1, par2);
            return;
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        for (int i = 0; i < this.tabs.size(); ++i) {
            if (i == this.activeTab) {
                this.tabs.get(i).onGuiInit(this.field_147003_i + 10, this.field_147009_r, this.field_146999_f - 20, this.field_147000_g - 20);
                continue;
            }
            this.tabs.get(i).deactivate();
        }
        this.configB.field_146125_m = this.activeTab == 0;
        this.redstoneButton.field_146125_m = this.activeTab == 0;
    }

    @Override
    public void renderPowerBar(int k, int l) {
    }

    @Override
    protected boolean renderPowerBar() {
        return this.activeTab == 0;
    }

    @Override
    public int getPowerX() {
        return super.getPowerX() - 4;
    }

    @Override
    public int getPowerHeight() {
        return 58;
    }

    @Override
    public int getPowerY() {
        return super.getPowerY();
    }

    @Override
    public int getPowerWidth() {
        return 10;
    }

    @Override
    public int getPowerV() {
        return 196;
    }

    @Override
    public int getPowerU() {
        return 246;
    }

    @Override
    public String getPowerOutputLabel() {
        return super.getPowerOutputLabel();
    }

    @Override
    public int getPowerOutputValue() {
        return super.getPowerOutputValue();
    }

    protected void func_73864_a(int x, int y, int par3) {
        super.func_73864_a(x, y, par3);
        int tabLeftX = this.field_146999_f;
        int tabRightX = tabLeftX + 22;
        int minY = this.tabYOffset;
        int maxY = minY + this.tabs.size() * 24;
        if ((x -= this.field_147003_i) > tabLeftX && x < tabRightX + 24 && (y -= this.field_147009_r) > minY && y < maxY) {
            this.activeTab = (y - minY) / 24;
            this.hideOverlays();
            this.func_73866_w_();
            return;
        }
        this.tabs.get(this.activeTab).mouseClicked(x, y, par3);
    }

    @Override
    protected void func_146284_a(GuiButton guiButton) {
        super.func_146284_a(guiButton);
        this.tabs.get(this.activeTab).actionPerformed(guiButton);
    }

    @Override
    protected void func_146976_a(float par1, int par2, int par3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int sx = (this.field_146294_l - this.field_146999_f) / 2;
        int sy = (this.field_146295_m - this.field_147000_g) / 2;
        int tabX = sx + this.field_146999_f - 3;
        Tessellator tes = Tessellator.field_78398_a;
        tes.func_78382_b();
        for (int i = 0; i < this.tabs.size(); ++i) {
            if (i == this.activeTab) continue;
            RenderUtil.bindTexture(IconEIO.TEXTURE);
            IconEIO.INACTIVE_TAB.renderIcon(tabX, sy + this.tabYOffset + i * 24);
            IconEIO icon = this.tabs.get(i).getIcon();
            icon.renderIcon(tabX + 4, sy + this.tabYOffset + i * 24 + 7, 10.0, 10.0, 0.0, false);
        }
        tes.func_78381_a();
        RenderUtil.bindTexture("enderio:textures/gui/transceiver.png");
        this.func_73729_b(sx, sy, 0, 0, this.field_146999_f, this.field_147000_g);
        super.func_146976_a(par1, par2, par3);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderUtil.bindTexture(IconEIO.TEXTURE);
        tes.func_78382_b();
        IconEIO.ACTIVE_TAB.renderIcon(tabX, sy + this.tabYOffset + this.activeTab * 24);
        if (this.tabs.size() > 0) {
            IconEIO icon = this.tabs.get(this.activeTab).getIcon();
            icon.renderIcon(tabX + 4, sy + this.tabYOffset + this.activeTab * 24 + 7, 10.0, 10.0, 0.0, false);
            tes.func_78381_a();
            this.tabs.get(this.activeTab).render(par1, par2, par3);
        } else {
            tes.func_78381_a();
        }
    }
}

