/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.vacuum;

import crazypants.enderio.ModObject;
import crazypants.enderio.config.Config;
import crazypants.render.BoundingBox;
import crazypants.util.BlockCoord;
import crazypants.util.ItemUtil;
import java.util.List;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;

public class TileVacuumChest
extends TileEntity
implements IEntitySelector,
IInventory {
    private static final double RANGE = Config.vacuumChestRange;
    private ItemStack[] inv = new ItemStack[27];

    public void func_145845_h() {
        if (!this.isFull()) {
            this.doHoover();
        }
    }

    public boolean func_82704_a(Entity entity) {
        if (entity.field_70128_L) {
            return false;
        }
        if (entity instanceof IProjectile) {
            return entity.field_70181_x < 0.01;
        }
        if (entity instanceof EntityItem) {
            ItemStack stack = ((EntityItem)entity).func_92059_d();
            return true;
        }
        return false;
    }

    private void doHoover() {
        BoundingBox bb = new BoundingBox(this.getLocation());
        AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)bb.minX, (double)bb.minY, (double)bb.minZ, (double)bb.maxX, (double)bb.maxY, (double)bb.maxZ);
        aabb = aabb.func_72314_b(RANGE, RANGE, RANGE);
        List interestingItems = this.field_145850_b.func_82733_a(EntityItem.class, aabb, (IEntitySelector)this);
        for (EntityItem entity : interestingItems) {
            double x = (double)this.field_145851_c + 0.5 - entity.field_70165_t;
            double y = (double)this.field_145848_d + 0.5 - entity.field_70163_u;
            double z = (double)this.field_145849_e + 0.5 - entity.field_70161_v;
            double distance = Math.sqrt(x * x + y * y + z * z);
            if (distance < 1.25) {
                this.hooverEntity((Entity)entity);
                continue;
            }
            double speed = 0.06;
            double distScale = 1.0 - Math.min(0.9, distance / (RANGE * RANGE));
            distScale *= distScale;
            entity.field_70159_w += x / distance * distScale * speed;
            entity.field_70181_x += y / distance * distScale * 0.2;
            entity.field_70179_y += z / distance * distScale * speed;
        }
    }

    private void hooverEntity(Entity entity) {
        if (!this.field_145850_b.field_72995_K && entity instanceof EntityItem && !entity.field_70128_L) {
            EntityItem item = (EntityItem)entity;
            ItemStack stack = item.func_92059_d().func_77946_l();
            int numInserted = ItemUtil.doInsertItem(this, stack);
            stack.field_77994_a -= numInserted;
            item.func_92058_a(stack);
            if (stack.field_77994_a == 0) {
                item.func_70106_y();
            }
        }
    }

    private boolean isFull() {
        for (ItemStack stack : this.inv) {
            if (stack != null && stack.field_77994_a >= stack.func_77976_d()) continue;
            return false;
        }
        return true;
    }

    private BlockCoord getLocation() {
        return new BlockCoord(this);
    }

    public int func_70302_i_() {
        return this.inv.length;
    }

    public int func_70297_j_() {
        return 64;
    }

    public ItemStack func_70301_a(int slot) {
        if (slot < 0 || slot >= this.inv.length) {
            return null;
        }
        return this.inv[slot];
    }

    public ItemStack func_70298_a(int fromSlot, int amount) {
        ItemStack fromStack = this.inv[fromSlot];
        if (fromStack == null) {
            return null;
        }
        if (fromStack.field_77994_a <= amount) {
            this.inv[fromSlot] = null;
            return fromStack;
        }
        ItemStack result = new ItemStack(fromStack.func_77973_b(), amount, fromStack.func_77960_j());
        if (fromStack.field_77990_d != null) {
            result.field_77990_d = (NBTTagCompound)fromStack.field_77990_d.func_74737_b();
        }
        fromStack.field_77994_a -= amount;
        return result;
    }

    public void func_70299_a(int slot, ItemStack contents) {
        if (slot < 0 || slot >= this.inv.length) {
            System.out.println("TileVacumChest.setInventorySlotContents: " + slot);
            return;
        }
        this.inv[slot] = contents == null ? contents : contents.func_77946_l();
        if (contents != null && contents.field_77994_a > this.func_70297_j_()) {
            contents.field_77994_a = this.func_70297_j_();
        }
    }

    public ItemStack func_70304_b(int var1) {
        return null;
    }

    public String func_145825_b() {
        return ModObject.blockVacuumChest.unlocalisedName;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int var1, ItemStack var2) {
        return true;
    }

    public void func_145839_a(NBTTagCompound nbtRoot) {
        super.func_145839_a(nbtRoot);
        this.readContentsFromNBT(nbtRoot);
    }

    public void readContentsFromNBT(NBTTagCompound nbtRoot) {
        NBTTagList itemList = (NBTTagList)nbtRoot.func_74781_a("Items");
        if (itemList != null) {
            for (int i = 0; i < itemList.func_74745_c(); ++i) {
                NBTTagCompound itemStack = itemList.func_150305_b(i);
                byte slot = itemStack.func_74771_c("Slot");
                if (slot < 0 || slot >= this.inv.length) continue;
                this.inv[slot] = ItemStack.func_77949_a((NBTTagCompound)itemStack);
            }
        }
    }

    public void func_145841_b(NBTTagCompound nbtRoot) {
        super.func_145841_b(nbtRoot);
        this.writeContentsToNBT(nbtRoot);
    }

    public void writeContentsToNBT(NBTTagCompound nbtRoot) {
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.inv.length; ++i) {
            if (this.inv[i] == null) continue;
            NBTTagCompound itemStackNBT = new NBTTagCompound();
            itemStackNBT.func_74774_a("Slot", (byte)i);
            this.inv[i].func_77955_b(itemStackNBT);
            itemList.func_74742_a((NBTBase)itemStackNBT);
        }
        nbtRoot.func_74782_a("Items", (NBTBase)itemList);
    }
}

