/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.wireless;

import cofh.api.energy.IEnergyContainerItem;
import crazypants.enderio.TileEntityEio;
import crazypants.enderio.machine.wireless.IWirelessCharger;
import crazypants.enderio.machine.wireless.PacketStoredEnergy;
import crazypants.enderio.machine.wireless.WirelessChargerController;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.power.IInternalPowerReceptor;
import crazypants.enderio.power.PowerHandlerUtil;
import crazypants.util.BlockCoord;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileWirelessCharger
extends TileEntityEio
implements IInternalPowerReceptor,
IWirelessCharger {
    public static final int MAX_ENERGY_STORED = 1000000;
    public static final int MAX_ENERGY_IN = 10000;
    public static final int MAX_ENERGY_OUT = 10000;
    int storedEnergyRF;
    private double lastPowerUpdate = -1.0;
    private boolean registered = false;

    public void func_145843_s() {
        super.func_145843_s();
        WirelessChargerController.instance.deregisterCharger(this);
        this.registered = false;
    }

    public void func_145845_h() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.registered) {
            WirelessChargerController.instance.registerCharger(this);
            this.registered = true;
        }
        if (this.lastPowerUpdate == -1.0 || this.lastPowerUpdate == 0.0 && this.storedEnergyRF > 0 || this.lastPowerUpdate > 0.0 && this.storedEnergyRF == 0 || this.lastPowerUpdate != (double)this.storedEnergyRF && this.field_145850_b.func_82737_E() % 20L == 0L) {
            this.lastPowerUpdate = this.storedEnergyRF;
            PacketHandler.sendToAllAround(new PacketStoredEnergy(this), this);
        }
    }

    @Override
    public boolean chargeItems(ItemStack[] items) {
        boolean chargedItem = false;
        int available = Math.min(10000, this.storedEnergyRF);
        for (ItemStack item : items) {
            if (item == null || available <= 0) continue;
            int used = 0;
            if (item.func_77973_b() instanceof IEnergyContainerItem && item.field_77994_a == 1) {
                IEnergyContainerItem chargable = (IEnergyContainerItem)item.func_77973_b();
                int max = chargable.getMaxEnergyStored(item);
                int cur = chargable.getEnergyStored(item);
                int canUse = Math.min(available, max - cur);
                if (cur < max) {
                    used = chargable.receiveEnergy(item, canUse, false);
                }
            }
            if (used <= 0) continue;
            this.storedEnergyRF -= used;
            chargedItem = true;
            available -= used;
        }
        return chargedItem;
    }

    @Override
    protected void writeCustomNBT(NBTTagCompound root) {
        root.func_74768_a("storedEnergyRF", this.storedEnergyRF);
    }

    @Override
    protected void readCustomNBT(NBTTagCompound root) {
        if (root.func_74764_b("storedEnergy")) {
            double storedMJ = root.func_74769_h("storedEnergy");
            this.storedEnergyRF = (int)(storedMJ * 10.0);
        } else {
            this.storedEnergyRF = root.func_74762_e("storedEnergyRF");
        }
    }

    @Override
    public int getMaxEnergyRecieved(ForgeDirection dir) {
        return 10000;
    }

    @Override
    public int getEnergyStored() {
        return this.storedEnergyRF;
    }

    @Override
    public int getMaxEnergyStored() {
        return 1000000;
    }

    @Override
    public void setEnergyStored(int stored) {
        this.storedEnergyRF = stored;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return PowerHandlerUtil.recieveInternal(this, maxReceive, from, simulate);
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return 0;
    }

    @Override
    public int takeEnergy(int max) {
        int prev = this.storedEnergyRF;
        this.storedEnergyRF = Math.max(0, this.storedEnergyRF - max);
        return prev - this.storedEnergyRF;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.storedEnergyRF;
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return 1000000;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    @Override
    public BlockCoord getLocation() {
        return new BlockCoord(this);
    }

    @Override
    public World getWorld() {
        return this.func_145831_w();
    }

    @Override
    public boolean displayPower() {
        return true;
    }
}

