/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.wireless;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.wireless.IWirelessCharger;
import crazypants.util.BlockCoord;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;

public class WirelessChargerController {
    public static WirelessChargerController instance = new WirelessChargerController();
    public static final int RANGE = Config.wirelessChargerRange;
    public static final int RANGE_SQ = RANGE * RANGE;
    private Map<Integer, Map<BlockCoord, IWirelessCharger>> perWorldChargers = new HashMap<Integer, Map<BlockCoord, IWirelessCharger>>();

    private WirelessChargerController() {
    }

    public void registerCharger(IWirelessCharger charger) {
        if (charger == null) {
            return;
        }
        Map<BlockCoord, IWirelessCharger> chargers = this.getChargersForWorld(charger.getWorld());
        chargers.put(charger.getLocation(), charger);
    }

    public void deregisterCharger(IWirelessCharger capBank) {
        if (capBank == null) {
            return;
        }
        Map<BlockCoord, IWirelessCharger> chargers = this.getChargersForWorld(capBank.getWorld());
        chargers.remove(capBank.getLocation());
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.side == Side.CLIENT || event.phase != TickEvent.Phase.END) {
            return;
        }
        this.chargePlayersItems(event.player);
    }

    public void chargePlayersItems(EntityPlayer player) {
        Map<BlockCoord, IWirelessCharger> chargers = this.getChargersForWorld(player.field_70170_p);
        if (chargers.isEmpty()) {
            return;
        }
        BlockCoord bc = new BlockCoord((int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        for (IWirelessCharger capBank : chargers.values()) {
            boolean done;
            if (capBank.getLocation().distanceSquared(bc) > RANGE_SQ || !(done = this.chargeFromCapBank(player, capBank))) continue;
            return;
        }
    }

    private boolean chargeFromCapBank(EntityPlayer player, IWirelessCharger capBank) {
        boolean res = capBank.chargeItems(player.field_71071_by.field_70460_b);
        return res |= capBank.chargeItems(player.field_71071_by.field_70462_a);
    }

    private Map<BlockCoord, IWirelessCharger> getChargersForWorld(World world) {
        Map<BlockCoord, IWirelessCharger> res = this.perWorldChargers.get(world.field_73011_w.field_76574_g);
        if (res == null) {
            res = new HashMap<BlockCoord, IWirelessCharger>();
            this.perWorldChargers.put(world.field_73011_w.field_76574_g, res);
        }
        return res;
    }

    public Collection<IWirelessCharger> getChargers(World world) {
        return this.getChargerMap(world).values();
    }

    public Map<BlockCoord, IWirelessCharger> getChargerMap(World world) {
        return this.perWorldChargers.get(world.field_73011_w.field_76574_g);
    }

    static {
        FMLCommonHandler.instance().bus().register((Object)instance);
        MinecraftForge.EVENT_BUS.register((Object)instance);
    }
}

