/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.xp;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import crazypants.enderio.EnderIOTab;
import crazypants.enderio.ModObject;
import crazypants.enderio.gui.IResourceTooltipProvider;
import crazypants.enderio.machine.xp.PacketXpTransferEffects;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.xp.XpUtil;
import crazypants.util.Util;
import crazypants.vecmath.Vector3d;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class ItemXpTransfer
extends Item
implements IResourceTooltipProvider {
    public static ItemXpTransfer create() {
        PacketHandler.INSTANCE.registerMessage(PacketXpTransferEffects.class, PacketXpTransferEffects.class, PacketHandler.nextID(), Side.CLIENT);
        ItemXpTransfer result = new ItemXpTransfer();
        result.init();
        return result;
    }

    protected ItemXpTransfer() {
        this.func_77637_a(EnderIOTab.tabEnderIO);
        this.func_77655_b(ModObject.itemXpTransfer.unlocalisedName);
        this.func_77625_d(1);
        this.func_77627_a(true);
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        return ItemXpTransfer.onActivated(player, world, x, y, z, side);
    }

    public static boolean onActivated(EntityPlayer player, World world, int x, int y, int z, int side) {
        boolean res;
        if (world.field_72995_K) {
            return false;
        }
        boolean swing = false;
        if (player.func_70093_af()) {
            swing = res = ItemXpTransfer.tranferFromPlayerToBlock(player, world, x, y, z, side);
        } else {
            res = ItemXpTransfer.tranferFromBlockToPlayer(player, world, x, y, z, side);
        }
        if (res) {
            ItemXpTransfer.sendXPUpdate(player, world, x, y, z, swing);
        }
        return res;
    }

    public static void sendXPUpdate(EntityPlayer player, World world, int x, int y, int z, boolean swing) {
        Vector3d look = Util.getLookVecEio(player);
        double xP = player.field_70165_t + look.x;
        double yP = player.field_70163_u + 1.5;
        double zP = player.field_70161_v + look.z;
        NetworkRegistry.TargetPoint tp = new NetworkRegistry.TargetPoint(player.field_71093_bK, (double)x, (double)y, (double)z, 32.0);
        PacketHandler.INSTANCE.sendTo((IMessage)new PacketXpTransferEffects(swing, xP, yP, zP), (EntityPlayerMP)player);
        world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.orb", 0.1f, 0.5f * ((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.7f + 1.8f));
    }

    public static boolean tranferFromBlockToPlayer(EntityPlayer player, World world, int x, int y, int z, int side) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof IFluidHandler)) {
            return false;
        }
        IFluidHandler fh = (IFluidHandler)te;
        ForgeDirection dir = ForgeDirection.getOrientation((int)side);
        if (!fh.canDrain(dir, EnderIO.fluidXpJuice)) {
            return false;
        }
        int currentXP = XpUtil.getPlayerXP(player);
        int nextLevelXP = XpUtil.getExperienceForLevel(player.field_71068_ca + 1) + 1;
        int requiredXP = nextLevelXP - currentXP;
        int fluidVolume = XpUtil.experienceToLiquid(requiredXP);
        FluidStack fs = new FluidStack(EnderIO.fluidXpJuice, fluidVolume);
        FluidStack res = fh.drain(dir, fs, true);
        if (res == null || res.amount <= 0) {
            return false;
        }
        int xpToGive = XpUtil.liquidToExperiance(res.amount);
        player.func_71023_q(xpToGive);
        return true;
    }

    public static boolean tranferFromPlayerToBlock(EntityPlayer player, World world, int x, int y, int z, int side) {
        if (player.field_71067_cb <= 0) {
            return false;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof IFluidHandler)) {
            return false;
        }
        IFluidHandler fh = (IFluidHandler)te;
        ForgeDirection dir = ForgeDirection.getOrientation((int)side);
        if (!fh.canFill(dir, EnderIO.fluidXpJuice)) {
            return false;
        }
        int fluidVolume = XpUtil.experienceToLiquid(XpUtil.getPlayerXP(player));
        FluidStack fs = new FluidStack(EnderIO.fluidXpJuice, fluidVolume);
        int takenVolume = fh.fill(dir, fs, true);
        if (takenVolume <= 0) {
            return false;
        }
        int xpToTake = XpUtil.liquidToExperiance(takenVolume);
        XpUtil.addPlayerXP(player, -xpToTake);
        return true;
    }

    protected void init() {
        GameRegistry.registerItem((Item)this, (String)ModObject.itemXpTransfer.unlocalisedName);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister IIconRegister2) {
        this.field_77791_bV = IIconRegister2.func_94245_a("enderio:xpTransfer");
    }

    @Override
    public String getUnlocalizedNameForTooltip(ItemStack stack) {
        return this.func_77658_a();
    }

    public boolean doesSneakBypassUse(World world, int x, int y, int z, EntityPlayer player) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }
}

