/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.material;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.BlockEio;
import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.machine.painter.PainterUtil;
import crazypants.enderio.machine.painter.TileEntityPaintedBlock;
import crazypants.enderio.material.ItemFusedQuartz;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockFusedQuartz
extends BlockEio {
    public static int renderId;
    IIcon[] field_149761_L;
    IIcon[] itemsIcons;
    IIcon[] frameIcons;

    public static BlockFusedQuartz create() {
        BlockFusedQuartz result = new BlockFusedQuartz();
        result.init();
        return result;
    }

    private BlockFusedQuartz() {
        super(ModObject.blockFusedQuartz.unlocalisedName, TileEntityPaintedBlock.class, Material.field_151592_s);
        this.func_149672_a(Block.field_149778_k);
    }

    @Override
    protected void init() {
        GameRegistry.registerBlock((Block)this, ItemFusedQuartz.class, (String)this.name);
        if (this.teClass != null) {
            GameRegistry.registerTileEntity((Class)this.teClass, (String)(this.name + "TileEntity"));
        }
    }

    public float getExplosionResistance(Entity par1Entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        int meta = world.func_72805_g(x, y, z);
        if ((meta = MathHelper.func_76125_a((int)meta, (int)0, (int)1)) == 0) {
            return 2000.0f;
        }
        return super.func_149638_a(par1Entity);
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public int func_149645_b() {
        return renderId;
    }

    public int getLightOpacity(IBlockAccess world, int x, int y, int z) {
        return 0;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        if (block != this) {
            return super.getLightValue(world, x, y, z);
        }
        int meta = world.func_72805_g(x, y, z);
        if (meta > 1) {
            return 15;
        }
        return super.getLightValue(world, x, y, z);
    }

    public int func_149692_a(int par1) {
        return par1;
    }

    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (int j = 0; j < Type.values().length; ++j) {
            par3List.add(new ItemStack(par1, 1, j));
        }
    }

    public boolean func_149646_a(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        Block i1 = par1IBlockAccess.func_147439_a(par2, par3, par4);
        return i1 == this ? false : super.func_149646_a(par1IBlockAccess, par2, par3, par4, par5);
    }

    public boolean func_149747_d(IBlockAccess p_149747_1_, int p_149747_2_, int p_149747_3_, int p_149747_4_, int p_149747_5_) {
        return true;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return side != ForgeDirection.UP;
    }

    public boolean canPlaceTorchOnTop(World arg0, int arg1, int arg2, int arg3) {
        return true;
    }

    @Override
    public void func_149651_a(IIconRegister iIconRegister) {
        Type[] ts = Type.values();
        this.field_149761_L = new IIcon[ts.length];
        this.itemsIcons = new IIcon[ts.length];
        this.frameIcons = new IIcon[ts.length];
        for (int i = 0; i < ts.length; ++i) {
            this.field_149761_L[i] = iIconRegister.func_94245_a(ts[i].blockIcon);
            this.itemsIcons[i] = iIconRegister.func_94245_a(ts[i].itemIcon);
            this.frameIcons[i] = iIconRegister.func_94245_a(ts[i].frameIcon);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int par1, int meta) {
        meta = MathHelper.func_76125_a((int)meta, (int)0, (int)(Type.values().length - 1));
        return this.field_149761_L[meta];
    }

    public IIcon getItemIcon(int meta) {
        meta = MathHelper.func_76125_a((int)meta, (int)0, (int)(Type.values().length - 1));
        return this.itemsIcons[meta];
    }

    public IIcon getDefaultFrameIcon(int meta) {
        meta = MathHelper.func_76125_a((int)meta, (int)0, (int)(Type.values().length - 1));
        return this.frameIcons[meta];
    }

    public void func_149749_a(World world, int x, int y, int z, Block par5, int par6) {
        TileEntity te;
        if (!world.field_72995_K && world.func_82736_K().func_82766_b("doTileDrops") && (te = world.func_147438_o(x, y, z)) instanceof TileEntityPaintedBlock) {
            TileEntityPaintedBlock tef = (TileEntityPaintedBlock)te;
            ItemStack itemStack = this.createItemStackForSourceBlock(world.func_72805_g(x, y, z), tef.getSourceBlock(), tef.getSourceBlockMetadata());
            if (itemStack != null) {
                float f = 0.7f;
                double d0 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d1 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                EntityItem entityitem = new EntityItem(world, (double)x + d0, (double)y + d1, (double)z + d2, itemStack);
                entityitem.field_145804_b = 10;
                world.func_72838_d((Entity)entityitem);
            }
        }
        super.func_149749_a(world, x, y, z, par5, par6);
    }

    private ItemStack createItemStackForSourceBlock(int quartzBlockMeta, Block sourceBlock, int sourceBlockMetadata) {
        if (sourceBlock == null) {
            return null;
        }
        ItemStack result = new ItemStack((Item)EnderIO.itemFusedQuartzFrame, 1, quartzBlockMeta);
        PainterUtil.setSourceBlock(result, sourceBlock, sourceBlockMetadata);
        return result;
    }

    public static enum Type {
        FUSED_QUARTZ("fusedQuartz", "enderio:fusedQuartz", "enderio:fusedQuartzFrame", "enderio:fusedQuartzItem"),
        GLASS("fusedGlass", "enderio:fusedGlass", "enderio:fusedGlassFrame", "enderio:fusedGlassItem"),
        ENLIGHTENED_FUSED_QUARTZ("enlightenedFusedQuartz", "enderio:fusedQuartz", "enderio:fusedQuartzFrame", "enderio:fusedQuartzItem"),
        ENLIGHTENED_GLASS("enlightenedFusedGlass", "enderio:fusedGlass", "enderio:fusedGlassFrame", "enderio:fusedGlassItem");

        final String unlocalisedName;
        final String blockIcon;
        final String frameIcon;
        final String itemIcon;

        private Type(String unlocalisedName, String blockIcon, String frameIcon, String itemIcon) {
            this.unlocalisedName = unlocalisedName;
            this.frameIcon = frameIcon;
            this.blockIcon = blockIcon;
            this.itemIcon = itemIcon;
        }
    }
}

