/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.network;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import crazypants.enderio.Log;
import io.netty.buffer.ByteBuf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public abstract class MessageTileEntity<T extends TileEntity>
implements IMessage {
    protected int x;
    protected int y;
    protected int z;
    private Class<? extends TileEntity> tileClass;

    protected MessageTileEntity() {
    }

    protected MessageTileEntity(T tile) {
        this.tileClass = tile.getClass();
        this.x = ((TileEntity)tile).field_145851_c;
        this.y = ((TileEntity)tile).field_145848_d;
        this.z = ((TileEntity)tile).field_145849_e;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.tileClass.getName());
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        String str = ByteBufUtils.readUTF8String((ByteBuf)buf);
        try {
            this.tileClass = Class.forName(str);
        }
        catch (Exception e) {
            Log.error("AbstractPacketTileEntity could not load tile entity class: " + str);
        }
    }

    protected T getTileEntity(World worldObj) {
        if (worldObj == null) {
            return null;
        }
        TileEntity te = worldObj.func_147438_o(this.x, this.y, this.z);
        if (te == null) {
            return null;
        }
        if (this.tileClass.isAssignableFrom(te.getClass())) {
            return (T)te;
        }
        return null;
    }

    protected World getWorld(MessageContext ctx) {
        return ctx.getServerHandler().field_147369_b.field_70170_p;
    }
}

