/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.power;

import cofh.api.energy.IEnergyConnection;
import cofh.api.energy.IEnergyHandler;
import crazypants.enderio.power.IInternalPowerReceptor;
import crazypants.enderio.power.IPowerInterface;
import crazypants.enderio.power.PowerInterfaceConnectionRF;
import crazypants.enderio.power.PowerInterfaceRF;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class PowerHandlerUtil {
    public static IPowerInterface create(Object o) {
        if (o instanceof IEnergyHandler) {
            return new PowerInterfaceRF((IEnergyHandler)o);
        }
        if (o instanceof IEnergyConnection) {
            return new PowerInterfaceConnectionRF((IEnergyConnection)o);
        }
        return null;
    }

    public static int getStoredEnergyForItem(ItemStack item) {
        NBTTagCompound tag = item.func_77978_p();
        if (tag == null) {
            return 0;
        }
        if (tag.func_74764_b("storedEnergy")) {
            double storedMj = tag.func_74769_h("storedEnergy");
            return (int)(storedMj * 10.0);
        }
        return tag.func_74762_e("storedEnergyRF");
    }

    public static void setStoredEnergyForItem(ItemStack item, int storedEnergy) {
        NBTTagCompound tag = item.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
        }
        tag.func_74768_a("storedEnergyRF", storedEnergy);
        item.func_77982_d(tag);
    }

    public static int recieveInternal(IInternalPowerReceptor target, int maxReceive, ForgeDirection from, boolean simulate) {
        int result = Math.min(target.getMaxEnergyRecieved(from), maxReceive);
        result = Math.min(target.getMaxEnergyStored() - target.getEnergyStored(), result);
        if (result > 0 && !simulate) {
            target.setEnergyStored(target.getEnergyStored() + result);
        }
        return result;
    }
}

