/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.rail;

import crazypants.enderio.config.Config;
import crazypants.enderio.machine.transceiver.TileTransceiver;
import crazypants.enderio.rail.BlockEnderRail;
import crazypants.enderio.rail.CartLinkUtil;
import crazypants.enderio.rail.TeleportUtil;
import crazypants.util.BlockCoord;
import crazypants.util.EntityUtil;
import crazypants.util.ForgeDirectionOffsets;
import crazypants.vecmath.Vector3d;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ForgeDirection;

public class EnderRailController {
    private final Set<UUID> newlySpawnedCarts = new HashSet<UUID>();
    private final LinkedList<List<Entity>> cartsToSpawn = new LinkedList();
    private final List<PlayerTpInfo> playersToRemount = new ArrayList<PlayerTpInfo>();
    private int ticksFailedToSpawn = 0;
    private NBTTagList cartList;
    private final TileTransceiver transciever;

    public EnderRailController(TileTransceiver tileTransceiver) {
        this.transciever = tileTransceiver;
    }

    public void doTick() {
        if (this.cartList != null) {
            this.loadCartsToSpawn();
            this.cartList = null;
        }
        this.spawnRecievedCart();
        List<EntityMinecart> carts = this.getMinecartsOnTrack();
        ArrayList<UUID> toRemove = new ArrayList<UUID>();
        for (UUID recievedCartUID : this.newlySpawnedCarts) {
            EntityMinecart minecart = this.getMinecartWthUUID(recievedCartUID, carts);
            if (minecart != null) continue;
            toRemove.add(recievedCartUID);
        }
        for (UUID recievedCart : toRemove) {
            this.newlySpawnedCarts.remove(recievedCart);
        }
    }

    private EntityMinecart getMinecartWthUUID(UUID recievedCartUID, Collection<EntityMinecart> carts) {
        for (EntityMinecart cart : carts) {
            if (!recievedCartUID.equals(cart.getPersistentID())) continue;
            return cart;
        }
        return null;
    }

    private void spawnRecievedCart() {
        if (Config.enderRailTeleportPlayers) {
            ListIterator<PlayerTpInfo> li = this.playersToRemount.listIterator();
            while (li.hasNext()) {
                PlayerTpInfo tpi = li.next();
                if (!tpi.attemptMount() && tpi.attemptsRemaining > 0) continue;
                li.remove();
            }
        }
        if (this.cartsToSpawn.isEmpty()) {
            this.ticksFailedToSpawn = 0;
            return;
        }
        boolean failedSpawn = false;
        if (!this.isClear()) {
            ++this.ticksFailedToSpawn;
            if (this.ticksFailedToSpawn < Config.enderRailTicksBeforeForceSpawningLinkedCarts) {
                return;
            }
            failedSpawn = true;
        }
        List<Entity> spawnThisTick = this.cartsToSpawn.removeFirst();
        for (Entity ent : spawnThisTick) {
            if (failedSpawn) {
                this.doRandomSpawn(ent);
                continue;
            }
            EntityMinecart cart = null;
            if (ent instanceof EntityMinecart) {
                cart = (EntityMinecart)ent;
                this.setCartDirection(cart);
            }
            TeleportUtil.spawn(this.transciever.func_145831_w(), ent);
            if (cart == null) continue;
            this.newlySpawnedCarts.add(cart.getPersistentID());
            CartLinkUtil.instance.recreateLinks(cart);
        }
        this.ticksFailedToSpawn = 0;
    }

    private void setCartDirection(EntityMinecart cart) {
        int meta = this.transciever.func_145831_w().func_72805_g(this.transciever.field_145851_c, this.transciever.field_145848_d + 1, this.transciever.field_145849_e);
        ForgeDirection dir = BlockEnderRail.getDirection(meta);
        double velocity = Math.max(Math.abs(cart.field_70159_w), Math.abs(cart.field_70179_y));
        cart.field_70159_w = (double)dir.offsetX * velocity;
        cart.field_70179_y = (double)dir.offsetZ * velocity;
    }

    public void onTrainRecieved(List<List<Entity>> toTeleport) {
        this.cartsToSpawn.addAll(toTeleport);
    }

    public boolean isRecievedCart(EntityMinecart mc) {
        return this.newlySpawnedCarts.contains(mc.getPersistentID());
    }

    public boolean isClear() {
        World worldObj = this.transciever.func_145831_w();
        BlockCoord railCoord = new BlockCoord(this.transciever).getLocation(ForgeDirection.UP);
        int meta = worldObj.func_72805_g(railCoord.x, railCoord.y, railCoord.z);
        double buf = 1.0;
        ForgeDirection dir = BlockEnderRail.getDirection(meta);
        Vector3d offset = ForgeDirectionOffsets.forDirCopy(dir);
        offset.scale(buf);
        offset.x = Math.abs(offset.x);
        offset.z = Math.abs(offset.z);
        List res = worldObj.func_72872_a(Entity.class, AxisAlignedBB.func_72330_a((double)((double)railCoord.x - offset.x), (double)railCoord.y, (double)((double)railCoord.z - offset.z), (double)((double)(railCoord.x + 1) + offset.x), (double)(railCoord.y + 1), (double)((double)(railCoord.z + 1) + offset.z)));
        return res == null || res.isEmpty();
    }

    public List<EntityMinecart> getMinecartsOnTrack() {
        return EnderRailController.getMinecartsAt(this.transciever.func_145831_w(), this.transciever.field_145851_c, this.transciever.field_145848_d + 1, this.transciever.field_145849_e);
    }

    public static List<EntityMinecart> getMinecartsAt(World world, int x, int y, int z) {
        List entities = world.func_72872_a(EntityMinecart.class, AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1)));
        ArrayList<EntityMinecart> carts = new ArrayList<EntityMinecart>();
        for (Object o : entities) {
            EntityMinecart cart = (EntityMinecart)o;
            if (cart.field_70128_L) continue;
            carts.add((EntityMinecart)o);
        }
        return carts;
    }

    private void loadCartsToSpawn() {
        World worldObj = this.transciever.func_145831_w();
        while (this.cartList.func_74745_c() > 0) {
            NBTTagList entityList = (NBTTagList)this.cartList.func_74744_a(0);
            ArrayList<Entity> ents = new ArrayList<Entity>(entityList.func_74745_c());
            for (int i = 0; i < entityList.func_74745_c(); ++i) {
                NBTTagCompound entityRoot = entityList.func_150305_b(i);
                Entity entity = EntityList.func_75615_a((NBTTagCompound)entityRoot, (World)worldObj);
                if (entity == null) continue;
                ents.add(entity);
            }
            this.cartsToSpawn.add(ents);
        }
    }

    public void readFromNBT(NBTTagCompound root) {
        this.cartsToSpawn.clear();
        if (!root.func_74764_b("cartList")) {
            return;
        }
        this.cartList = (NBTTagList)root.func_74781_a("cartList");
        this.newlySpawnedCarts.clear();
        if (root.func_74764_b("newlySpawnedCarts")) {
            NBTTagList spawnedCartList = (NBTTagList)root.func_74781_a("newlySpawnedCarts");
            for (int i = 0; i < spawnedCartList.func_74745_c(); ++i) {
                String uuisStr = spawnedCartList.func_150307_f(i);
                this.newlySpawnedCarts.add(UUID.fromString(uuisStr));
            }
        }
    }

    public void writeToNBT(NBTTagCompound root) {
        if (this.cartsToSpawn.isEmpty()) {
            return;
        }
        NBTTagList cartList = new NBTTagList();
        for (List list : this.cartsToSpawn) {
            if (list == null || list.isEmpty()) continue;
            NBTTagList entityList = new NBTTagList();
            cartList.func_74742_a((NBTBase)entityList);
            for (Entity entity : list) {
                NBTTagCompound entRoot = new NBTTagCompound();
                entRoot.func_74778_a("id", EntityList.func_75621_b((Entity)entity));
                entity.func_70109_d(entRoot);
                entityList.func_74742_a((NBTBase)entRoot);
            }
        }
        root.func_74782_a("cartList", (NBTBase)cartList);
        if (!this.newlySpawnedCarts.isEmpty()) {
            NBTTagList spawnedCartList = new NBTTagList();
            for (UUID uuid : this.newlySpawnedCarts) {
                spawnedCartList.func_74742_a((NBTBase)new NBTTagString(uuid.toString()));
            }
            root.func_74782_a("newlySpawnedCarts", (NBTBase)spawnedCartList);
        }
    }

    public void dropNonSpawnedCarts() {
        if (this.cartsToSpawn.isEmpty()) {
            return;
        }
        for (List list : this.cartsToSpawn) {
            for (Entity entity : list) {
                this.doRandomSpawn(entity);
            }
        }
        this.cartsToSpawn.clear();
    }

    private void doRandomSpawn(Entity entity) {
        if (entity == null) {
            return;
        }
        double oX = entity.field_70165_t;
        double oZ = entity.field_70161_v;
        World world = this.transciever.func_145831_w();
        MinecraftServer minecraftserver = MinecraftServer.func_71276_C();
        WorldServer worldserver = minecraftserver.func_71218_a(world.field_73011_w.field_76574_g);
        for (int i = 0; i < 4; ++i) {
            int x = this.transciever.field_145851_c + this.randOffset(2);
            int y = this.transciever.field_145848_d + 1;
            int z = this.transciever.field_145849_e + this.randOffset(2);
            Block b = world.func_147439_a(x, y, z);
            entity.func_70107_b((double)x + 0.5, entity.field_70163_u, (double)z + 0.5);
            if (!world.func_147472_a(b, x, y, z, false, ForgeDirection.UP.ordinal(), entity, null)) continue;
            this.resetForRandomRandomSpawn(entity);
            if (!worldserver.func_72838_d(entity)) continue;
            worldserver.func_72870_g(entity);
            return;
        }
        entity.func_70107_b(oX, entity.field_70163_u, oZ);
        this.resetForRandomRandomSpawn(entity);
        worldserver.func_72838_d(entity);
    }

    private void resetForRandomRandomSpawn(Entity entity) {
        CartLinkUtil.instance.breakLinks(this.transciever.func_145831_w(), entity);
        entity.field_70153_n = null;
        entity.field_70154_o = null;
        entity.field_70159_w = 0.0;
        entity.field_70181_x = 0.0;
        entity.field_70179_y = 0.0;
        entity.field_70169_q = entity.field_70165_t;
        entity.field_70167_r = entity.field_70163_u;
        entity.field_70166_s = entity.field_70161_v;
        entity.field_70177_z = (float)(this.transciever.func_145831_w().field_73012_v.nextDouble() * 360.0);
    }

    private int randOffset(int spread) {
        return (int)Math.round((this.transciever.func_145831_w().field_73012_v.nextDouble() - 0.5) * (double)spread * 2.0);
    }

    public void onPlayerTeleported(EntityPlayerMP playerToTP, EntityMinecart toMount) {
        if (playerToTP != null) {
            this.playersToRemount.add(new PlayerTpInfo(playerToTP.func_70005_c_(), toMount.getPersistentID(), 20));
        }
    }

    private class PlayerTpInfo {
        String playerName;
        UUID cartId;
        int attemptsRemaining;

        PlayerTpInfo(String playerName, UUID cartId, int attemptsRemaining) {
            this.playerName = playerName;
            this.cartId = cartId;
            this.attemptsRemaining = attemptsRemaining;
        }

        boolean attemptMount() {
            --this.attemptsRemaining;
            List<EntityMinecart> carts = EnderRailController.this.getMinecartsOnTrack();
            for (EntityMinecart cart : carts) {
                Vector3d cartPos;
                Vector3d playerPos;
                EntityPlayer player;
                if (cart == null || !cart.getPersistentID().equals(this.cartId) || (player = EnderRailController.this.transciever.func_145831_w().func_72924_a(this.playerName)) == null || !((playerPos = EntityUtil.getEntityPosition((Entity)player)).distanceSquared(cartPos = EntityUtil.getEntityPosition((Entity)cart)) <= 9.0)) continue;
                player.field_70165_t = cart.field_70165_t;
                player.field_70163_u = cart.field_70163_u;
                player.field_70161_v = cart.field_70161_v;
                player.func_70078_a((Entity)cart);
                return true;
            }
            return false;
        }
    }
}

