/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.teleport;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.BlockEio;
import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.config.Config;
import crazypants.enderio.gui.IResourceTooltipProvider;
import crazypants.enderio.machine.IMachineRecipe;
import crazypants.enderio.machine.MachineRecipeInput;
import crazypants.enderio.machine.MachineRecipeRegistry;
import crazypants.enderio.machine.painter.BasicPainterTemplate;
import crazypants.enderio.machine.painter.PainterUtil;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.teleport.ConnectionHandler;
import crazypants.enderio.teleport.ContainerTravelAccessable;
import crazypants.enderio.teleport.ContainerTravelAuth;
import crazypants.enderio.teleport.GuiTravelAccessable;
import crazypants.enderio.teleport.GuiTravelAuth;
import crazypants.enderio.teleport.ITravelAccessable;
import crazypants.enderio.teleport.TileTravelAnchor;
import crazypants.enderio.teleport.packet.PacketAccessMode;
import crazypants.enderio.teleport.packet.PacketConfigSync;
import crazypants.enderio.teleport.packet.PacketDrainStaff;
import crazypants.enderio.teleport.packet.PacketLabel;
import crazypants.enderio.teleport.packet.PacketOpenAuthGui;
import crazypants.enderio.teleport.packet.PacketTravelEvent;
import crazypants.util.Lang;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockTravelAnchor
extends BlockEio
implements IGuiHandler,
ITileEntityProvider,
IResourceTooltipProvider {
    public static int renderId = -1;
    IIcon selectedOverlayIcon;
    IIcon highlightOverlayIcon;

    public static BlockTravelAnchor create() {
        PacketHandler.INSTANCE.registerMessage(PacketAccessMode.class, PacketAccessMode.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketLabel.class, PacketLabel.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketTravelEvent.class, PacketTravelEvent.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketDrainStaff.class, PacketDrainStaff.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketOpenAuthGui.class, PacketOpenAuthGui.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketConfigSync.class, PacketConfigSync.class, PacketHandler.nextID(), Side.CLIENT);
        ConnectionHandler ch = new ConnectionHandler();
        FMLCommonHandler.instance().bus().register((Object)ch);
        BlockTravelAnchor result = new BlockTravelAnchor();
        result.init();
        return result;
    }

    private BlockTravelAnchor() {
        super(ModObject.blockTravelAnchor.unlocalisedName, TileTravelAnchor.class);
        if (!Config.travelAnchorEnabled) {
            this.func_149647_a(null);
        }
    }

    @Override
    protected void init() {
        super.init();
        EnderIO.guiHandler.registerGuiHandler(18, this);
        EnderIO.guiHandler.registerGuiHandler(19, this);
        MachineRecipeRegistry.instance.registerRecipe(ModObject.blockPainter.unlocalisedName, new PainterTemplate((Block)this));
    }

    @Override
    public void func_149651_a(IIconRegister iIconRegister) {
        super.func_149651_a(iIconRegister);
        this.highlightOverlayIcon = iIconRegister.func_94245_a("enderio:blockTravelAnchorHighlight");
        this.selectedOverlayIcon = iIconRegister.func_94245_a("enderio:blockTravelAnchorSelected");
    }

    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int blockSide) {
        TileTravelAnchor tef;
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileTravelAnchor && (tef = (TileTravelAnchor)te).getSourceBlock() != null) {
            return tef.getSourceBlock().func_149691_a(blockSide, tef.getSourceBlockMetadata());
        }
        return super.func_149673_e(world, x, y, z, blockSide);
    }

    public TileEntity func_149915_a(World var1, int var2) {
        return new TileTravelAnchor();
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack par6ItemStack) {
        TileEntity te;
        if (entity instanceof EntityPlayer && (te = world.func_147438_o(x, y, z)) instanceof TileTravelAnchor) {
            TileTravelAnchor ta = (TileTravelAnchor)te;
            ta.setPlacedBy((EntityPlayer)entity);
            Block b = PainterUtil.getSourceBlock(par6ItemStack);
            ta.setSourceBlock(b);
            ta.setSourceBlockMetadata(PainterUtil.getSourceBlockMetadata(par6ItemStack));
            world.func_147471_g(x, y, z);
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityPlayer, int par6, float par7, float par8, float par9) {
        if (entityPlayer.func_70093_af()) {
            return false;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof ITravelAccessable) {
            ITravelAccessable ta = (ITravelAccessable)te;
            if (ta.canUiBeAccessed(entityPlayer)) {
                if (!world.field_72995_K) {
                    entityPlayer.openGui((Object)EnderIO.instance, 18, world, x, y, z);
                }
            } else if (world.field_72995_K) {
                entityPlayer.func_146105_b((IChatComponent)new ChatComponentText(Lang.localize("gui.travelAccessable.privateBlock1") + " " + ta.getPlacedBy() + " " + Lang.localize("gui.travelAccessable.privateBlock2")));
            }
            return true;
        }
        return false;
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof ITravelAccessable) {
            if (ID == 18) {
                return new ContainerTravelAccessable(player.field_71071_by, (ITravelAccessable)te, world);
            }
            return new ContainerTravelAuth(player.field_71071_by);
        }
        return null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof ITravelAccessable) {
            if (ID == 18) {
                return new GuiTravelAccessable(player.field_71071_by, (ITravelAccessable)te, world);
            }
            return new GuiTravelAuth(player, (ITravelAccessable)te, world);
        }
        return null;
    }

    public void func_149749_a(World world, int x, int y, int z, Block par5, int par6) {
        TileEntity te;
        if (!world.field_72995_K && world.func_82736_K().func_82766_b("doTileDrops") && (te = world.func_147438_o(x, y, z)) instanceof TileTravelAnchor) {
            TileTravelAnchor tef = (TileTravelAnchor)te;
            Block srcBlk = tef.getSourceBlock();
            ItemStack itemStack = srcBlk != null ? BlockTravelAnchor.createItemStackForSourceBlock(tef.getSourceBlock(), tef.getSourceBlockMetadata()) : new ItemStack((Block)this);
            float f = 0.7f;
            double d0 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d1 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            EntityItem entityitem = new EntityItem(world, (double)x + d0, (double)y + d1, (double)z + d2, itemStack);
            entityitem.field_145804_b = 10;
            world.func_72838_d((Entity)entityitem);
        }
        world.func_147475_p(x, y, z);
    }

    public int func_149745_a(Random par1Random) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess world, int x, int y, int z) {
        TileTravelAnchor tef;
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileTravelAnchor && (tef = (TileTravelAnchor)te).getSourceBlock() != null) {
            return tef.getSourceBlock().func_149720_d(world, x, y, z);
        }
        return super.func_149720_d(world, x, y, z);
    }

    public int func_149645_b() {
        return renderId;
    }

    @Override
    public String getUnlocalizedNameForTooltip(ItemStack itemStack) {
        return this.func_149739_a();
    }

    public static ItemStack createItemStackForSourceBlock(Block block, int damage) {
        ItemStack result = new ItemStack((Block)EnderIO.blockTravelPlatform, 1, damage);
        PainterUtil.setSourceBlock(result, block, damage);
        return result;
    }

    public boolean func_149662_c() {
        return false;
    }

    public static final class PainterTemplate
    extends BasicPainterTemplate {
        public PainterTemplate(Block ta) {
            super(ta);
        }

        @Override
        public IMachineRecipe.ResultStack[] getCompletedResult(float chance, MachineRecipeInput ... inputs) {
            ItemStack paintSource = MachineRecipeInput.getInputForSlot(1, inputs);
            if (paintSource == null) {
                return new IMachineRecipe.ResultStack[0];
            }
            if (paintSource.func_77973_b() == Item.func_150898_a((Block)EnderIO.blockTravelPlatform)) {
                return new IMachineRecipe.ResultStack[]{new IMachineRecipe.ResultStack(new ItemStack((Block)EnderIO.blockTravelPlatform))};
            }
            return new IMachineRecipe.ResultStack[]{new IMachineRecipe.ResultStack(BlockTravelAnchor.createItemStackForSourceBlock(Block.func_149634_a((Item)paintSource.func_77973_b()), paintSource.func_77960_j()))};
        }
    }
}

