/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.teleport;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.TileEntityEio;
import crazypants.enderio.machine.painter.IPaintableTileEntity;
import crazypants.enderio.teleport.ITravelAccessable;
import crazypants.enderio.teleport.TravelSource;
import crazypants.util.BlockCoord;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;

public class TileTravelAnchor
extends TileEntityEio
implements ITravelAccessable,
IPaintableTileEntity {
    private static final String KEY_SOURCE_BLOCK_ID = "sourceBlock";
    private static final String KEY_SOURCE_BLOCK_META = "sourceBlockMeta";
    private Block sourceBlock;
    private int sourceBlockMetadata;
    private AccessMode accessMode = AccessMode.PUBLIC;
    private ItemStack[] password = new ItemStack[5];
    private ItemStack itemLabel;
    private String label;
    private String placedBy;
    private List<String> authorisedUsers = new ArrayList<String>();

    @Override
    public boolean canBlockBeAccessed(EntityPlayer playerName) {
        if (this.accessMode == AccessMode.PUBLIC) {
            return true;
        }
        if (this.accessMode == AccessMode.PRIVATE) {
            return this.placedBy != null && this.placedBy.equals(playerName.func_146103_bH().getName());
        }
        if (this.placedBy != null && this.placedBy.equals(playerName.func_146103_bH().getName())) {
            return true;
        }
        return this.authorisedUsers.contains(playerName.func_146103_bH().getName());
    }

    @Override
    public void clearAuthorisedUsers() {
        this.authorisedUsers.clear();
    }

    @Override
    public BlockCoord getLocation() {
        return new BlockCoord(this);
    }

    private boolean checkPassword(ItemStack[] pwd) {
        if (pwd == null || pwd.length != this.password.length) {
            return false;
        }
        for (int i = 0; i < pwd.length; ++i) {
            ItemStack pw = this.password[i];
            ItemStack tst = pwd[i];
            if (pw == null && tst != null) {
                return false;
            }
            if (pw == null || tst != null && ItemStack.func_77989_b((ItemStack)pw, (ItemStack)tst)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean getRequiresPassword(EntityPlayer username) {
        return this.getAccessMode() != AccessMode.PUBLIC && !this.canUiBeAccessed(username) && !this.authorisedUsers.contains(username.func_146103_bH().getName());
    }

    @Override
    public boolean authoriseUser(EntityPlayer username, ItemStack[] password) {
        if (this.checkPassword(password)) {
            this.authorisedUsers.add(username.func_146103_bH().getName());
            return true;
        }
        return false;
    }

    @Override
    public boolean canUiBeAccessed(EntityPlayer playerName) {
        return this.placedBy != null && this.placedBy.equals(playerName.func_146103_bH().getName());
    }

    @Override
    public boolean canSeeBlock(EntityPlayer playerName) {
        if (this.accessMode != AccessMode.PRIVATE) {
            return true;
        }
        return this.placedBy != null && this.placedBy.equals(playerName.func_146103_bH().getName());
    }

    @Override
    public AccessMode getAccessMode() {
        return this.accessMode;
    }

    @Override
    public void setAccessMode(AccessMode accessMode) {
        this.accessMode = accessMode;
    }

    @Override
    public ItemStack[] getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(ItemStack[] password) {
        this.password = password;
    }

    @Override
    public ItemStack getItemLabel() {
        return this.itemLabel;
    }

    @Override
    public void setItemLabel(ItemStack lableIcon) {
        this.itemLabel = lableIcon;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public String getPlacedBy() {
        return this.placedBy;
    }

    @Override
    public void setPlacedBy(EntityPlayer player) {
        this.placedBy = player == null || player.func_146103_bH() == null ? null : player.func_146103_bH().getName();
    }

    public boolean canUpdate() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return TravelSource.getMaxDistanceSq();
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    @Override
    public Block getSourceBlock() {
        return this.sourceBlock;
    }

    @Override
    public void setSourceBlock(Block sourceBlock) {
        this.sourceBlock = sourceBlock;
    }

    @Override
    public int getSourceBlockMetadata() {
        return this.sourceBlockMetadata;
    }

    @Override
    public void setSourceBlockMetadata(int sourceBlockMetadata) {
        this.sourceBlockMetadata = sourceBlockMetadata;
    }

    @Override
    protected void readCustomNBT(NBTTagCompound root) {
        NBTTagCompound stackRoot;
        this.accessMode = root.func_74764_b("accessMode") ? AccessMode.values()[root.func_74765_d("accessMode")] : AccessMode.PUBLIC;
        this.placedBy = root.func_74779_i("placedBy");
        for (int i = 0; i < this.password.length; ++i) {
            if (root.func_74764_b("password" + i)) {
                stackRoot = (NBTTagCompound)root.func_74781_a("password" + i);
                this.password[i] = ItemStack.func_77949_a((NBTTagCompound)stackRoot);
                continue;
            }
            this.password[i] = null;
        }
        this.authorisedUsers.clear();
        String userStr = root.func_74779_i("authorisedUsers");
        if (userStr != null && userStr.length() > 0) {
            String[] users;
            for (String user : users = userStr.split(",")) {
                if (user == null || (user = user.trim()).length() <= 0) continue;
                this.authorisedUsers.add(user);
            }
        }
        if (root.func_74764_b("itemLabel")) {
            stackRoot = (NBTTagCompound)root.func_74781_a("itemLabel");
            this.itemLabel = ItemStack.func_77949_a((NBTTagCompound)stackRoot);
        } else {
            this.itemLabel = null;
        }
        String sourceBlockStr = root.func_74779_i(KEY_SOURCE_BLOCK_ID);
        this.sourceBlock = Block.func_149684_b((String)sourceBlockStr);
        this.sourceBlockMetadata = root.func_74762_e(KEY_SOURCE_BLOCK_META);
        this.label = root.func_74779_i("label");
        if (this.label == null || this.label.trim().length() == 0) {
            this.label = null;
        }
    }

    @Override
    protected void writeCustomNBT(NBTTagCompound root) {
        root.func_74777_a("accessMode", (short)this.accessMode.ordinal());
        if (this.placedBy != null && !this.placedBy.trim().isEmpty()) {
            root.func_74778_a("placedBy", this.placedBy.toString());
        }
        for (int i = 0; i < this.password.length; ++i) {
            ItemStack stack = this.password[i];
            if (stack == null) continue;
            NBTTagCompound stackRoot = new NBTTagCompound();
            stack.func_77955_b(stackRoot);
            root.func_74782_a("password" + i, (NBTBase)stackRoot);
        }
        StringBuffer userStr = new StringBuffer();
        for (String user : this.authorisedUsers) {
            if (user == null) continue;
            userStr.append(user.toString());
            userStr.append(",");
        }
        if (this.authorisedUsers.size() > 0) {
            root.func_74778_a("authorisedUsers", userStr.toString());
        }
        if (this.itemLabel != null) {
            NBTTagCompound labelRoot = new NBTTagCompound();
            this.itemLabel.func_77955_b(labelRoot);
            root.func_74782_a("itemLabel", (NBTBase)labelRoot);
        }
        if (this.sourceBlock != null) {
            root.func_74778_a(KEY_SOURCE_BLOCK_ID, Block.field_149771_c.func_148750_c((Object)this.sourceBlock));
        }
        root.func_74768_a(KEY_SOURCE_BLOCK_META, this.sourceBlockMetadata);
        if (this.label != null && this.label.trim().length() > 0) {
            root.func_74778_a("label", this.label);
        }
    }

    @Override
    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeCustomNBT(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, tag);
    }

    @Override
    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.readCustomNBT(pkt.func_148857_g());
    }

    public static enum AccessMode {
        PUBLIC,
        PRIVATE,
        PROTECTED;

    }
}

