/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.teleport;

import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import crazypants.enderio.config.Config;
import crazypants.enderio.enderface.TileEnderIO;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.teleport.IItemOfTravel;
import crazypants.enderio.teleport.ITravelAccessable;
import crazypants.enderio.teleport.TravelSource;
import crazypants.enderio.teleport.packet.PacketDrainStaff;
import crazypants.enderio.teleport.packet.PacketOpenAuthGui;
import crazypants.enderio.teleport.packet.PacketTravelEvent;
import crazypants.util.BlockCoord;
import crazypants.util.Util;
import crazypants.vecmath.Camera;
import crazypants.vecmath.Matrix4d;
import crazypants.vecmath.VecmathUtil;
import crazypants.vecmath.Vector2d;
import crazypants.vecmath.Vector3d;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovementInput;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.util.ForgeDirection;

public class TravelController {
    public static final TravelController instance = new TravelController();
    private Random rand = new Random();
    private boolean wasJumping = false;
    private boolean showTargets = false;
    BlockCoord onBlockCoord;
    BlockCoord selectedCoord;
    Camera currentView = new Camera();
    private final HashMap<BlockCoord, Float> candidates = new HashMap();
    private boolean selectionEnabled = true;
    private double fovRad;
    private double tanFovRad;
    private final List<GameRegistry.UniqueIdentifier> blackList = new ArrayList<GameRegistry.UniqueIdentifier>();

    private TravelController() {
        String[] blackListNames;
        for (String name : blackListNames = Config.travelStaffBlinkBlackList) {
            this.blackList.add(new GameRegistry.UniqueIdentifier(name));
        }
    }

    public boolean activateTravelAccessable(ItemStack equipped, World world, EntityPlayer player, TravelSource source) {
        ITravelAccessable ta;
        if (!this.hasTarget()) {
            return false;
        }
        BlockCoord target = this.selectedCoord;
        TileEntity te = world.func_147438_o(target.x, target.y, target.z);
        if (te instanceof ITravelAccessable && (ta = (ITravelAccessable)te).getRequiresPassword(player)) {
            PacketOpenAuthGui p = new PacketOpenAuthGui(target.x, target.y, target.z);
            PacketHandler.INSTANCE.sendToServer((IMessage)p);
            return true;
        }
        if (this.isTargetEnderIO()) {
            this.openEnderIO(equipped, world, player);
        } else if (Config.travelAnchorEnabled) {
            this.travelToSelectedTarget(player, source, false);
        }
        return true;
    }

    public boolean doBlink(ItemStack equipped, EntityPlayer player) {
        Vector3d eye = Util.getEyePositionEio(player);
        Vector3d look = Util.getLookVecEio(player);
        Vector3d sample = new Vector3d(look);
        sample.scale(Config.travelStaffMaxBlinkDistance);
        sample.add(eye);
        Vec3 eye3 = Vec3.func_72443_a((double)eye.x, (double)eye.y, (double)eye.z);
        Vec3 end = Vec3.func_72443_a((double)sample.x, (double)sample.y, (double)sample.z);
        double playerHeight = player.field_70129_M;
        double lookComp = -look.y * playerHeight;
        double maxDistance = (double)Config.travelStaffMaxBlinkDistance + lookComp;
        MovingObjectPosition p = player.field_70170_p.func_72901_a(eye3, end, !Config.travelStaffBlinkThroughClearBlocksEnabled);
        if (p == null) {
            for (double i = maxDistance; i > 1.0; i -= 1.0) {
                sample.set(look);
                sample.scale(i);
                sample.add(eye);
                sample.y -= playerHeight;
                if (!this.doBlinkAround(player, sample, true)) continue;
                return true;
            }
            return false;
        }
        List<MovingObjectPosition> res = Util.raytraceAll(player.field_70170_p, eye3, end, !Config.travelStaffBlinkThroughClearBlocksEnabled);
        for (MovingObjectPosition pos : res) {
            Block hitBlock;
            if (pos == null || !this.isBlackListedBlock(player, pos, hitBlock = player.field_70170_p.func_147439_a(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d))) continue;
            maxDistance = Math.min(maxDistance, VecmathUtil.distance(eye, new Vector3d((double)pos.field_72311_b + 0.5, (double)pos.field_72312_c + 0.5, (double)pos.field_72309_d + 0.5)) - 1.5 - lookComp);
        }
        eye3 = Vec3.func_72443_a((double)eye.x, (double)eye.y, (double)eye.z);
        Vector3d targetBc = new Vector3d(p.field_72311_b, p.field_72312_c, p.field_72309_d);
        double sampleDistance = 1.5;
        double teleDistance = VecmathUtil.distance(eye, new Vector3d((double)p.field_72311_b + 0.5, (double)p.field_72312_c + 0.5, (double)p.field_72309_d + 0.5)) + sampleDistance;
        while (teleDistance < maxDistance) {
            sample.set(look);
            sample.scale(sampleDistance);
            sample.add(targetBc);
            sample.y -= playerHeight;
            if (this.doBlinkAround(player, sample, false)) {
                return true;
            }
            teleDistance += 1.0;
            sampleDistance += 1.0;
        }
        sampleDistance = -0.5;
        for (teleDistance = VecmathUtil.distance(eye, new Vector3d((double)p.field_72311_b + 0.5, (double)p.field_72312_c + 0.5, (double)p.field_72309_d + 0.5)) + sampleDistance; teleDistance > 1.0; teleDistance -= 1.0) {
            sample.set(look);
            sample.scale(sampleDistance);
            sample.add(targetBc);
            sample.y -= playerHeight;
            if (this.doBlinkAround(player, sample, false)) {
                return true;
            }
            sampleDistance -= 1.0;
        }
        return false;
    }

    private boolean isBlackListedBlock(EntityPlayer player, MovingObjectPosition pos, Block hitBlock) {
        GameRegistry.UniqueIdentifier ui = GameRegistry.findUniqueIdentifierFor((Block)hitBlock);
        if (ui == null) {
            return false;
        }
        return this.blackList.contains(ui) && (hitBlock.func_149712_f(player.field_70170_p, pos.field_72311_b, pos.field_72312_c, pos.field_72309_d) < 0.0f || !Config.travelStaffBlinkThroughUnbreakableBlocksEnabled);
    }

    private boolean doBlinkAround(EntityPlayer player, Vector3d sample, boolean conserveMomentum) {
        if (this.doBlink(player, new BlockCoord((int)Math.round(sample.x), (int)Math.round(sample.y) - 1, (int)Math.round(sample.z)), conserveMomentum)) {
            return true;
        }
        if (this.doBlink(player, new BlockCoord((int)Math.round(sample.x), (int)Math.round(sample.y), (int)Math.round(sample.z)), conserveMomentum)) {
            return true;
        }
        return this.doBlink(player, new BlockCoord((int)Math.round(sample.x), (int)Math.round(sample.y) + 1, (int)Math.round(sample.z)), conserveMomentum);
    }

    private boolean doBlink(EntityPlayer player, BlockCoord coord, boolean conserveMomentum) {
        return this.travelToLocation(player, TravelSource.STAFF_BLINK, coord, conserveMomentum);
    }

    public boolean showTargets() {
        return this.showTargets && this.selectionEnabled;
    }

    public void setSelectionEnabled(boolean b) {
        this.selectionEnabled = b;
        if (!this.selectionEnabled) {
            this.candidates.clear();
        }
    }

    public boolean isBlockSelected(BlockCoord coord) {
        if (coord == null) {
            return false;
        }
        return coord.equals(this.selectedCoord);
    }

    public void addCandidate(BlockCoord coord) {
        if (!this.candidates.containsKey(coord)) {
            this.candidates.put(coord, Float.valueOf(-1.0f));
        }
    }

    public int getMaxTravelDistanceSq() {
        return TravelSource.getMaxDistanceSq();
    }

    public boolean isTargetEnderIO() {
        if (this.selectedCoord == null) {
            return false;
        }
        return EnderIO.proxy.getClientPlayer().field_70170_p.func_147439_a(this.selectedCoord.x, this.selectedCoord.y, this.selectedCoord.z) == EnderIO.blockEnderIo;
    }

    @SubscribeEvent
    public void onRender(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        Vector3d eye = Util.getEyePositionEio((EntityPlayer)mc.field_71439_g);
        Vector3d lookAt = Util.getLookVecEio((EntityPlayer)mc.field_71439_g);
        lookAt.add(eye);
        Matrix4d mv = VecmathUtil.createMatrixAsLookAt(eye, lookAt, new Vector3d(0.0, 1.0, 0.0));
        float fov = Minecraft.func_71410_x().field_71474_y.field_74334_X;
        Matrix4d pr = VecmathUtil.createProjectionMatrixAsPerspective(fov, 0.05f, mc.field_71474_y.field_151451_c * 16, mc.field_71443_c, mc.field_71440_d);
        this.currentView.setProjectionMatrix(pr);
        this.currentView.setViewMatrix(mv);
        this.currentView.setViewport(0, 0, mc.field_71443_c, mc.field_71440_d);
        this.fovRad = Math.toRadians(fov);
        this.tanFovRad = Math.tanh(this.fovRad);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
            if (player == null) {
                return;
            }
            this.onBlockCoord = this.getActiveTravelBlock(player);
            boolean onBlock = this.onBlockCoord != null;
            boolean bl = this.showTargets = onBlock || this.isTravelItemActive((EntityPlayer)player);
            if (this.showTargets) {
                this.updateSelectedTarget(player);
            } else {
                this.selectedCoord = null;
            }
            MovementInput input = player.field_71158_b;
            if (input.field_78901_c && !this.wasJumping && onBlock && this.selectedCoord != null) {
                ITravelAccessable ta;
                BlockCoord target = TravelController.instance.selectedCoord;
                TileEntity te = player.field_70170_p.func_147438_o(target.x, target.y, target.z);
                if (te instanceof ITravelAccessable && (ta = (ITravelAccessable)te).getRequiresPassword((EntityPlayer)player)) {
                    PacketOpenAuthGui p = new PacketOpenAuthGui(target.x, target.y, target.z);
                    PacketHandler.INSTANCE.sendToServer((IMessage)p);
                    return;
                }
                if (this.isTargetEnderIO()) {
                    this.openEnderIO(null, player.field_70170_p, (EntityPlayer)player);
                } else if (Config.travelAnchorEnabled && this.travelToSelectedTarget((EntityPlayer)player, TravelSource.BLOCK, false)) {
                    input.field_78901_c = false;
                    try {
                        ObfuscationReflectionHelper.setPrivateValue(EntityPlayer.class, (Object)player, (Object)0, (String[])new String[]{"flyToggleTimer", "field_71101_bC"});
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            this.wasJumping = input.field_78901_c;
            this.candidates.clear();
        }
    }

    public boolean hasTarget() {
        return this.selectedCoord != null;
    }

    public void openEnderIO(ItemStack equipped, World world, EntityPlayer player) {
        BlockCoord target = TravelController.instance.selectedCoord;
        TileEntity te = world.func_147438_o(target.x, target.y, target.z);
        if (!(te instanceof TileEnderIO)) {
            return;
        }
        TileEnderIO eio = (TileEnderIO)te;
        if (eio.canBlockBeAccessed(player)) {
            int requiredPower;
            int n = requiredPower = equipped == null ? 0 : instance.getRequiredPower(player, TravelSource.STAFF, target);
            if (requiredPower <= 0 || requiredPower <= this.getEnergyInTravelItem(equipped)) {
                if (requiredPower > 0) {
                    PacketDrainStaff p = new PacketDrainStaff(requiredPower);
                    PacketHandler.INSTANCE.sendToServer((IMessage)p);
                }
                player.openGui((Object)EnderIO.instance, 1, world, target.x, TravelController.instance.selectedCoord.y, TravelController.instance.selectedCoord.z);
            }
        } else {
            player.func_146105_b((IChatComponent)new ChatComponentTranslation("enderio.gui.travelAccessable.unauthorised", new Object[0]));
        }
    }

    public int getEnergyInTravelItem(ItemStack equipped) {
        if (equipped == null || !(equipped.func_77973_b() instanceof IItemOfTravel)) {
            return 0;
        }
        return ((IItemOfTravel)equipped.func_77973_b()).getEnergyStored(equipped);
    }

    public boolean isTravelItemActive(EntityPlayer ep) {
        if (ep == null || ep.func_71045_bC() == null) {
            return false;
        }
        ItemStack equipped = ep.func_71045_bC();
        if (equipped.func_77973_b() instanceof IItemOfTravel) {
            return ((IItemOfTravel)equipped.func_77973_b()).isActive(ep, equipped);
        }
        return false;
    }

    public boolean travelToSelectedTarget(EntityPlayer player, TravelSource source, boolean conserveMomentum) {
        return this.travelToLocation(player, source, this.selectedCoord, conserveMomentum);
    }

    public boolean travelToLocation(EntityPlayer player, TravelSource source, BlockCoord coord, boolean conserveMomentum) {
        ITravelAccessable ta;
        TileEntity te;
        if (source != TravelSource.STAFF_BLINK && (te = player.field_70170_p.func_147438_o(coord.x, coord.y, coord.z)) instanceof ITravelAccessable && !(ta = (ITravelAccessable)te).canBlockBeAccessed(player)) {
            player.func_146105_b((IChatComponent)new ChatComponentTranslation("enderio.gui.travelAccessable.unauthorised", new Object[0]));
            return false;
        }
        int requiredPower = 0;
        requiredPower = this.getRequiredPower(player, source, coord);
        if (requiredPower < 0) {
            return false;
        }
        if (!this.isInRangeTarget(player, coord, source.maxDistanceTravelledSq)) {
            if (source != TravelSource.STAFF_BLINK) {
                player.func_146105_b((IChatComponent)new ChatComponentTranslation("enderio.blockTravelPlatform.outOfRange", new Object[0]));
            }
            return false;
        }
        if (!this.isValidTarget(player, coord, source)) {
            if (source != TravelSource.STAFF_BLINK) {
                player.func_146105_b((IChatComponent)new ChatComponentTranslation("enderio.blockTravelPlatform.invalidTarget", new Object[0]));
            }
            return false;
        }
        this.sendTravelEvent(coord, source, requiredPower, conserveMomentum);
        for (int i = 0; i < 6; ++i) {
            player.field_70170_p.func_72869_a("portal", player.field_70165_t + (this.rand.nextDouble() - 0.5), player.field_70163_u + this.rand.nextDouble() * (double)player.field_70131_O - 0.25, player.field_70161_v + (this.rand.nextDouble() - 0.5), (this.rand.nextDouble() - 0.5) * 2.0, -this.rand.nextDouble(), (this.rand.nextDouble() - 0.5) * 2.0);
        }
        return true;
    }

    public int getRequiredPower(EntityPlayer player, TravelSource source, BlockCoord coord) {
        int canUsePower;
        if (!this.isTravelItemActive(player)) {
            return 0;
        }
        ItemStack staff = player.func_71045_bC();
        int requiredPower = (int)(this.getDistance(player, coord) * (double)source.powerCostPerBlockTraveledRF);
        if (requiredPower > (canUsePower = this.getEnergyInTravelItem(staff))) {
            player.func_146105_b((IChatComponent)new ChatComponentTranslation("enderio.itemTravelStaff.notEnoughPower", new Object[0]));
            return -1;
        }
        return requiredPower;
    }

    private boolean isInRangeTarget(EntityPlayer player, BlockCoord bc, float maxSq) {
        return this.getDistanceSquared(player, bc) <= (double)maxSq;
    }

    private double getDistanceSquared(EntityPlayer player, BlockCoord bc) {
        if (player == null || bc == null) {
            return 0.0;
        }
        Vector3d eye = Util.getEyePositionEio(player);
        Vector3d target = new Vector3d((double)bc.x + 0.5, (double)bc.y + 0.5, (double)bc.z + 0.5);
        return eye.distanceSquared(target);
    }

    private double getDistance(EntityPlayer player, BlockCoord coord) {
        return Math.sqrt(this.getDistanceSquared(player, coord));
    }

    private boolean isValidTarget(EntityPlayer player, BlockCoord bc, TravelSource source) {
        if (bc == null) {
            return false;
        }
        World w = player.field_70170_p;
        BlockCoord baseLoc = bc;
        if (source != TravelSource.STAFF_BLINK) {
            baseLoc = bc.getLocation(ForgeDirection.UP);
        }
        return this.canTeleportTo(player, source, baseLoc, w) && this.canTeleportTo(player, source, baseLoc.getLocation(ForgeDirection.UP), w);
    }

    private boolean canTeleportTo(EntityPlayer player, TravelSource source, BlockCoord bc, World w) {
        Vec3 target;
        Vec3 start;
        if (bc.y < 1) {
            return false;
        }
        if (source == TravelSource.STAFF_BLINK && !Config.travelStaffBlinkThroughSolidBlocksEnabled && !this.canBlinkTo(bc, w, start = Util.getEyePosition(player), target = Vec3.func_72443_a((double)((float)bc.x + 0.5f), (double)((float)bc.y + 0.5f), (double)((float)bc.z + 0.5f)))) {
            return false;
        }
        Block block = w.func_147439_a(bc.x, bc.y, bc.z);
        if (block == null || block.isAir((IBlockAccess)w, bc.x, bc.y, bc.z)) {
            return true;
        }
        AxisAlignedBB aabb = block.func_149668_a(w, bc.x, bc.y, bc.z);
        return aabb == null || aabb.func_72320_b() < 0.7;
    }

    private boolean canBlinkTo(BlockCoord bc, World w, Vec3 start, Vec3 target) {
        MovingObjectPosition p = w.func_72901_a(start, target, !Config.travelStaffBlinkThroughClearBlocksEnabled);
        if (p != null) {
            if (!Config.travelStaffBlinkThroughClearBlocksEnabled) {
                return false;
            }
            Block block = w.func_147439_a(p.field_72311_b, p.field_72312_c, p.field_72309_d);
            if (this.isClear(w, block, p.field_72311_b, p.field_72312_c, p.field_72309_d)) {
                if (new BlockCoord(p.field_72311_b, p.field_72312_c, p.field_72309_d).equals(bc)) {
                    return true;
                }
                Vector3d sv = new Vector3d(start.field_72450_a, start.field_72448_b, start.field_72449_c);
                Vector3d rayDir = new Vector3d(target.field_72450_a, target.field_72448_b, target.field_72449_c);
                rayDir.sub(sv);
                rayDir.normalize();
                rayDir.add(sv);
                return this.canBlinkTo(bc, w, Vec3.func_72443_a((double)rayDir.x, (double)rayDir.y, (double)rayDir.z), target);
            }
            return false;
        }
        return true;
    }

    private boolean isClear(World w, Block block, int x, int y, int z) {
        if (block == null || block.isAir((IBlockAccess)w, x, y, z)) {
            return true;
        }
        AxisAlignedBB aabb = block.func_149668_a(w, x, y, z);
        if (aabb == null || aabb.func_72320_b() < 0.7) {
            return true;
        }
        return block.getLightOpacity((IBlockAccess)w, x, y, z) < 2;
    }

    @SideOnly(value=Side.CLIENT)
    private void updateSelectedTarget(EntityClientPlayerMP player) {
        this.selectedCoord = null;
        if (this.candidates.isEmpty()) {
            return;
        }
        double closestDistance = Double.MAX_VALUE;
        for (BlockCoord bc : this.candidates.keySet()) {
            double d;
            if (bc.equals(this.onBlockCoord) || !((d = this.addRatio(bc)) < closestDistance)) continue;
            this.selectedCoord = bc;
            closestDistance = d;
        }
        if (this.selectedCoord != null) {
            Vector3d blockCenter = new Vector3d((double)this.selectedCoord.x + 0.5, (double)this.selectedCoord.y + 0.5, (double)this.selectedCoord.z + 0.5);
            Vector2d blockCenterPixel = this.currentView.getScreenPoint(blockCenter);
            Vector2d screenMidPixel = new Vector2d(Minecraft.func_71410_x().field_71443_c, Minecraft.func_71410_x().field_71440_d);
            screenMidPixel.scale(0.5);
            double pixDist = blockCenterPixel.distance(screenMidPixel);
            double rat = pixDist / (double)Minecraft.func_71410_x().field_71440_d;
            if (rat != rat) {
                rat = 0.0;
            }
            if (rat > 0.07) {
                this.selectedCoord = null;
            }
        }
    }

    public double getScaleForCandidate(Vector3d loc) {
        BlockCoord bc = new BlockCoord((int)loc.x, (int)loc.y, (int)loc.z);
        float ratio = -1.0f;
        Float r = this.candidates.get(bc);
        if (r != null) {
            ratio = r.floatValue();
        }
        if (ratio < 0.0f) {
            this.addRatio(bc);
            ratio = this.candidates.get(bc).floatValue();
        }
        float start = 0.2f;
        float end = 0.01f;
        double mix = MathHelper.func_76131_a((float)((start - ratio) / (start - end)), (float)0.0f, (float)1.0f);
        double scale = 1.0;
        if (mix > 0.0) {
            Vector3d eyePoint = Util.getEyePositionEio(EnderIO.proxy.getClientPlayer());
            scale = this.tanFovRad * eyePoint.distance(loc);
            scale *= (double)Config.travelAnchorZoomScale;
            float nf = 1.0f - MathHelper.func_76131_a((float)((float)eyePoint.distanceSquared(loc) / (float)TravelSource.STAFF.maxDistanceTravelledSq), (float)0.0f, (float)1.0f);
            scale *= 0.3 + 0.7 * (double)nf;
            scale = scale * mix + (1.0 - mix);
            scale = Math.max(1.0, scale);
        }
        return scale;
    }

    private double addRatio(BlockCoord bc) {
        Vector2d sp = this.currentView.getScreenPoint(new Vector3d((double)bc.x + 0.5, (double)bc.y + 0.5, (double)bc.z + 0.5));
        Vector2d mid = new Vector2d(Minecraft.func_71410_x().field_71443_c, Minecraft.func_71410_x().field_71440_d);
        mid.scale(0.5);
        double d = sp.distance(mid);
        if (d != d) {
            d = 0.0;
        }
        float ratio = (float)d / (float)Minecraft.func_71410_x().field_71443_c;
        this.candidates.put(bc, Float.valueOf(ratio));
        return d;
    }

    @SideOnly(value=Side.CLIENT)
    private int getMaxTravelDistanceSqForPlayer(EntityClientPlayerMP player) {
        if (this.isTravelItemActive((EntityPlayer)player)) {
            return TravelSource.STAFF.maxDistanceTravelledSq;
        }
        return TravelSource.BLOCK.maxDistanceTravelledSq;
    }

    private void sendTravelEvent(BlockCoord bc, TravelSource source, int powerUse, boolean conserveMomentum) {
        PacketTravelEvent p = new PacketTravelEvent(bc.x, bc.y, bc.z, powerUse, conserveMomentum);
        PacketHandler.INSTANCE.sendToServer((IMessage)p);
    }

    @SideOnly(value=Side.CLIENT)
    private BlockCoord getActiveTravelBlock(EntityClientPlayerMP player) {
        int z;
        int y;
        int x;
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (world != null && player != null && world.func_147439_a(x = MathHelper.func_76128_c((double)player.field_70165_t), y = MathHelper.func_76128_c((double)player.field_70121_D.field_72338_b) - 1, z = MathHelper.func_76128_c((double)player.field_70161_v)) == EnderIO.blockTravelPlatform) {
            return new BlockCoord(x, y, z);
        }
        return null;
    }
}

