/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.teleport;

import crazypants.enderio.EnderIO;
import crazypants.enderio.teleport.ITravelAccessable;
import crazypants.enderio.teleport.TravelController;
import crazypants.enderio.teleport.TravelSource;
import crazypants.render.BoundingBox;
import crazypants.render.CubeRenderer;
import crazypants.render.RenderUtil;
import crazypants.util.BlockCoord;
import crazypants.util.Util;
import crazypants.vecmath.Vector3d;
import crazypants.vecmath.Vector3f;
import crazypants.vecmath.Vector4f;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;

public class TravelEntitySpecialRenderer
extends TileEntitySpecialRenderer {
    private final Vector4f selectedColor;
    private final Vector4f highlightColor;

    public TravelEntitySpecialRenderer() {
        this(new Vector4f(1.0f, 0.25f, 0.0f, 0.5f), new Vector4f(1.0f, 1.0f, 1.0f, 0.25f));
    }

    public TravelEntitySpecialRenderer(Vector4f selectedColor, Vector4f highlightColor) {
        this.selectedColor = selectedColor;
        this.highlightColor = highlightColor;
    }

    public void func_147500_a(TileEntity tileentity, double x, double y, double z, float f) {
        double maxDistance;
        if (!TravelController.instance.showTargets()) {
            return;
        }
        ITravelAccessable ta = (ITravelAccessable)tileentity;
        if (!ta.canSeeBlock((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
            return;
        }
        Vector3d eye = Util.getEyePositionEio((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        Vector3d loc = new Vector3d((double)tileentity.field_145851_c + 0.5, (double)tileentity.field_145848_d + 0.5, (double)tileentity.field_145849_e + 0.5);
        double d = maxDistance = TravelController.instance.isTravelItemActive((EntityPlayer)Minecraft.func_71410_x().field_71439_g) ? (double)TravelSource.STAFF.maxDistanceTravelledSq : (double)TravelSource.BLOCK.maxDistanceTravelledSq;
        if (eye.distanceSquared(loc) > maxDistance) {
            return;
        }
        double sf = TravelController.instance.getScaleForCandidate(loc);
        BlockCoord bc = new BlockCoord(tileentity);
        TravelController.instance.addCandidate(bc);
        Minecraft.func_71410_x().field_71460_t.func_78483_a(0.0);
        RenderUtil.bindBlockTexture();
        GL11.glPushAttrib((int)8192);
        GL11.glPushAttrib((int)64);
        GL11.glEnable((int)32826);
        GL11.glDisable((int)2929);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)2884);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        Tessellator.field_78398_a.func_78382_b();
        this.renderBlock(sf);
        Tessellator.field_78398_a.func_78381_a();
        Tessellator.field_78398_a.func_78382_b();
        Tessellator.field_78398_a.func_78380_c(0xF000F0);
        if (TravelController.instance.isBlockSelected(bc)) {
            Tessellator.field_78398_a.func_78369_a(this.selectedColor.x, this.selectedColor.y, this.selectedColor.z, this.selectedColor.w);
            CubeRenderer.render(BoundingBox.UNIT_CUBE.scale(sf + 0.05, sf + 0.05, sf + 0.05), this.getSelectedIcon());
        } else {
            Tessellator.field_78398_a.func_78369_a(this.highlightColor.x, this.highlightColor.y, this.highlightColor.z, this.highlightColor.w);
            CubeRenderer.render(BoundingBox.UNIT_CUBE.scale(sf + 0.05, sf + 0.05, sf + 0.05), this.getHighlightIcon());
        }
        Tessellator.field_78398_a.func_78381_a();
        GL11.glPopMatrix();
        this.renderLabel(tileentity, x, y, z, ta, sf);
        GL11.glPopAttrib();
        GL11.glPopAttrib();
        Minecraft.func_71410_x().field_71460_t.func_78463_b(0.0);
    }

    private void renderLabel(TileEntity tileentity, double x, double y, double z, ITravelAccessable ta, double sf) {
        float globalScale = (float)sf;
        ItemStack itemLabel = ta.getItemLabel();
        if (itemLabel != null && itemLabel.func_77973_b() != null) {
            boolean isBlock = false;
            Block block = Block.func_149634_a((Item)itemLabel.func_77973_b());
            if (block != null && block != Blocks.field_150350_a) {
                isBlock = true;
            }
            float alpha = 0.5f;
            GL11.glBlendFunc((int)770, (int)32769);
            float col = 0.5f;
            GL14.glBlendColor((float)col, (float)col, (float)col, (float)col);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.5f), (float)((float)z + 0.5f));
            if (!isBlock) {
                GL11.glRotatef((float)(-player.field_70177_z), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)player.field_70125_A, (float)1.0f, (float)0.0f, (float)0.0f);
            }
            GL11.glPushMatrix();
            GL11.glScalef((float)globalScale, (float)globalScale, (float)globalScale);
            GL11.glPushMatrix();
            if (isBlock) {
                GL11.glTranslatef((float)0.0f, (float)-0.25f, (float)0.0f);
            } else {
                GL11.glTranslatef((float)0.0f, (float)-0.5f, (float)0.0f);
            }
            GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
            EntityItem ei = new EntityItem(tileentity.func_145831_w(), x, y, z, itemLabel);
            ei.field_70292_b = 0;
            ei.field_70290_d = 0.0f;
            RenderManager.field_78727_a.func_78713_a((Entity)ei).func_76986_a((Entity)ei, 0.0, 0.0, 0.0, 0.0f, 0.0f);
            GL11.glPopMatrix();
            GL11.glPopMatrix();
            GL11.glPopMatrix();
            String toRender = ta.getLabel();
            if (toRender != null && toRender.trim().length() > 0) {
                Vector4f bgCol = RenderUtil.DEFAULT_TEXT_BG_COL;
                if (TravelController.instance.isBlockSelected(new BlockCoord(tileentity))) {
                    bgCol = new Vector4f(this.selectedColor.x, this.selectedColor.y, this.selectedColor.z, this.selectedColor.w);
                }
                GL11.glPushMatrix();
                GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.5f), (float)((float)z + 0.5f));
                GL11.glPushMatrix();
                GL11.glScalef((float)globalScale, (float)globalScale, (float)globalScale);
                Vector3f pos = new Vector3f(0.0f, 1.2f, 0.0f);
                float size = 0.5f;
                RenderUtil.drawBillboardedText(pos, toRender, size, bgCol);
                GL11.glPopMatrix();
                GL11.glPopMatrix();
            }
        }
    }

    protected void renderBlock(double sf) {
        Tessellator.field_78398_a.func_78369_a(1.0f, 1.0f, 1.0f, 0.75f);
        CubeRenderer.render(BoundingBox.UNIT_CUBE.scale(sf, sf, sf), EnderIO.blockTravelPlatform.func_149691_a(0, 0));
    }

    public Vector4f getSelectedColor() {
        return this.selectedColor;
    }

    public IIcon getSelectedIcon() {
        return EnderIO.blockTravelPlatform.selectedOverlayIcon;
    }

    public Vector4f getHighlightColor() {
        return this.highlightColor;
    }

    public IIcon getHighlightIcon() {
        return EnderIO.blockTravelPlatform.highlightOverlayIcon;
    }
}

