/*
 * Decompiled with CFR 0.152.
 */
package crazypants.render;

import crazypants.render.BoundingBox;
import crazypants.render.CustomRenderBlocks;
import crazypants.render.IRenderFace;
import crazypants.render.RenderUtil;
import crazypants.util.BlockCoord;
import crazypants.util.ForgeDirectionOffsets;
import crazypants.vecmath.Vector2f;
import crazypants.vecmath.Vector3d;
import crazypants.vecmath.Vector4f;
import crazypants.vecmath.Vertex;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class ConnectedTextureRenderer
implements IRenderFace {
    private boolean forceAllEdges = false;
    private TextureCallback edgeTexureCallback;
    private boolean matchMetaData;

    public boolean isForceAllEdges() {
        return this.forceAllEdges;
    }

    public void setForceAllEdges(boolean forceAllEdges) {
        this.forceAllEdges = forceAllEdges;
    }

    public TextureCallback getEdgeTexureCallback() {
        return this.edgeTexureCallback;
    }

    public void setEdgeTexureCallback(TextureCallback edgeTexureCallback) {
        this.edgeTexureCallback = edgeTexureCallback;
    }

    public void setEdgeTexture(IIcon texture) {
        if (texture == null) {
            this.edgeTexureCallback = null;
            return;
        }
        this.edgeTexureCallback = new DefaultTextureCallback(texture);
    }

    public void setMatchMeta(boolean matchMetaData) {
        this.matchMetaData = matchMetaData;
    }

    @Override
    public void renderFace(CustomRenderBlocks rb, ForgeDirection face, Block par1Block, double x, double y, double z, IIcon texture, List<Vertex> refVertices, boolean translateToXYZ) {
        IIcon borderTex;
        ArrayList<Vertex> finalVerts = new ArrayList<Vertex>();
        finalVerts.addAll(refVertices);
        IIcon iIcon = borderTex = this.edgeTexureCallback == null ? null : this.edgeTexureCallback.getTextureForFace(face);
        if (borderTex != null) {
            texture = borderTex;
            List<ForgeDirection> edges = this.forceAllEdges ? RenderUtil.getEdgesForFace(face) : RenderUtil.getNonConectedEdgesForFace(rb.field_147845_a, (int)x, (int)y, (int)z, face, this.matchMetaData);
            List<ForgeDirection> allEdges = RenderUtil.getEdgesForFace(face);
            float scaleFactor = 0.9375f;
            Vector2f uv = new Vector2f();
            for (ForgeDirection edge : edges) {
                int[] indices;
                this.moveCorners(refVertices, edge, 1.0f - scaleFactor);
                float xLen = 1.0f - (float)Math.abs(edge.offsetX) * scaleFactor;
                float yLen = 1.0f - (float)Math.abs(edge.offsetY) * scaleFactor;
                float zLen = 1.0f - (float)Math.abs(edge.offsetZ) * scaleFactor;
                BoundingBox bb = BoundingBox.UNIT_CUBE.scale(xLen, yLen, zLen);
                List<Vector3d> corners = bb.getCornersForFaceD(face);
                for (Vector3d corner : corners) {
                    if (translateToXYZ) {
                        corner.x += x;
                        corner.y += y;
                        corner.z += z;
                    }
                    corner.x += (double)((float)((double)edge.offsetX * 0.5) - Math.signum(edge.offsetX) * xLen / 2.0f);
                    corner.y += (double)((float)((double)edge.offsetY * 0.5) - Math.signum(edge.offsetY) * yLen / 2.0f);
                    corner.z += (double)((float)((double)edge.offsetZ * 0.5) - Math.signum(edge.offsetZ) * zLen / 2.0f);
                }
                for (int index : indices = new int[]{0, 1, 2, 3}) {
                    Vector3d corner = corners.get(index);
                    if (translateToXYZ) {
                        RenderUtil.getUvForCorner(uv, corner, (int)x, (int)y, (int)z, face, texture);
                    } else {
                        RenderUtil.getUvForCorner(uv, corner, 0, 0, 0, face, texture);
                    }
                    Vertex vertex = new Vertex();
                    vertex.xyz.set(corner);
                    vertex.uv = new Vector2f(uv);
                    this.applyLighting(vertex, corner, refVertices);
                    finalVerts.add(vertex);
                }
            }
            for (int i = 0; i < allEdges.size(); ++i) {
                ForgeDirection dir2;
                ForgeDirection dir = allEdges.get(i);
                ForgeDirection forgeDirection = dir2 = i + 1 < allEdges.size() ? allEdges.get(i + 1) : allEdges.get(0);
                if (!this.needsCorner(dir, dir2, edges, face, par1Block, x, y, z, rb.field_147845_a)) continue;
                Vertex v = new Vertex();
                v.uv = new Vector2f();
                v.xyz.set(ForgeDirectionOffsets.forDir(dir));
                v.xyz.add(ForgeDirectionOffsets.forDir(dir2));
                v.xyz.add(ForgeDirectionOffsets.offsetScaled(face, 0.001f));
                v.xyz.x = Math.max(-0.001, v.xyz.x);
                v.xyz.y = Math.max(-0.001, v.xyz.y);
                v.xyz.z = Math.max(-0.001, v.xyz.z);
                if (ForgeDirectionOffsets.isPositiveOffset(face)) {
                    v.xyz.add(ForgeDirectionOffsets.forDir(face));
                }
                if (translateToXYZ) {
                    v.xyz.x += x;
                    v.xyz.y += y;
                    v.xyz.z += z;
                    RenderUtil.getUvForCorner(v.uv, v.xyz, (int)x, (int)y, (int)z, face, texture);
                } else {
                    RenderUtil.getUvForCorner(v.uv, v.xyz, 0, 0, 0, face, texture);
                }
                this.applyLighting(v, v.xyz, refVertices);
                finalVerts.add(v);
                Vector3d corner = new Vector3d(v.xyz);
                if (ForgeDirectionOffsets.isPositiveOffset(face)) {
                    this.addVertexForCorner(face, x, y, z, texture, translateToXYZ, finalVerts, dir2, null, corner);
                    this.addVertexForCorner(face, x, y, z, texture, translateToXYZ, finalVerts, dir, dir2, corner);
                    this.addVertexForCorner(face, x, y, z, texture, translateToXYZ, finalVerts, dir, null, corner);
                    continue;
                }
                this.addVertexForCorner(face, x, y, z, texture, translateToXYZ, finalVerts, dir, null, corner);
                this.addVertexForCorner(face, x, y, z, texture, translateToXYZ, finalVerts, dir, dir2, corner);
                this.addVertexForCorner(face, x, y, z, texture, translateToXYZ, finalVerts, dir2, null, corner);
            }
        }
        RenderUtil.addVerticesToTessellator(finalVerts, Tessellator.field_78398_a);
    }

    private Vertex getClosestVertex(List<Vertex> vertices, Vector3d corner) {
        Vertex result = null;
        double d2 = Double.MAX_VALUE;
        for (Vertex v : vertices) {
            double tmp = corner.distanceSquared(v.xyz);
            if (!(tmp <= d2)) continue;
            result = v;
            d2 = tmp;
        }
        return result;
    }

    private void addVertexForCorner(ForgeDirection face, double x, double y, double z, IIcon texture, boolean translateToXYZ, List<Vertex> vertices, ForgeDirection dir, ForgeDirection dir2, Vector3d corner) {
        float scale = 0.0625f;
        Vertex vert = new Vertex();
        vert.uv = new Vector2f();
        vert.xyz.set(corner);
        vert.xyz.sub(ForgeDirectionOffsets.offsetScaled(dir, scale));
        if (dir2 != null) {
            vert.xyz.sub(ForgeDirectionOffsets.offsetScaled(dir2, scale));
        }
        if (translateToXYZ) {
            RenderUtil.getUvForCorner(vert.uv, vert.xyz, (int)x, (int)y, (int)z, face, texture);
        } else {
            RenderUtil.getUvForCorner(vert.uv, vert.xyz, 0, 0, 0, face, texture);
        }
        this.applyLighting(vert, corner, vertices);
        vertices.add(vert);
    }

    private void applyLighting(Vertex vert, Vector3d samplePoint, List<Vertex> litVertices) {
        Vertex closest = this.getClosestVertex(litVertices, samplePoint);
        if (closest == null) {
            return;
        }
        vert.setBrightness(closest.brightness);
        Vector4f col = closest.getColor();
        if (col != null) {
            vert.setColor(col);
        }
    }

    private boolean needsCorner(ForgeDirection dir, ForgeDirection dir2, List<ForgeDirection> edges, ForgeDirection face, Block par1Block, double x, double y, double z, IBlockAccess blockAccess) {
        if (edges.contains(dir) || edges.contains(dir2)) {
            return false;
        }
        BlockCoord bc = new BlockCoord((int)x, (int)y, (int)z);
        BlockCoord testLoc = bc.getLocation(dir);
        if (RenderUtil.getNonConectedEdgesForFace(blockAccess, testLoc.x, testLoc.y, testLoc.z, face).contains(dir2)) {
            return true;
        }
        testLoc = bc.getLocation(dir2);
        return RenderUtil.getNonConectedEdgesForFace(blockAccess, testLoc.x, testLoc.y, testLoc.z, face).contains(dir);
    }

    private void moveCorners(List<Vertex> vertices, ForgeDirection edge, float scaleFactor) {
        int[] indices = this.getClosest(edge, vertices);
        if (indices[0] < 0) {
            return;
        }
        vertices.get((int)indices[0]).xyz.x -= (double)(scaleFactor * (float)edge.offsetX);
        vertices.get((int)indices[1]).xyz.x -= (double)(scaleFactor * (float)edge.offsetX);
        vertices.get((int)indices[0]).xyz.y -= (double)(scaleFactor * (float)edge.offsetY);
        vertices.get((int)indices[1]).xyz.y -= (double)(scaleFactor * (float)edge.offsetY);
        vertices.get((int)indices[0]).xyz.z -= (double)(scaleFactor * (float)edge.offsetZ);
        vertices.get((int)indices[1]).xyz.z -= (double)(scaleFactor * (float)edge.offsetZ);
    }

    private int[] getClosest(ForgeDirection edge, List<Vertex> vertices) {
        int[] res = new int[]{-1, -1};
        boolean highest = edge.offsetX > 0 || edge.offsetY > 0 || edge.offsetZ > 0;
        double minMax = highest ? -1.7976931348623157E308 : Double.MAX_VALUE;
        int index = 0;
        for (Vertex v : vertices) {
            double val = this.get(v.xyz, edge);
            if (highest ? val >= minMax : val <= minMax) {
                if (val != minMax) {
                    res[0] = index;
                } else {
                    res[1] = index;
                }
                minMax = val;
            }
            ++index;
        }
        return res;
    }

    private double get(Vector3d xyz, ForgeDirection edge) {
        if (edge == ForgeDirection.EAST || edge == ForgeDirection.WEST) {
            return xyz.x;
        }
        if (edge == ForgeDirection.UP || edge == ForgeDirection.DOWN) {
            return xyz.y;
        }
        return xyz.z;
    }

    public static class DefaultTextureCallback
    implements TextureCallback {
        private final IIcon tex;
        private final Block block;
        private final int meta;

        public DefaultTextureCallback(IIcon borderTex) {
            this.tex = borderTex;
            this.block = null;
            this.meta = 0;
        }

        public DefaultTextureCallback(Block block, int meta) {
            this.tex = null;
            this.block = block;
            this.meta = meta;
        }

        @Override
        public IIcon getTextureForFace(ForgeDirection dir) {
            if (this.tex != null) {
                return this.tex;
            }
            if (this.block != null) {
                return this.block.func_149691_a(dir.ordinal(), this.meta);
            }
            return null;
        }
    }

    public static interface TextureCallback {
        public IIcon getTextureForFace(ForgeDirection var1);
    }
}

