/*
 * Decompiled with CFR 0.152.
 */
package crazypants.render;

import crazypants.render.IRenderFace;
import crazypants.vecmath.Vertex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class CustomRenderBlocks
extends RenderBlocks {
    boolean translateToXYZ = true;
    private final List<IRenderFace> renderFaceCallbacks = new ArrayList<IRenderFace>();
    private IIcon overrideTexture;

    public CustomRenderBlocks(IBlockAccess par1iBlockAccess) {
        super(par1iBlockAccess);
    }

    public void addFaceRenderer(IRenderFace renderer) {
        this.renderFaceCallbacks.add(renderer);
    }

    public void setFaceRenderers(Collection<IRenderFace> renderers) {
        this.renderFaceCallbacks.clear();
        if (renderers != null) {
            this.renderFaceCallbacks.addAll(renderers);
        }
    }

    public void removeFaceRenderer(IRenderFace renderer) {
        this.renderFaceCallbacks.remove(renderer);
    }

    public boolean isTranslateToXYZ() {
        return this.translateToXYZ;
    }

    public void setTranslateToXYZ(boolean translateToXYZ) {
        this.translateToXYZ = translateToXYZ;
    }

    public IIcon getOverrideTexture() {
        return this.overrideTexture;
    }

    public void setOverrideTexture(IIcon overrideTexture) {
        this.overrideTexture = overrideTexture;
    }

    private void renderFace(ForgeDirection face, Block par1Block, double x, double y, double z, IIcon texture) {
        if (this.renderFaceCallbacks.isEmpty()) {
            this.doDefaultRenderFace(face, par1Block, x, y, z, this.overrideTexture == null ? texture : this.overrideTexture);
        } else {
            List<Vertex> faceVertices = this.createVerticesForFace(face, par1Block, x, y, z, this.overrideTexture == null ? texture : this.overrideTexture);
            for (IRenderFace rf : this.renderFaceCallbacks) {
                rf.renderFace(this, face, par1Block, x, y, z, this.overrideTexture == null ? texture : this.overrideTexture, faceVertices, this.translateToXYZ);
            }
        }
    }

    public List<Vertex> createVerticesForFace(ForgeDirection face, Block par1Block, double x, double y, double z, IIcon icon) {
        switch (face) {
            case DOWN: {
                return this.calcFaceYNeg(par1Block, x, y, z, icon);
            }
            case EAST: {
                return this.calcFaceXPos(par1Block, x, y, z, icon);
            }
            case NORTH: {
                return this.calcFaceZNeg(par1Block, x, y, z, icon);
            }
            case SOUTH: {
                return this.calcFaceZPos(par1Block, x, y, z, icon);
            }
            case UP: {
                return this.calcFaceYPos(par1Block, x, y, z, icon);
            }
            case WEST: {
                return this.calcFaceXNeg(par1Block, x, y, z, icon);
            }
        }
        return Collections.emptyList();
    }

    public void doDefaultRenderFace(ForgeDirection face, Block par1Block, double par2, double par4, double par6, IIcon par8Icon) {
        switch (face) {
            case DOWN: {
                super.func_147768_a(par1Block, par2, par4, par6, par8Icon);
                break;
            }
            case EAST: {
                super.func_147764_f(par1Block, par2, par4, par6, par8Icon);
                break;
            }
            case NORTH: {
                super.func_147761_c(par1Block, par2, par4, par6, par8Icon);
                break;
            }
            case SOUTH: {
                super.func_147734_d(par1Block, par2, par4, par6, par8Icon);
                break;
            }
            case UP: {
                super.func_147806_b(par1Block, par2, par4, par6, par8Icon);
                break;
            }
            case WEST: {
                super.func_147798_e(par1Block, par2, par4, par6, par8Icon);
                break;
            }
        }
    }

    public void func_147768_a(Block par1Block, double par2, double par4, double par6, IIcon par8Icon) {
        this.renderFace(ForgeDirection.DOWN, par1Block, par2, par4, par6, par8Icon);
    }

    public void func_147806_b(Block par1Block, double par2, double par4, double par6, IIcon par8Icon) {
        this.renderFace(ForgeDirection.UP, par1Block, par2, par4, par6, par8Icon);
    }

    public void func_147761_c(Block par1Block, double par2, double par4, double par6, IIcon par8Icon) {
        this.renderFace(ForgeDirection.NORTH, par1Block, par2, par4, par6, par8Icon);
    }

    public void func_147734_d(Block par1Block, double par2, double par4, double par6, IIcon par8Icon) {
        this.renderFace(ForgeDirection.SOUTH, par1Block, par2, par4, par6, par8Icon);
    }

    public void func_147798_e(Block par1Block, double par2, double par4, double par6, IIcon par8Icon) {
        this.renderFace(ForgeDirection.WEST, par1Block, par2, par4, par6, par8Icon);
    }

    public void func_147764_f(Block par1Block, double par2, double par4, double par6, IIcon par8Icon) {
        this.renderFace(ForgeDirection.EAST, par1Block, par2, par4, par6, par8Icon);
    }

    private List<Vertex> calcFaceXNeg(Block par1Block, double par2, double par4, double par6, IIcon par8Icon) {
        double d7;
        if (this.func_147744_b()) {
            par8Icon = this.field_147840_d;
        }
        double d3 = par8Icon.func_94214_a(this.field_147851_l * 16.0);
        double d4 = par8Icon.func_94214_a(this.field_147853_m * 16.0);
        double d5 = par8Icon.func_94207_b(16.0 - this.field_147857_k * 16.0);
        double d6 = par8Icon.func_94207_b(16.0 - this.field_147855_j * 16.0);
        if (this.field_147842_e) {
            d7 = d3;
            d3 = d4;
            d4 = d7;
        }
        if (this.field_147851_l < 0.0 || this.field_147853_m > 1.0) {
            d3 = par8Icon.func_94209_e();
            d4 = par8Icon.func_94212_f();
        }
        if (this.field_147855_j < 0.0 || this.field_147857_k > 1.0) {
            d5 = par8Icon.func_94206_g();
            d6 = par8Icon.func_94210_h();
        }
        d7 = d4;
        double d8 = d3;
        double d9 = d5;
        double d10 = d6;
        if (this.field_147869_t == 1) {
            d3 = par8Icon.func_94214_a(this.field_147855_j * 16.0);
            d5 = par8Icon.func_94207_b(16.0 - this.field_147853_m * 16.0);
            d4 = par8Icon.func_94214_a(this.field_147857_k * 16.0);
            d6 = par8Icon.func_94207_b(16.0 - this.field_147851_l * 16.0);
            d9 = d5;
            d10 = d6;
            d7 = d3;
            d8 = d4;
            d5 = d6;
            d6 = d9;
        } else if (this.field_147869_t == 2) {
            d3 = par8Icon.func_94214_a(16.0 - this.field_147857_k * 16.0);
            d5 = par8Icon.func_94207_b(this.field_147851_l * 16.0);
            d4 = par8Icon.func_94214_a(16.0 - this.field_147855_j * 16.0);
            d6 = par8Icon.func_94207_b(this.field_147853_m * 16.0);
            d7 = d4;
            d8 = d3;
            d3 = d4;
            d4 = d8;
            d9 = d6;
            d10 = d5;
        } else if (this.field_147869_t == 3) {
            d3 = par8Icon.func_94214_a(16.0 - this.field_147851_l * 16.0);
            d4 = par8Icon.func_94214_a(16.0 - this.field_147853_m * 16.0);
            d5 = par8Icon.func_94207_b(this.field_147857_k * 16.0);
            d6 = par8Icon.func_94207_b(this.field_147855_j * 16.0);
            d7 = d4;
            d8 = d3;
            d9 = d5;
            d10 = d6;
        }
        double d11 = par2 + this.field_147859_h;
        double d12 = par4 + this.field_147855_j;
        double d13 = par4 + this.field_147857_k;
        double d14 = par6 + this.field_147851_l;
        double d15 = par6 + this.field_147853_m;
        ArrayList<Vertex> result = new ArrayList<Vertex>(4);
        if (this.field_147863_w) {
            result.add(new Vertex(d11, d13, d15, d7, d9, this.field_147864_al, this.field_147872_ap, this.field_147846_at, this.field_147854_ax, 1.0f));
            result.add(new Vertex(d11, d13, d14, d3, d5, this.field_147874_am, this.field_147852_aq, this.field_147860_au, this.field_147841_ay, 1.0f));
            result.add(new Vertex(d11, d12, d14, d8, d10, this.field_147876_an, this.field_147850_ar, this.field_147858_av, this.field_147839_az, 1.0f));
            result.add(new Vertex(d11, d12, d15, d4, d6, this.field_147870_ao, this.field_147848_as, this.field_147856_aw, this.field_147833_aA, 1.0f));
        } else {
            result.add(new Vertex(d11, d13, d15, d7, d9));
            result.add(new Vertex(d11, d13, d14, d3, d5));
            result.add(new Vertex(d11, d12, d14, d8, d10));
            result.add(new Vertex(d11, d12, d15, d4, d6));
        }
        return result;
    }

    private List<Vertex> calcFaceYPos(Block par1Block, double par2, double par4, double par6, IIcon par8Icon) {
        if (this.func_147744_b()) {
            par8Icon = this.field_147840_d;
        }
        double d3 = par8Icon.func_94214_a(this.field_147859_h * 16.0);
        double d4 = par8Icon.func_94214_a(this.field_147861_i * 16.0);
        double d5 = par8Icon.func_94207_b(this.field_147851_l * 16.0);
        double d6 = par8Icon.func_94207_b(this.field_147853_m * 16.0);
        if (this.field_147859_h < 0.0 || this.field_147861_i > 1.0) {
            d3 = par8Icon.func_94209_e();
            d4 = par8Icon.func_94212_f();
        }
        if (this.field_147851_l < 0.0 || this.field_147853_m > 1.0) {
            d5 = par8Icon.func_94206_g();
            d6 = par8Icon.func_94210_h();
        }
        double d7 = d4;
        double d8 = d3;
        double d9 = d5;
        double d10 = d6;
        if (this.field_147867_u == 1) {
            d3 = par8Icon.func_94214_a(this.field_147851_l * 16.0);
            d5 = par8Icon.func_94207_b(16.0 - this.field_147861_i * 16.0);
            d4 = par8Icon.func_94214_a(this.field_147853_m * 16.0);
            d6 = par8Icon.func_94207_b(16.0 - this.field_147859_h * 16.0);
            d9 = d5;
            d10 = d6;
            d7 = d3;
            d8 = d4;
            d5 = d6;
            d6 = d9;
        } else if (this.field_147867_u == 2) {
            d3 = par8Icon.func_94214_a(16.0 - this.field_147853_m * 16.0);
            d5 = par8Icon.func_94207_b(this.field_147859_h * 16.0);
            d4 = par8Icon.func_94214_a(16.0 - this.field_147851_l * 16.0);
            d6 = par8Icon.func_94207_b(this.field_147861_i * 16.0);
            d7 = d4;
            d8 = d3;
            d3 = d4;
            d4 = d8;
            d9 = d6;
            d10 = d5;
        } else if (this.field_147867_u == 3) {
            d3 = par8Icon.func_94214_a(16.0 - this.field_147859_h * 16.0);
            d4 = par8Icon.func_94214_a(16.0 - this.field_147861_i * 16.0);
            d5 = par8Icon.func_94207_b(16.0 - this.field_147851_l * 16.0);
            d6 = par8Icon.func_94207_b(16.0 - this.field_147853_m * 16.0);
            d7 = d4;
            d8 = d3;
            d9 = d5;
            d10 = d6;
        }
        double d11 = par2 + this.field_147859_h;
        double d12 = par2 + this.field_147861_i;
        double d13 = par4 + this.field_147857_k;
        double d14 = par6 + this.field_147851_l;
        double d15 = par6 + this.field_147853_m;
        ArrayList<Vertex> result = new ArrayList<Vertex>(4);
        if (this.field_147863_w) {
            Vertex v = new Vertex(d12, d13, d15, d4, d6, this.field_147864_al, this.field_147872_ap, this.field_147846_at, this.field_147854_ax, 1.0f);
            result.add(v);
            v = new Vertex(d12, d13, d14, d7, d9, this.field_147874_am, this.field_147852_aq, this.field_147860_au, this.field_147841_ay, 1.0f);
            result.add(v);
            v = new Vertex(d11, d13, d14, d3, d5, this.field_147876_an, this.field_147850_ar, this.field_147858_av, this.field_147839_az, 1.0f);
            result.add(v);
            v = new Vertex(d11, d13, d15, d8, d10, this.field_147870_ao, this.field_147848_as, this.field_147856_aw, this.field_147833_aA, 1.0f);
            result.add(v);
        } else {
            Vertex v = new Vertex(d12, d13, d15, d4, d6);
            result.add(v);
            v = new Vertex(d12, d13, d14, d7, d9);
            result.add(v);
            v = new Vertex(d11, d13, d14, d3, d5);
            result.add(v);
            v = new Vertex(d11, d13, d15, d8, d10);
            result.add(v);
        }
        return result;
    }

    private List<Vertex> calcFaceZPos(Block par1Block, double par2, double par4, double par6, IIcon par8Icon) {
        double d7;
        Tessellator tessellator = Tessellator.field_78398_a;
        if (this.func_147744_b()) {
            par8Icon = this.field_147840_d;
        }
        double d3 = par8Icon.func_94214_a(this.field_147859_h * 16.0);
        double d4 = par8Icon.func_94214_a(this.field_147861_i * 16.0);
        double d5 = par8Icon.func_94207_b(16.0 - this.field_147857_k * 16.0);
        double d6 = par8Icon.func_94207_b(16.0 - this.field_147855_j * 16.0);
        if (this.field_147842_e) {
            d7 = d3;
            d3 = d4;
            d4 = d7;
        }
        if (this.field_147859_h < 0.0 || this.field_147861_i > 1.0) {
            d3 = par8Icon.func_94209_e();
            d4 = par8Icon.func_94212_f();
        }
        if (this.field_147855_j < 0.0 || this.field_147857_k > 1.0) {
            d5 = par8Icon.func_94206_g();
            d6 = par8Icon.func_94210_h();
        }
        d7 = d4;
        double d8 = d3;
        double d9 = d5;
        double d10 = d6;
        if (this.field_147873_r == 1) {
            d3 = par8Icon.func_94214_a(this.field_147855_j * 16.0);
            d6 = par8Icon.func_94207_b(16.0 - this.field_147859_h * 16.0);
            d4 = par8Icon.func_94214_a(this.field_147857_k * 16.0);
            d9 = d5 = (double)par8Icon.func_94207_b(16.0 - this.field_147861_i * 16.0);
            d10 = d6;
            d7 = d3;
            d8 = d4;
            d5 = d6;
            d6 = d9;
        } else if (this.field_147873_r == 2) {
            d3 = par8Icon.func_94214_a(16.0 - this.field_147857_k * 16.0);
            d5 = par8Icon.func_94207_b(this.field_147859_h * 16.0);
            d4 = par8Icon.func_94214_a(16.0 - this.field_147855_j * 16.0);
            d6 = par8Icon.func_94207_b(this.field_147861_i * 16.0);
            d7 = d4;
            d8 = d3;
            d3 = d4;
            d4 = d8;
            d9 = d6;
            d10 = d5;
        } else if (this.field_147873_r == 3) {
            d3 = par8Icon.func_94214_a(16.0 - this.field_147859_h * 16.0);
            d4 = par8Icon.func_94214_a(16.0 - this.field_147861_i * 16.0);
            d5 = par8Icon.func_94207_b(this.field_147857_k * 16.0);
            d6 = par8Icon.func_94207_b(this.field_147855_j * 16.0);
            d7 = d4;
            d8 = d3;
            d9 = d5;
            d10 = d6;
        }
        double d11 = par2 + this.field_147859_h;
        double d12 = par2 + this.field_147861_i;
        double d13 = par4 + this.field_147855_j;
        double d14 = par4 + this.field_147857_k;
        double d15 = par6 + this.field_147853_m;
        ArrayList<Vertex> result = new ArrayList<Vertex>();
        if (this.field_147863_w) {
            result.add(new Vertex(d11, d14, d15, d3, d5, this.field_147864_al, this.field_147872_ap, this.field_147846_at, this.field_147854_ax, 1.0f));
            result.add(new Vertex(d11, d13, d15, d8, d10, this.field_147874_am, this.field_147852_aq, this.field_147860_au, this.field_147841_ay, 1.0f));
            result.add(new Vertex(d12, d13, d15, d4, d6, this.field_147876_an, this.field_147850_ar, this.field_147858_av, this.field_147839_az, 1.0f));
            result.add(new Vertex(d12, d14, d15, d7, d9, this.field_147870_ao, this.field_147848_as, this.field_147856_aw, this.field_147833_aA, 1.0f));
        } else {
            result.add(new Vertex(d11, d14, d15, d3, d5));
            result.add(new Vertex(d11, d13, d15, d8, d10));
            result.add(new Vertex(d12, d13, d15, d4, d6));
            result.add(new Vertex(d12, d14, d15, d7, d9));
        }
        return result;
    }

    private List<Vertex> calcFaceZNeg(Block par1Block, double par2, double par4, double par6, IIcon par8Icon) {
        double d7;
        if (this.func_147744_b()) {
            par8Icon = this.field_147840_d;
        }
        double d3 = par8Icon.func_94214_a(this.field_147859_h * 16.0);
        double d4 = par8Icon.func_94214_a(this.field_147861_i * 16.0);
        double d5 = par8Icon.func_94207_b(16.0 - this.field_147857_k * 16.0);
        double d6 = par8Icon.func_94207_b(16.0 - this.field_147855_j * 16.0);
        if (this.field_147842_e) {
            d7 = d3;
            d3 = d4;
            d4 = d7;
        }
        if (this.field_147859_h < 0.0 || this.field_147861_i > 1.0) {
            d3 = par8Icon.func_94209_e();
            d4 = par8Icon.func_94212_f();
        }
        if (this.field_147855_j < 0.0 || this.field_147857_k > 1.0) {
            d5 = par8Icon.func_94206_g();
            d6 = par8Icon.func_94210_h();
        }
        d7 = d4;
        double d8 = d3;
        double d9 = d5;
        double d10 = d6;
        if (this.field_147875_q == 2) {
            d3 = par8Icon.func_94214_a(this.field_147855_j * 16.0);
            d5 = par8Icon.func_94207_b(16.0 - this.field_147859_h * 16.0);
            d4 = par8Icon.func_94214_a(this.field_147857_k * 16.0);
            d6 = par8Icon.func_94207_b(16.0 - this.field_147861_i * 16.0);
            d9 = d5;
            d10 = d6;
            d7 = d3;
            d8 = d4;
            d5 = d6;
            d6 = d9;
        } else if (this.field_147875_q == 1) {
            d3 = par8Icon.func_94214_a(16.0 - this.field_147857_k * 16.0);
            d5 = par8Icon.func_94207_b(this.field_147861_i * 16.0);
            d4 = par8Icon.func_94214_a(16.0 - this.field_147855_j * 16.0);
            d6 = par8Icon.func_94207_b(this.field_147859_h * 16.0);
            d7 = d4;
            d8 = d3;
            d3 = d4;
            d4 = d8;
            d9 = d6;
            d10 = d5;
        } else if (this.field_147875_q == 3) {
            d3 = par8Icon.func_94214_a(16.0 - this.field_147859_h * 16.0);
            d4 = par8Icon.func_94214_a(16.0 - this.field_147861_i * 16.0);
            d5 = par8Icon.func_94207_b(this.field_147857_k * 16.0);
            d6 = par8Icon.func_94207_b(this.field_147855_j * 16.0);
            d7 = d4;
            d8 = d3;
            d9 = d5;
            d10 = d6;
        }
        double d11 = par2 + this.field_147859_h;
        double d12 = par2 + this.field_147861_i;
        double d13 = par4 + this.field_147855_j;
        double d14 = par4 + this.field_147857_k;
        double d15 = par6 + this.field_147851_l;
        ArrayList<Vertex> result = new ArrayList<Vertex>();
        if (this.field_147863_w) {
            result.add(new Vertex(d11, d14, d15, d7, d9, this.field_147864_al, this.field_147872_ap, this.field_147846_at, this.field_147854_ax, 1.0f));
            result.add(new Vertex(d12, d14, d15, d3, d5, this.field_147874_am, this.field_147852_aq, this.field_147860_au, this.field_147841_ay, 1.0f));
            result.add(new Vertex(d12, d13, d15, d8, d10, this.field_147876_an, this.field_147850_ar, this.field_147858_av, this.field_147839_az, 1.0f));
            result.add(new Vertex(d11, d13, d15, d4, d6, this.field_147870_ao, this.field_147848_as, this.field_147856_aw, this.field_147833_aA, 1.0f));
        } else {
            result.add(new Vertex(d11, d14, d15, d7, d9));
            result.add(new Vertex(d12, d14, d15, d3, d5));
            result.add(new Vertex(d12, d13, d15, d8, d10));
            result.add(new Vertex(d11, d13, d15, d4, d6));
        }
        return result;
    }

    private List<Vertex> calcFaceXPos(Block par1Block, double par2, double par4, double par6, IIcon par8Icon) {
        double d7;
        Tessellator tessellator = Tessellator.field_78398_a;
        if (this.func_147744_b()) {
            par8Icon = this.field_147840_d;
        }
        double d3 = par8Icon.func_94214_a(this.field_147851_l * 16.0);
        double d4 = par8Icon.func_94214_a(this.field_147853_m * 16.0);
        double d5 = par8Icon.func_94207_b(16.0 - this.field_147857_k * 16.0);
        double d6 = par8Icon.func_94207_b(16.0 - this.field_147855_j * 16.0);
        if (this.field_147842_e) {
            d7 = d3;
            d3 = d4;
            d4 = d7;
        }
        if (this.field_147851_l < 0.0 || this.field_147853_m > 1.0) {
            d3 = par8Icon.func_94209_e();
            d4 = par8Icon.func_94212_f();
        }
        if (this.field_147855_j < 0.0 || this.field_147857_k > 1.0) {
            d5 = par8Icon.func_94206_g();
            d6 = par8Icon.func_94210_h();
        }
        d7 = d4;
        double d8 = d3;
        double d9 = d5;
        double d10 = d6;
        if (this.field_147871_s == 2) {
            d3 = par8Icon.func_94214_a(this.field_147855_j * 16.0);
            d5 = par8Icon.func_94207_b(16.0 - this.field_147851_l * 16.0);
            d4 = par8Icon.func_94214_a(this.field_147857_k * 16.0);
            d6 = par8Icon.func_94207_b(16.0 - this.field_147853_m * 16.0);
            d9 = d5;
            d10 = d6;
            d7 = d3;
            d8 = d4;
            d5 = d6;
            d6 = d9;
        } else if (this.field_147871_s == 1) {
            d3 = par8Icon.func_94214_a(16.0 - this.field_147857_k * 16.0);
            d5 = par8Icon.func_94207_b(this.field_147853_m * 16.0);
            d4 = par8Icon.func_94214_a(16.0 - this.field_147855_j * 16.0);
            d6 = par8Icon.func_94207_b(this.field_147851_l * 16.0);
            d7 = d4;
            d8 = d3;
            d3 = d4;
            d4 = d8;
            d9 = d6;
            d10 = d5;
        } else if (this.field_147871_s == 3) {
            d3 = par8Icon.func_94214_a(16.0 - this.field_147851_l * 16.0);
            d4 = par8Icon.func_94214_a(16.0 - this.field_147853_m * 16.0);
            d5 = par8Icon.func_94207_b(this.field_147857_k * 16.0);
            d6 = par8Icon.func_94207_b(this.field_147855_j * 16.0);
            d7 = d4;
            d8 = d3;
            d9 = d5;
            d10 = d6;
        }
        double d11 = par2 + this.field_147861_i;
        double d12 = par4 + this.field_147855_j;
        double d13 = par4 + this.field_147857_k;
        double d14 = par6 + this.field_147851_l;
        double d15 = par6 + this.field_147853_m;
        ArrayList<Vertex> result = new ArrayList<Vertex>(4);
        if (this.field_147863_w) {
            result.add(new Vertex(d11, d12, d15, d8, d10, this.field_147864_al, this.field_147872_ap, this.field_147846_at, this.field_147854_ax, 1.0f));
            result.add(new Vertex(d11, d12, d14, d4, d6, this.field_147874_am, this.field_147852_aq, this.field_147860_au, this.field_147841_ay, 1.0f));
            result.add(new Vertex(d11, d13, d14, d7, d9, this.field_147876_an, this.field_147850_ar, this.field_147858_av, this.field_147839_az, 1.0f));
            result.add(new Vertex(d11, d13, d15, d3, d5, this.field_147870_ao, this.field_147848_as, this.field_147856_aw, this.field_147833_aA, 1.0f));
        } else {
            result.add(new Vertex(d11, d12, d15, d8, d10));
            result.add(new Vertex(d11, d12, d14, d4, d6));
            result.add(new Vertex(d11, d13, d14, d7, d9));
            result.add(new Vertex(d11, d13, d15, d3, d5));
        }
        return result;
    }

    private List<Vertex> calcFaceYNeg(Block par1Block, double x, double y, double z, IIcon icon) {
        if (this.func_147744_b()) {
            icon = this.field_147840_d;
        }
        double minU = icon.func_94214_a(this.field_147859_h * 16.0);
        double maxU = icon.func_94214_a(this.field_147861_i * 16.0);
        double minV = icon.func_94207_b(this.field_147851_l * 16.0);
        double maxV = icon.func_94207_b(this.field_147853_m * 16.0);
        if (this.field_147859_h < 0.0 || this.field_147861_i > 1.0) {
            minU = icon.func_94209_e();
            maxU = icon.func_94212_f();
        }
        if (this.field_147851_l < 0.0 || this.field_147853_m > 1.0) {
            minV = icon.func_94206_g();
            maxV = icon.func_94210_h();
        }
        double d7 = maxU;
        double d8 = minU;
        double d9 = minV;
        double d10 = maxV;
        if (this.field_147865_v == 2) {
            minU = icon.func_94214_a(this.field_147851_l * 16.0);
            minV = icon.func_94207_b(16.0 - this.field_147861_i * 16.0);
            maxU = icon.func_94214_a(this.field_147853_m * 16.0);
            maxV = icon.func_94207_b(16.0 - this.field_147859_h * 16.0);
            d9 = minV;
            d10 = maxV;
            d7 = minU;
            d8 = maxU;
            minV = maxV;
            maxV = d9;
        } else if (this.field_147865_v == 1) {
            minU = icon.func_94214_a(16.0 - this.field_147853_m * 16.0);
            minV = icon.func_94207_b(this.field_147859_h * 16.0);
            maxU = icon.func_94214_a(16.0 - this.field_147851_l * 16.0);
            maxV = icon.func_94207_b(this.field_147861_i * 16.0);
            d7 = maxU;
            d8 = minU;
            minU = maxU;
            maxU = d8;
            d9 = maxV;
            d10 = minV;
        } else if (this.field_147865_v == 3) {
            minU = icon.func_94214_a(16.0 - this.field_147859_h * 16.0);
            maxU = icon.func_94214_a(16.0 - this.field_147861_i * 16.0);
            minV = icon.func_94207_b(16.0 - this.field_147851_l * 16.0);
            maxV = icon.func_94207_b(16.0 - this.field_147853_m * 16.0);
            d7 = maxU;
            d8 = minU;
            d9 = minV;
            d10 = maxV;
        }
        double minX = x + this.field_147859_h;
        double maxX = x + this.field_147861_i;
        double minY = y + this.field_147855_j;
        double minZ = z + this.field_147851_l;
        double maxZ = z + this.field_147853_m;
        ArrayList<Vertex> result = new ArrayList<Vertex>(4);
        if (this.field_147863_w) {
            Vertex v = new Vertex(minX, minY, maxZ, d8, d10, this.field_147864_al, this.field_147872_ap, this.field_147846_at, this.field_147854_ax, 1.0f);
            result.add(v);
            v = new Vertex(minX, minY, minZ, minU, minV, this.field_147874_am, this.field_147852_aq, this.field_147860_au, this.field_147841_ay, 1.0f);
            result.add(v);
            v = new Vertex(maxX, minY, minZ, d7, d9, this.field_147876_an, this.field_147850_ar, this.field_147858_av, this.field_147839_az, 1.0f);
            result.add(v);
            v = new Vertex(maxX, minY, maxZ, maxU, maxV, this.field_147870_ao, this.field_147848_as, this.field_147856_aw, this.field_147833_aA, 1.0f);
            result.add(v);
        } else {
            Vertex v = new Vertex(minX, minY, maxZ, d8, d10);
            result.add(v);
            v = new Vertex(minX, minY, minZ, minU, minV);
            result.add(v);
            v = new Vertex(maxX, minY, minZ, d7, d9);
            result.add(v);
            v = new Vertex(maxX, minY, maxZ, maxU, maxV);
            result.add(v);
        }
        return result;
    }
}

