/*
 * Decompiled with CFR 0.152.
 */
package crazypants.util;

import cpw.mods.fml.common.Loader;
import crazypants.enderio.Log;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.util.BlockCoord;
import crazypants.util.IFluidReceptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;

public class FluidUtil {
    public static final List<IFluidReceptor> fluidReceptors;

    public static Map<ForgeDirection, IFluidHandler> getNeighbouringFluidHandlers(IBlockAccess world, BlockCoord bc) {
        HashMap<ForgeDirection, IFluidHandler> res = new HashMap<ForgeDirection, IFluidHandler>();
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            IFluidHandler fh = FluidUtil.getFluidHandler(world, bc.getLocation(dir));
            if (fh == null) continue;
            res.put(dir, fh);
        }
        return res;
    }

    public static IFluidHandler getExternalFluidHandler(IBlockAccess world, BlockCoord bc) {
        IFluidHandler con = FluidUtil.getFluidHandler(world, bc);
        return con != null && !(con instanceof IConduitBundle) ? con : null;
    }

    public static IFluidHandler getFluidHandler(IBlockAccess world, BlockCoord bc) {
        return FluidUtil.getFluidHandler(world, bc.x, bc.y, bc.z);
    }

    public static IFluidHandler getFluidHandler(IBlockAccess world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        return FluidUtil.getFluidHandler(te);
    }

    public static IFluidHandler getFluidHandler(TileEntity te) {
        if (te instanceof IFluidHandler) {
            IFluidHandler res = (IFluidHandler)te;
            for (IFluidReceptor rec : fluidReceptors) {
                if (rec.isValidReceptor(res)) continue;
                return null;
            }
            return res;
        }
        return null;
    }

    public static FluidStack getFluidFromItem(ItemStack stack) {
        if (stack != null) {
            Fluid fluid;
            FluidStack fluidStack = null;
            if (stack.func_77973_b() instanceof IFluidContainerItem) {
                fluidStack = ((IFluidContainerItem)stack.func_77973_b()).getFluid(stack);
            }
            if (fluidStack == null) {
                fluidStack = FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack);
            }
            if (fluidStack == null && Block.func_149634_a((Item)stack.func_77973_b()) instanceof IFluidBlock && (fluid = ((IFluidBlock)Block.func_149634_a((Item)stack.func_77973_b())).getFluid()) != null) {
                return new FluidStack(fluid, 1000);
            }
            return fluidStack;
        }
        return null;
    }

    public static ItemStack getEmptyContainer(ItemStack stack) {
        if (stack.func_77973_b().hasContainerItem(stack)) {
            return stack.func_77973_b().getContainerItem(stack);
        }
        if (stack.func_77973_b() instanceof ItemPotion && stack.field_77990_d == null) {
            return new ItemStack(Items.field_151069_bo);
        }
        return null;
    }

    public static boolean doPull(IFluidHandler into, ForgeDirection fromDir, int maxVolume) {
        FluidTankInfo[] infos;
        TileEntity te = (TileEntity)into;
        BlockCoord loc = new BlockCoord(te).getLocation(fromDir);
        IFluidHandler target = FluidUtil.getFluidHandler((IBlockAccess)te.func_145831_w(), loc);
        if (target != null && (infos = target.getTankInfo(fromDir.getOpposite())) != null) {
            for (FluidTankInfo info : infos) {
                int filled;
                if (info.fluid == null || info.fluid.amount <= 0 || !into.canFill(fromDir, info.fluid.getFluid())) continue;
                FluidStack canPull = info.fluid.copy();
                canPull.amount = Math.min(maxVolume, canPull.amount);
                FluidStack drained = target.drain(fromDir.getOpposite(), canPull, false);
                if (drained == null || drained.amount <= 0 || (filled = into.fill(fromDir, drained, false)) <= 0) continue;
                drained = target.drain(fromDir.getOpposite(), filled, true);
                into.fill(fromDir, drained, true);
                return true;
            }
        }
        return false;
    }

    public static boolean doPush(IFluidHandler from, ForgeDirection fromDir, int maxVolume) {
        TileEntity te = (TileEntity)from;
        BlockCoord loc = new BlockCoord(te).getLocation(fromDir);
        IFluidHandler target = FluidUtil.getFluidHandler((IBlockAccess)te.func_145831_w(), loc);
        if (target == null) {
            return false;
        }
        FluidTankInfo[] infos = from.getTankInfo(fromDir);
        boolean res = false;
        if (infos != null) {
            for (FluidTankInfo info : infos) {
                FluidStack maxDrain;
                FluidStack canDrain;
                if (info.fluid == null || info.fluid.amount <= 0 || !from.canDrain(fromDir, info.fluid.getFluid()) || (canDrain = from.drain(fromDir, maxDrain = new FluidStack(info.fluid.getFluid(), maxVolume), false)) == null || canDrain.amount <= 0) continue;
                int filled = target.fill(fromDir.getOpposite(), canDrain, true);
                from.drain(fromDir, new FluidStack(info.fluid.getFluid(), filled), true);
                res |= true;
            }
        }
        return res;
    }

    static {
        block2: {
            fluidReceptors = new ArrayList<IFluidReceptor>();
            try {
                Class.forName("crazypants.util.BuildcraftUtil");
            }
            catch (Exception e) {
                if (!Loader.isModLoaded((String)"BuildCraft|Transport")) break block2;
                Log.warn("ItemUtil: Could not register Build Craft pipe handler. Fluid conduits will show connections to all Build Craft pipes.");
            }
        }
    }
}

