/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api;

import mekanism.api.Coord4D;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;

public class Pos3D {
    public double xPos;
    public double yPos;
    public double zPos;

    public Pos3D() {
        this(0.0, 0.0, 0.0);
    }

    public Pos3D(double x, double y, double z) {
        this.xPos = x;
        this.yPos = y;
        this.zPos = z;
    }

    public Pos3D(Coord4D coord) {
        this.xPos = coord.xCoord;
        this.yPos = coord.yCoord;
        this.zPos = coord.zCoord;
    }

    public Pos3D(Entity entity) {
        this(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
    }

    public Pos3D(TileEntity tileEntity) {
        this(tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e);
    }

    public Pos3D diff(Pos3D pos) {
        return new Pos3D(this.xPos - pos.xPos, this.yPos - pos.yPos, this.zPos - pos.zPos);
    }

    public static Pos3D fromMotion(Entity entity) {
        return new Pos3D(entity.field_70159_w, entity.field_70181_x, entity.field_70179_y);
    }

    public Pos3D translate(double x, double y, double z) {
        this.xPos += x;
        this.yPos += y;
        this.zPos += z;
        return this;
    }

    public Pos3D translate(Pos3D pos) {
        return this.translate(pos.xPos, pos.yPos, pos.zPos);
    }

    public double distance(Pos3D pos) {
        double subX = this.xPos - pos.xPos;
        double subY = this.yPos - pos.yPos;
        double subZ = this.zPos - pos.zPos;
        return MathHelper.func_76133_a((double)(subX * subX + subY * subY + subZ * subZ));
    }

    public Pos3D rotateYaw(double yaw) {
        double yawRadians = Math.toRadians(yaw);
        double x = this.xPos;
        double z = this.zPos;
        if (yaw != 0.0) {
            this.xPos = x * Math.cos(yawRadians) - z * Math.sin(yawRadians);
            this.zPos = x * Math.sin(yawRadians) + z * Math.cos(yawRadians);
        }
        return this;
    }

    public Pos3D scale(double x, double y, double z) {
        this.xPos *= x;
        this.yPos *= y;
        this.zPos *= z;
        return this;
    }

    public Pos3D scale(double scale) {
        return this.scale(scale, scale, scale);
    }

    public Pos3D clone() {
        return new Pos3D(this.xPos, this.yPos, this.zPos);
    }

    public String toString() {
        return "[Pos3D: " + this.xPos + ", " + this.yPos + ", " + this.zPos + "]";
    }

    public boolean equals(Object obj) {
        return obj instanceof Pos3D && ((Pos3D)obj).xPos == this.xPos && ((Pos3D)obj).yPos == this.yPos && ((Pos3D)obj).zPos == this.zPos;
    }

    public int hashCode() {
        int code = 1;
        code = 31 * code + new Double(this.xPos).hashCode();
        code = 31 * code + new Double(this.yPos).hashCode();
        code = 31 * code + new Double(this.zPos).hashCode();
        return code;
    }
}

