/*
 * Decompiled with CFR 0.152.
 */
package mcmultipart.network;

import com.google.common.base.Throwables;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.util.function.Function;
import mcmultipart.MCMultiPart;
import mcmultipart.api.slot.IPartSlot;
import mcmultipart.multipart.PartInfo;
import mcmultipart.network.Packet;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class PacketMultipartChange
extends Packet<PacketMultipartChange> {
    private static final Function<SPacketUpdateTileEntity, NBTTagCompound> getPacketNBT;
    private BlockPos pos;
    private IPartSlot slot;
    private IBlockState state;
    private NBTTagCompound data;

    public PacketMultipartChange(PartInfo info) {
        SPacketUpdateTileEntity packet;
        this.pos = info.getPartPos();
        this.slot = info.getSlot();
        this.state = info.getState();
        if (info.getTile() != null && (packet = info.getTile().getPartUpdatePacket()) != null) {
            this.data = getPacketNBT.apply(packet);
        }
    }

    public PacketMultipartChange() {
    }

    @Override
    public void handleClient(EntityPlayer player) {
        PartInfo.handleUpdatePacket(player.field_70170_p, this.pos, this.slot, this.state, new SPacketUpdateTileEntity(this.pos, 0, this.data));
    }

    @Override
    public void handleServer(EntityPlayer player) {
    }

    @Override
    public void toBytes(PacketBuffer buf) {
        buf.func_179255_a(this.pos);
        buf.writeInt(MCMultiPart.slotRegistry.getID((IForgeRegistryEntry)this.slot));
        buf.writeInt(MCMultiPart.stateMap.func_148747_b((Object)this.state));
        buf.writeBoolean(this.data != null);
        if (this.data != null) {
            buf.func_150786_a(this.data);
        }
    }

    @Override
    public void fromBytes(PacketBuffer buf) throws Exception {
        this.pos = buf.func_179259_c();
        this.slot = (IPartSlot)MCMultiPart.slotRegistry.getValue(buf.readInt());
        this.state = (IBlockState)MCMultiPart.stateMap.func_148745_a(buf.readInt());
        this.data = buf.readBoolean() ? buf.func_150793_b() : null;
    }

    static {
        try {
            Field f = ReflectionHelper.findField(SPacketUpdateTileEntity.class, (String[])new String[]{"field_148860_e", "nbt"});
            f.setAccessible(true);
            getPacketNBT = packet -> {
                try {
                    return MethodHandles.lookup().unreflectGetter(f).invokeExact((SPacketUpdateTileEntity)packet);
                }
                catch (Throwable ex) {
                    throw Throwables.propagate((Throwable)ex);
                }
            };
        }
        catch (Exception ex) {
            throw Throwables.propagate((Throwable)ex);
        }
    }
}

