/*
 * Decompiled with CFR 0.152.
 */
package mcmultipart.util;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSetMultimap;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import mcmultipart.api.container.IPartInfo;
import mcmultipart.api.multipart.IMultipart;
import mcmultipart.api.multipart.IMultipartTile;
import mcmultipart.api.ref.MCMPCapabilities;
import mcmultipart.api.world.IMultipartWorld;
import mcmultipart.api.world.IWorldView;
import mcmultipart.multipart.MultipartRegistry;
import mcmultipart.multipart.PartInfo;
import mcmultipart.network.MultipartAction;
import mcmultipart.network.MultipartNetworkHandler;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.village.VillageCollection;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.Explosion;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.MinecraftException;
import net.minecraft.world.NextTickListEntry;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldInfo;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.capabilities.Capability;

public class MCMPWorldWrapper
extends World
implements IMultipartWorld {
    private final PartInfo part;
    private final PartInfo partInfo;
    private final IWorldView view;

    public MCMPWorldWrapper(PartInfo part, PartInfo partInfo, IWorldView view) {
        super(part.getActualWorld().func_72860_G(), part.getActualWorld().func_72912_H(), part.getActualWorld().field_73011_w, part.getActualWorld().field_72984_F, part.getActualWorld().field_72995_K);
        this.part = part;
        this.partInfo = partInfo;
        this.view = view;
    }

    @Override
    public World getActualWorld() {
        return this.part.getActualWorld();
    }

    @Override
    public IPartInfo getPartInfo() {
        return this.partInfo;
    }

    protected IChunkProvider func_72970_h() {
        return this.getActualWorld().func_72863_F();
    }

    protected boolean func_175680_a(int x, int z, boolean allowEmpty) {
        return this.getActualWorld().func_175668_a(new BlockPos(x << 4, 0, z << 4), allowEmpty);
    }

    public World func_175643_b() {
        return this;
    }

    public Biome func_180494_b(BlockPos pos) {
        return this.getActualWorld().func_180494_b(pos);
    }

    public Biome getBiomeForCoordsBody(BlockPos pos) {
        return this.getActualWorld().getBiomeForCoordsBody(pos);
    }

    public BiomeProvider func_72959_q() {
        return this.getActualWorld().func_72959_q();
    }

    public void func_72963_a(WorldSettings settings) {
    }

    public MinecraftServer func_73046_m() {
        return this.getActualWorld().func_73046_m();
    }

    public void func_72974_f() {
    }

    public IBlockState func_184141_c(BlockPos pos) {
        return this.getActualWorld().func_184141_c(pos);
    }

    public boolean func_175623_d(BlockPos pos) {
        return super.func_175623_d(pos);
    }

    public boolean func_175667_e(BlockPos pos) {
        return this.getActualWorld().func_175667_e(pos);
    }

    public boolean func_175668_a(BlockPos pos, boolean allowEmpty) {
        return this.getActualWorld().func_175668_a(pos, allowEmpty);
    }

    public boolean func_175697_a(BlockPos center, int radius) {
        return this.getActualWorld().func_175697_a(center, radius);
    }

    public boolean func_175648_a(BlockPos center, int radius, boolean allowEmpty) {
        return this.getActualWorld().func_175648_a(center, radius, allowEmpty);
    }

    public boolean func_175707_a(BlockPos from, BlockPos to) {
        return this.getActualWorld().func_175707_a(from, to);
    }

    public boolean func_175706_a(BlockPos from, BlockPos to, boolean allowEmpty) {
        return this.getActualWorld().func_175706_a(from, to, allowEmpty);
    }

    public boolean func_175711_a(StructureBoundingBox box) {
        return this.getActualWorld().func_175711_a(box);
    }

    public boolean func_175639_b(StructureBoundingBox box, boolean allowEmpty) {
        return this.getActualWorld().func_175639_b(box, allowEmpty);
    }

    public Chunk func_175726_f(BlockPos pos) {
        return this.getActualWorld().func_175726_f(pos);
    }

    public Chunk func_72964_e(int chunkX, int chunkZ) {
        return this.getActualWorld().func_72964_e(chunkX, chunkZ);
    }

    public boolean func_190526_b(int p_190526_1_, int p_190526_2_) {
        return this.getActualWorld().func_190526_b(p_190526_1_, p_190526_2_);
    }

    public boolean func_175656_a(BlockPos pos, IBlockState state) {
        return this.func_180501_a(pos, state, 3);
    }

    public boolean func_180501_a(BlockPos pos, IBlockState state, int flags) {
        if (this.part.getPartPos().equals((Object)pos)) {
            if (state.func_177230_c() == Blocks.field_150350_a) {
                this.part.remove();
                return true;
            }
            IMultipart newPart = MultipartRegistry.INSTANCE.getPart(state.func_177230_c());
            if (this.part.getPart() == newPart) {
                IBlockState prevState = this.part.getState();
                this.part.setState(state);
                this.func_184138_a(pos, prevState, state, flags);
                return true;
            }
            return false;
        }
        return this.getActualWorld().func_180501_a(pos, state, flags);
    }

    public void markAndNotifyBlock(BlockPos pos, Chunk chunk, IBlockState iblockstate, IBlockState newState, int flags) {
        this.getActualWorld().markAndNotifyBlock(pos, chunk, iblockstate, newState, flags);
    }

    public boolean func_175698_g(BlockPos pos) {
        return this.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
    }

    public boolean func_175655_b(BlockPos pos, boolean dropBlock) {
        if (this.part.getPartPos().equals((Object)pos)) {
            this.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)this.part.getState()));
            if (dropBlock) {
                this.part.getPart().dropPartAsItem(this.part, 0);
            }
            return this.func_175698_g(pos);
        }
        return this.getActualWorld().func_175655_b(pos, dropBlock);
    }

    public void func_184138_a(BlockPos pos, IBlockState oldState, IBlockState newState, int flags) {
        if (this.part.getPartPos().equals((Object)pos)) {
            if ((flags & 1) != 0) {
                this.func_175685_c(pos, newState.func_177230_c(), true);
                this.part.getContainer().getParts().values().forEach(i -> {
                    if (i != this.part) {
                        i.getPart().onPartChanged((IPartInfo)i, this.part);
                    }
                });
            }
            if ((flags & 2) != 0) {
                MultipartNetworkHandler.queuePartChange(this.part.getActualWorld(), new MultipartAction.Change(this.part));
            }
            if ((flags & 4) == 0) {
                this.func_175704_b(pos, pos);
            }
            if ((flags & 0x10) != 0) {
                this.func_190522_c(pos, newState.func_177230_c());
            }
            return;
        }
        this.getActualWorld().func_184138_a(pos, oldState, newState, flags);
    }

    public void func_175722_b(BlockPos pos, Block blockType, boolean notifyObservers) {
        this.getActualWorld().func_175722_b(pos, blockType, notifyObservers);
    }

    public void func_72975_g(int x1, int z1, int x2, int z2) {
        this.getActualWorld().func_72975_g(x1, z1, x2, z2);
    }

    public void func_175704_b(BlockPos rangeMin, BlockPos rangeMax) {
        this.getActualWorld().func_175704_b(rangeMin, rangeMax);
    }

    public void func_147458_c(int x1, int y1, int z1, int x2, int y2, int z2) {
        this.getActualWorld().func_147458_c(x1, y1, z1, x2, y2, z2);
    }

    public void func_190522_c(BlockPos p_190522_1_, Block p_190522_2_) {
        this.getActualWorld().func_190522_c(p_190522_1_, p_190522_2_);
    }

    public void func_175685_c(BlockPos pos, Block blockType, boolean p_175685_3_) {
        this.part.getContainer().getParts().values().forEach(i -> {
            if (i != this.part) {
                i.getPart().onPartChanged((IPartInfo)i, this.part);
            }
        });
        this.getActualWorld().func_175685_c(pos, blockType, p_175685_3_);
    }

    public void func_175695_a(BlockPos pos, Block blockType, EnumFacing skipSide) {
        this.part.getContainer().getParts().values().forEach(i -> {
            if (i != this.part) {
                i.getPart().onPartChanged((IPartInfo)i, this.part);
            }
        });
        this.getActualWorld().func_175695_a(pos, blockType, skipSide);
    }

    public void func_190524_a(BlockPos p_190524_1_, Block p_190524_2_, BlockPos p_190524_3_) {
        this.getActualWorld().func_190524_a(p_190524_1_, p_190524_2_, p_190524_3_);
    }

    public void func_190529_b(BlockPos p_190529_1_, Block p_190529_2_, BlockPos p_190529_3_) {
        this.getActualWorld().func_190529_b(p_190529_1_, p_190529_2_, p_190529_3_);
    }

    public boolean func_175691_a(BlockPos pos, Block blockType) {
        if (this.part.getPartPos().equals((Object)pos)) {
            return this.part.hasPendingTicks();
        }
        return this.getActualWorld().func_175691_a(pos, blockType);
    }

    public boolean func_175678_i(BlockPos pos) {
        return this.getActualWorld().func_175678_i(pos);
    }

    public boolean func_175710_j(BlockPos pos) {
        return this.getActualWorld().func_175710_j(pos);
    }

    public int func_175699_k(BlockPos pos) {
        return this.getActualWorld().func_175699_k(pos);
    }

    public int func_175671_l(BlockPos pos) {
        return this.getActualWorld().func_175671_l(pos);
    }

    public int func_175721_c(BlockPos pos, boolean checkNeighbors) {
        return this.getActualWorld().func_175721_c(pos, checkNeighbors);
    }

    public BlockPos func_175645_m(BlockPos pos) {
        return this.getActualWorld().func_175645_m(pos);
    }

    public int func_189649_b(int x, int z) {
        return this.getActualWorld().func_189649_b(x, z);
    }

    public int func_82734_g(int x, int z) {
        return this.getActualWorld().func_82734_g(x, z);
    }

    public int func_175705_a(EnumSkyBlock type, BlockPos pos) {
        return this.getActualWorld().func_175705_a(type, pos);
    }

    public int func_175642_b(EnumSkyBlock type, BlockPos pos) {
        return this.getActualWorld().func_175642_b(type, pos);
    }

    public void func_175653_a(EnumSkyBlock type, BlockPos pos, int lightValue) {
        this.getActualWorld().func_175653_a(type, pos, lightValue);
    }

    public void func_175679_n(BlockPos pos) {
        this.getActualWorld().func_175679_n(pos);
    }

    public int func_175626_b(BlockPos pos, int lightValue) {
        return this.getActualWorld().func_175626_b(pos, lightValue);
    }

    public float func_175724_o(BlockPos pos) {
        return this.getActualWorld().func_175724_o(pos);
    }

    public IBlockState func_180495_p(BlockPos pos) {
        return this.view.getActualState((IBlockAccess)this.getActualWorld(), pos);
    }

    public boolean func_72935_r() {
        return this.getActualWorld().func_72935_r();
    }

    public RayTraceResult func_72933_a(Vec3d start, Vec3d end) {
        return this.getActualWorld().func_72933_a(start, end);
    }

    public RayTraceResult func_72901_a(Vec3d start, Vec3d end, boolean stopOnLiquid) {
        return this.getActualWorld().func_72901_a(start, end, stopOnLiquid);
    }

    public RayTraceResult func_147447_a(Vec3d vec31, Vec3d vec32, boolean stopOnLiquid, boolean ignoreBlockWithoutBoundingBox, boolean returnLastUncollidableBlock) {
        return this.getActualWorld().func_147447_a(vec31, vec32, stopOnLiquid, ignoreBlockWithoutBoundingBox, returnLastUncollidableBlock);
    }

    public void func_184133_a(EntityPlayer player, BlockPos pos, SoundEvent soundIn, SoundCategory category, float volume, float pitch) {
        this.getActualWorld().func_184133_a(player, pos, soundIn, category, volume, pitch);
    }

    public void func_184148_a(EntityPlayer player, double x, double y, double z, SoundEvent soundIn, SoundCategory category, float volume, float pitch) {
        this.getActualWorld().func_184148_a(player, x, y, z, soundIn, category, volume, pitch);
    }

    public void func_184134_a(double x, double y, double z, SoundEvent soundIn, SoundCategory category, float volume, float pitch, boolean distanceDelay) {
        this.getActualWorld().func_184134_a(x, y, z, soundIn, category, volume, pitch, distanceDelay);
    }

    public void func_184149_a(BlockPos blockPositionIn, SoundEvent soundEventIn) {
        this.getActualWorld().func_184149_a(blockPositionIn, soundEventIn);
    }

    public void func_175688_a(EnumParticleTypes particleType, double xCoord, double yCoord, double zCoord, double xSpeed, double ySpeed, double zSpeed, int ... parameters) {
        this.getActualWorld().func_175688_a(particleType, xCoord, yCoord, zCoord, xSpeed, ySpeed, zSpeed, parameters);
    }

    public void func_190523_a(int p_190523_1_, double p_190523_2_, double p_190523_4_, double p_190523_6_, double p_190523_8_, double p_190523_10_, double p_190523_12_, int ... p_190523_14_) {
        this.getActualWorld().func_190523_a(p_190523_1_, p_190523_2_, p_190523_4_, p_190523_6_, p_190523_8_, p_190523_10_, p_190523_12_, p_190523_14_);
    }

    public void func_175682_a(EnumParticleTypes particleType, boolean ignoreRange, double xCoord, double yCoord, double zCoord, double xSpeed, double ySpeed, double zSpeed, int ... parameters) {
        this.getActualWorld().func_175682_a(particleType, ignoreRange, xCoord, yCoord, zCoord, xSpeed, ySpeed, zSpeed, parameters);
    }

    public boolean func_72942_c(Entity entityIn) {
        return this.getActualWorld().func_72942_c(entityIn);
    }

    public boolean func_72838_d(Entity entityIn) {
        return this.getActualWorld().func_72838_d(entityIn);
    }

    public void func_72923_a(Entity entityIn) {
        this.getActualWorld().func_72923_a(entityIn);
    }

    public void func_72847_b(Entity entityIn) {
        this.getActualWorld().func_72847_b(entityIn);
    }

    public void func_72900_e(Entity entityIn) {
        this.getActualWorld().func_72900_e(entityIn);
    }

    public void func_72973_f(Entity entityIn) {
        this.getActualWorld().func_72973_f(entityIn);
    }

    public void func_72954_a(IWorldEventListener listener) {
        this.getActualWorld().func_72954_a(listener);
    }

    public List<AxisAlignedBB> func_184144_a(Entity entityIn, AxisAlignedBB aabb) {
        return this.getActualWorld().func_184144_a(entityIn, aabb);
    }

    public void func_72848_b(IWorldEventListener listener) {
        this.getActualWorld().func_72848_b(listener);
    }

    public boolean func_184143_b(AxisAlignedBB bbox) {
        return this.getActualWorld().func_184143_b(bbox);
    }

    public int func_72967_a(float partialTicks) {
        return this.getActualWorld().func_72967_a(partialTicks);
    }

    public float getSunBrightnessFactor(float partialTicks) {
        return this.getActualWorld().getSunBrightnessFactor(partialTicks);
    }

    public float func_72971_b(float p_72971_1_) {
        return this.getActualWorld().func_72971_b(p_72971_1_);
    }

    public float getSunBrightnessBody(float p_72971_1_) {
        return this.getActualWorld().getSunBrightnessBody(p_72971_1_);
    }

    public Vec3d func_72833_a(Entity entityIn, float partialTicks) {
        return this.getActualWorld().func_72833_a(entityIn, partialTicks);
    }

    public Vec3d getSkyColorBody(Entity entityIn, float partialTicks) {
        return this.getActualWorld().getSkyColorBody(entityIn, partialTicks);
    }

    public float func_72826_c(float partialTicks) {
        return this.getActualWorld().func_72826_c(partialTicks);
    }

    public int func_72853_d() {
        return this.getActualWorld().func_72853_d();
    }

    public float func_130001_d() {
        return this.getActualWorld().func_130001_d();
    }

    public float getCurrentMoonPhaseFactorBody() {
        return this.getActualWorld().getCurrentMoonPhaseFactorBody();
    }

    public float func_72929_e(float partialTicks) {
        return this.getActualWorld().func_72929_e(partialTicks);
    }

    public Vec3d func_72824_f(float partialTicks) {
        return this.getActualWorld().func_72824_f(partialTicks);
    }

    public Vec3d getCloudColorBody(float partialTicks) {
        return this.getActualWorld().getCloudColorBody(partialTicks);
    }

    public Vec3d func_72948_g(float partialTicks) {
        return this.getActualWorld().func_72948_g(partialTicks);
    }

    public BlockPos func_175725_q(BlockPos pos) {
        return this.getActualWorld().func_175725_q(pos);
    }

    public BlockPos func_175672_r(BlockPos pos) {
        return this.getActualWorld().func_175672_r(pos);
    }

    public float func_72880_h(float partialTicks) {
        return this.getActualWorld().func_72880_h(partialTicks);
    }

    public float getStarBrightnessBody(float partialTicks) {
        return this.getActualWorld().getStarBrightnessBody(partialTicks);
    }

    public boolean func_184145_b(BlockPos pos, Block blk) {
        return this.getActualWorld().func_184145_b(pos, blk);
    }

    public void func_175684_a(BlockPos pos, Block block, int delay) {
        if (this.part.getPartPos().equals((Object)pos)) {
            this.part.scheduleTick(delay);
        } else {
            this.getActualWorld().func_175684_a(pos, block, delay);
        }
    }

    public void func_175654_a(BlockPos pos, Block block, int delay, int priority) {
        if (this.part.getPartPos().equals((Object)pos)) {
            this.part.scheduleTick(delay);
        } else {
            this.getActualWorld().func_175654_a(pos, block, delay, priority);
        }
    }

    public void func_180497_b(BlockPos pos, Block block, int delay, int priority) {
        if (this.part.getPartPos().equals((Object)pos)) {
            this.part.scheduleTick(delay);
        } else {
            this.getActualWorld().func_180497_b(pos, block, delay, priority);
        }
    }

    public void func_72939_s() {
        this.getActualWorld().func_72939_s();
    }

    public boolean func_175700_a(TileEntity tile) {
        return this.getActualWorld().func_175700_a(tile);
    }

    public void func_147448_a(Collection<TileEntity> tileEntityCollection) {
        this.getActualWorld().func_147448_a(tileEntityCollection);
    }

    public void func_72870_g(Entity ent) {
        this.getActualWorld().func_72870_g(ent);
    }

    public void func_72866_a(Entity entityIn, boolean forceUpdate) {
        this.getActualWorld().func_72866_a(entityIn, forceUpdate);
    }

    public boolean func_72855_b(AxisAlignedBB bb) {
        return this.getActualWorld().func_72855_b(bb);
    }

    public boolean func_72917_a(AxisAlignedBB bb, Entity entityIn) {
        return this.getActualWorld().func_72917_a(bb, entityIn);
    }

    public boolean func_72829_c(AxisAlignedBB bb) {
        return this.getActualWorld().func_72829_c(bb);
    }

    public boolean func_72953_d(AxisAlignedBB bb) {
        return this.getActualWorld().func_72953_d(bb);
    }

    public boolean func_147470_e(AxisAlignedBB bb) {
        return this.getActualWorld().func_147470_e(bb);
    }

    public boolean func_72918_a(AxisAlignedBB bb, Material materialIn, Entity entityIn) {
        return this.getActualWorld().func_72918_a(bb, materialIn, entityIn);
    }

    public boolean func_72875_a(AxisAlignedBB bb, Material materialIn) {
        return this.getActualWorld().func_72875_a(bb, materialIn);
    }

    public Explosion func_72876_a(Entity entityIn, double x, double y, double z, float strength, boolean isSmoking) {
        return this.getActualWorld().func_72876_a(entityIn, x, y, z, strength, isSmoking);
    }

    public Explosion func_72885_a(Entity entityIn, double x, double y, double z, float strength, boolean isFlaming, boolean isSmoking) {
        return this.getActualWorld().func_72885_a(entityIn, x, y, z, strength, isFlaming, isSmoking);
    }

    public float func_72842_a(Vec3d vec, AxisAlignedBB bb) {
        return this.getActualWorld().func_72842_a(vec, bb);
    }

    public boolean func_175719_a(EntityPlayer player, BlockPos pos, EnumFacing side) {
        return this.getActualWorld().func_175719_a(player, pos, side);
    }

    public String func_72981_t() {
        return this.getActualWorld().func_72981_t();
    }

    public String func_72827_u() {
        return this.getActualWorld().func_72827_u();
    }

    public TileEntity func_175625_s(BlockPos pos) {
        return this.view.getActualTile((IBlockAccess)this.getActualWorld(), pos);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_175690_a(BlockPos pos, TileEntity tile) {
        if (this.part.getPartPos().equals((Object)pos)) {
            if (!tile.hasCapability(MCMPCapabilities.MULTIPART_TILE, null)) throw new IllegalArgumentException("The specified TileEntity is not a multipart!");
            this.part.setTile((IMultipartTile)tile.getCapability(MCMPCapabilities.MULTIPART_TILE, null));
            return;
        } else {
            this.getActualWorld().func_175690_a(pos, tile);
        }
    }

    public void func_175713_t(BlockPos pos) {
        if (this.part.getPartPos().equals((Object)pos)) {
            TileEntity tileentity = this.func_175625_s(pos);
            if (tileentity != null) {
                tileentity.func_145843_s();
            }
            this.func_175666_e(pos, this.func_180495_p(pos).func_177230_c());
        } else {
            this.getActualWorld().func_175713_t(pos);
        }
    }

    public void func_147457_a(TileEntity tile) {
        if (tile != null) {
            BlockPos pos = tile.func_174877_v();
            if (this.part.getPartPos().equals((Object)pos)) {
                tile.func_145843_s();
                this.func_175666_e(pos, this.func_180495_p(pos).func_177230_c());
                return;
            }
        }
        this.getActualWorld().func_147457_a(tile);
    }

    public boolean func_175665_u(BlockPos pos) {
        return this.getActualWorld().func_175665_u(pos);
    }

    public boolean func_175677_d(BlockPos pos, boolean _default) {
        return this.getActualWorld().func_175677_d(pos, _default);
    }

    public void func_72966_v() {
        this.getActualWorld().func_72966_v();
    }

    public void func_72891_a(boolean hostile, boolean peaceful) {
        this.getActualWorld().func_72891_a(hostile, peaceful);
    }

    public void func_72835_b() {
        this.getActualWorld().func_72835_b();
    }

    public void calculateInitialWeatherBody() {
        this.getActualWorld().calculateInitialWeatherBody();
    }

    public void updateWeatherBody() {
        this.getActualWorld().updateWeatherBody();
    }

    public void func_189507_a(BlockPos pos, IBlockState state, Random random) {
        this.getActualWorld().func_189507_a(pos, state, random);
    }

    public boolean func_175675_v(BlockPos pos) {
        return this.getActualWorld().func_175675_v(pos);
    }

    public boolean func_175662_w(BlockPos pos) {
        return this.getActualWorld().func_175662_w(pos);
    }

    public boolean func_175670_e(BlockPos pos, boolean noWaterAdj) {
        return this.getActualWorld().func_175670_e(pos, noWaterAdj);
    }

    public boolean canBlockFreezeBody(BlockPos pos, boolean noWaterAdj) {
        return this.getActualWorld().canBlockFreezeBody(pos, noWaterAdj);
    }

    public boolean func_175708_f(BlockPos pos, boolean checkLight) {
        return this.getActualWorld().func_175708_f(pos, checkLight);
    }

    public boolean canSnowAtBody(BlockPos pos, boolean checkLight) {
        return this.getActualWorld().canSnowAtBody(pos, checkLight);
    }

    public boolean func_175664_x(BlockPos pos) {
        return this.getActualWorld().func_175664_x(pos);
    }

    public boolean func_180500_c(EnumSkyBlock lightType, BlockPos pos) {
        return this.getActualWorld().func_180500_c(lightType, pos);
    }

    public boolean func_72955_a(boolean p_72955_1_) {
        return this.getActualWorld().func_72955_a(p_72955_1_);
    }

    public List<NextTickListEntry> func_72920_a(Chunk chunkIn, boolean p_72920_2_) {
        return this.getActualWorld().func_72920_a(chunkIn, p_72920_2_);
    }

    public List<NextTickListEntry> func_175712_a(StructureBoundingBox structureBB, boolean p_175712_2_) {
        return this.getActualWorld().func_175712_a(structureBB, p_175712_2_);
    }

    public List<Entity> func_72839_b(Entity entityIn, AxisAlignedBB bb) {
        return this.getActualWorld().func_72839_b(entityIn, bb);
    }

    public List<Entity> func_175674_a(Entity entityIn, AxisAlignedBB boundingBox, Predicate<? super Entity> predicate) {
        return this.getActualWorld().func_175674_a(entityIn, boundingBox, predicate);
    }

    public <T extends Entity> List<T> func_175644_a(Class<? extends T> entityType, Predicate<? super T> filter) {
        return this.getActualWorld().func_175644_a(entityType, filter);
    }

    public <T extends Entity> List<T> func_175661_b(Class<? extends T> playerType, Predicate<? super T> filter) {
        return this.getActualWorld().func_175661_b(playerType, filter);
    }

    public <T extends Entity> List<T> func_72872_a(Class<? extends T> classEntity, AxisAlignedBB bb) {
        return this.getActualWorld().func_72872_a(classEntity, bb);
    }

    public <T extends Entity> List<T> func_175647_a(Class<? extends T> clazz, AxisAlignedBB aabb, Predicate<? super T> filter) {
        return this.getActualWorld().func_175647_a(clazz, aabb, filter);
    }

    public <T extends Entity> T func_72857_a(Class<? extends T> entityType, AxisAlignedBB aabb, T closestTo) {
        return (T)this.getActualWorld().func_72857_a(entityType, aabb, closestTo);
    }

    public Entity func_73045_a(int id) {
        return this.getActualWorld().func_73045_a(id);
    }

    public List<Entity> func_72910_y() {
        return this.getActualWorld().func_72910_y();
    }

    public void func_175646_b(BlockPos pos, TileEntity unusedTileEntity) {
        this.getActualWorld().func_175646_b(pos, unusedTileEntity);
    }

    public int func_72907_a(Class<?> entityType) {
        return this.getActualWorld().func_72907_a(entityType);
    }

    public void func_175650_b(Collection<Entity> entityCollection) {
        this.getActualWorld().func_175650_b(entityCollection);
    }

    public void func_175681_c(Collection<Entity> entityCollection) {
        this.getActualWorld().func_175681_c(entityCollection);
    }

    public boolean func_190527_a(Block p_190527_1_, BlockPos p_190527_2_, boolean p_190527_3_, EnumFacing p_190527_4_, Entity p_190527_5_) {
        return this.getActualWorld().func_190527_a(p_190527_1_, p_190527_2_, p_190527_3_, p_190527_4_, p_190527_5_);
    }

    public int func_181545_F() {
        return this.getActualWorld().func_181545_F();
    }

    public void func_181544_b(int seaLevelIn) {
        this.getActualWorld().func_181544_b(seaLevelIn);
    }

    public int func_175627_a(BlockPos pos, EnumFacing direction) {
        return this.getActualWorld().func_175627_a(pos, direction);
    }

    public WorldType func_175624_G() {
        return this.getActualWorld().func_175624_G();
    }

    public int func_175676_y(BlockPos pos) {
        return this.getActualWorld().func_175676_y(pos);
    }

    public boolean func_175709_b(BlockPos pos, EnumFacing side) {
        return this.getActualWorld().func_175709_b(pos, side);
    }

    public int func_175651_c(BlockPos pos, EnumFacing facing) {
        return this.getActualWorld().func_175651_c(pos, facing);
    }

    public boolean func_175640_z(BlockPos pos) {
        return this.getActualWorld().func_175640_z(pos);
    }

    public int func_175687_A(BlockPos pos) {
        return this.getActualWorld().func_175687_A(pos);
    }

    public EntityPlayer func_72890_a(Entity entityIn, double distance) {
        return this.getActualWorld().func_72890_a(entityIn, distance);
    }

    public EntityPlayer func_184136_b(Entity entityIn, double distance) {
        return this.getActualWorld().func_184136_b(entityIn, distance);
    }

    public EntityPlayer func_184137_a(double posX, double posY, double posZ, double distance, boolean spectator) {
        return this.getActualWorld().func_184137_a(posX, posY, posZ, distance, spectator);
    }

    public EntityPlayer func_190525_a(double p_190525_1_, double p_190525_3_, double p_190525_5_, double p_190525_7_, Predicate<Entity> p_190525_9_) {
        return this.getActualWorld().func_190525_a(p_190525_1_, p_190525_3_, p_190525_5_, p_190525_7_, p_190525_9_);
    }

    public boolean func_175636_b(double x, double y, double z, double range) {
        return this.getActualWorld().func_175636_b(x, y, z, range);
    }

    public EntityPlayer func_184142_a(Entity entityIn, double maxXZDistance, double maxYDistance) {
        return this.getActualWorld().func_184142_a(entityIn, maxXZDistance, maxYDistance);
    }

    public EntityPlayer func_184139_a(BlockPos pos, double maxXZDistance, double maxYDistance) {
        return this.getActualWorld().func_184139_a(pos, maxXZDistance, maxYDistance);
    }

    public EntityPlayer func_184150_a(double posX, double posY, double posZ, double maxXZDistance, double maxYDistance, Function<EntityPlayer, Double> playerToDouble, Predicate<EntityPlayer> p_184150_12_) {
        return this.getActualWorld().func_184150_a(posX, posY, posZ, maxXZDistance, maxYDistance, playerToDouble, p_184150_12_);
    }

    public EntityPlayer func_72924_a(String name) {
        return this.getActualWorld().func_72924_a(name);
    }

    public EntityPlayer func_152378_a(UUID uuid) {
        return this.getActualWorld().func_152378_a(uuid);
    }

    public void func_72882_A() {
        this.getActualWorld().func_72882_A();
    }

    public void func_72906_B() throws MinecraftException {
        this.getActualWorld().func_72906_B();
    }

    public void func_82738_a(long worldTime) {
        this.getActualWorld().func_82738_a(worldTime);
    }

    public long func_72905_C() {
        return this.getActualWorld().func_72905_C();
    }

    public long func_82737_E() {
        return this.getActualWorld().func_82737_E();
    }

    public long func_72820_D() {
        return this.getActualWorld().func_72820_D();
    }

    public void func_72877_b(long time) {
        this.getActualWorld().func_72877_b(time);
    }

    public BlockPos func_175694_M() {
        return this.getActualWorld().func_175694_M();
    }

    public void func_175652_B(BlockPos pos) {
        this.getActualWorld().func_175652_B(pos);
    }

    public void func_72897_h(Entity entityIn) {
        this.getActualWorld().func_72897_h(entityIn);
    }

    public boolean func_175660_a(EntityPlayer player, BlockPos pos) {
        return this.getActualWorld().func_175660_a(player, pos);
    }

    public boolean canMineBlockBody(EntityPlayer player, BlockPos pos) {
        return this.getActualWorld().canMineBlockBody(player, pos);
    }

    public void func_72960_a(Entity entityIn, byte state) {
        this.getActualWorld().func_72960_a(entityIn, state);
    }

    public IChunkProvider func_72863_F() {
        return this.getActualWorld().func_72863_F();
    }

    public void func_175641_c(BlockPos pos, Block blockIn, int eventID, int eventParam) {
        this.getActualWorld().func_175641_c(pos, blockIn, eventID, eventParam);
    }

    public ISaveHandler func_72860_G() {
        return this.getActualWorld().func_72860_G();
    }

    public WorldInfo func_72912_H() {
        return this.getActualWorld().func_72912_H();
    }

    public GameRules func_82736_K() {
        return this.getActualWorld().func_82736_K();
    }

    public void func_72854_c() {
        this.getActualWorld().func_72854_c();
    }

    public float func_72819_i(float delta) {
        return this.getActualWorld().func_72819_i(delta);
    }

    public void func_147442_i(float strength) {
        this.getActualWorld().func_147442_i(strength);
    }

    public float func_72867_j(float delta) {
        return this.getActualWorld().func_72867_j(delta);
    }

    public void func_72894_k(float strength) {
        this.getActualWorld().func_72894_k(strength);
    }

    public boolean func_72911_I() {
        return this.getActualWorld().func_72911_I();
    }

    public boolean func_72896_J() {
        return this.getActualWorld().func_72896_J();
    }

    public boolean func_175727_C(BlockPos strikePosition) {
        return this.getActualWorld().func_175727_C(strikePosition);
    }

    public boolean func_180502_D(BlockPos pos) {
        return this.getActualWorld().func_180502_D(pos);
    }

    public MapStorage func_175693_T() {
        return this.getActualWorld().func_175693_T();
    }

    public void func_72823_a(String dataID, WorldSavedData worldSavedDataIn) {
        this.getActualWorld().func_72823_a(dataID, worldSavedDataIn);
    }

    public WorldSavedData func_72943_a(Class<? extends WorldSavedData> clazz, String dataID) {
        return this.getActualWorld().func_72943_a(clazz, dataID);
    }

    public int func_72841_b(String key) {
        return this.getActualWorld().func_72841_b(key);
    }

    public void func_175669_a(int id, BlockPos pos, int data) {
        this.getActualWorld().func_175669_a(id, pos, data);
    }

    public void func_175718_b(int type, BlockPos pos, int data) {
        this.getActualWorld().func_175718_b(type, pos, data);
    }

    public void func_180498_a(EntityPlayer player, int type, BlockPos pos, int data) {
        this.getActualWorld().func_180498_a(player, type, pos, data);
    }

    public int func_72800_K() {
        return this.getActualWorld().func_72800_K();
    }

    public int func_72940_L() {
        return this.getActualWorld().func_72940_L();
    }

    public Random func_72843_D(int p_72843_1_, int p_72843_2_, int p_72843_3_) {
        return this.getActualWorld().func_72843_D(p_72843_1_, p_72843_2_, p_72843_3_);
    }

    public CrashReportCategory func_72914_a(CrashReport report) {
        return this.getActualWorld().func_72914_a(report);
    }

    public double func_72919_O() {
        return this.getActualWorld().func_72919_O();
    }

    public void func_175715_c(int breakerId, BlockPos pos, int progress) {
        this.getActualWorld().func_175715_c(breakerId, pos, progress);
    }

    public Calendar func_83015_S() {
        return this.getActualWorld().func_83015_S();
    }

    public void func_92088_a(double x, double y, double z, double motionX, double motionY, double motionZ, NBTTagCompound compund) {
        this.getActualWorld().func_92088_a(x, y, z, motionX, motionY, motionZ, compund);
    }

    public Scoreboard func_96441_U() {
        return this.getActualWorld().func_96441_U();
    }

    public void func_175666_e(BlockPos pos, Block blockIn) {
        this.getActualWorld().func_175666_e(pos, blockIn);
    }

    public DifficultyInstance func_175649_E(BlockPos pos) {
        return this.getActualWorld().func_175649_E(pos);
    }

    public EnumDifficulty func_175659_aa() {
        return this.getActualWorld().func_175659_aa();
    }

    public int func_175657_ab() {
        return this.getActualWorld().func_175657_ab();
    }

    public void func_175692_b(int newSkylightSubtracted) {
        this.getActualWorld().func_175692_b(newSkylightSubtracted);
    }

    public int func_175658_ac() {
        return this.getActualWorld().func_175658_ac();
    }

    public void func_175702_c(int lastLightningBoltIn) {
        this.getActualWorld().func_175702_c(lastLightningBoltIn);
    }

    public VillageCollection func_175714_ae() {
        return this.getActualWorld().func_175714_ae();
    }

    public WorldBorder func_175723_af() {
        return this.getActualWorld().func_175723_af();
    }

    public boolean func_72916_c(int x, int z) {
        return this.getActualWorld().func_72916_c(x, z);
    }

    public boolean isSideSolid(BlockPos pos, EnumFacing side) {
        return this.getActualWorld().isSideSolid(pos, side);
    }

    public boolean isSideSolid(BlockPos pos, EnumFacing side, boolean _default) {
        return this.getActualWorld().isSideSolid(pos, side, _default);
    }

    public ImmutableSetMultimap<ChunkPos, ForgeChunkManager.Ticket> getPersistentChunks() {
        return this.getActualWorld().getPersistentChunks();
    }

    public Iterator<Chunk> getPersistentChunkIterable(Iterator<Chunk> chunkIterator) {
        return this.getActualWorld().getPersistentChunkIterable(chunkIterator);
    }

    public int getBlockLightOpacity(BlockPos pos) {
        return this.getActualWorld().getBlockLightOpacity(pos);
    }

    public int countEntities(EnumCreatureType type, boolean forSpawnCount) {
        return this.getActualWorld().countEntities(type, forSpawnCount);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return this.getActualWorld().hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)this.getActualWorld().getCapability(capability, facing);
    }

    public MapStorage getPerWorldStorage() {
        return this.getActualWorld().getPerWorldStorage();
    }

    public void func_184135_a(Packet<?> packetIn) {
        this.getActualWorld().func_184135_a(packetIn);
    }

    public LootTableManager func_184146_ak() {
        return this.getActualWorld().func_184146_ak();
    }

    public BlockPos func_190528_a(String p_190528_1_, BlockPos p_190528_2_, boolean p_190528_3_) {
        return this.getActualWorld().func_190528_a(p_190528_1_, p_190528_2_, p_190528_3_);
    }
}

