/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded;

import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import powercrystals.minefactoryreloaded.MFRRegistry;
import powercrystals.minefactoryreloaded.MineFactoryReloadedCore;
import powercrystals.minefactoryreloaded.api.FertilizerType;
import powercrystals.minefactoryreloaded.api.IFactoryFertilizable;
import powercrystals.minefactoryreloaded.api.IFactoryFertilizer;
import powercrystals.minefactoryreloaded.api.IFactoryFruit;
import powercrystals.minefactoryreloaded.api.IFactoryGrindable;
import powercrystals.minefactoryreloaded.api.IFactoryHarvestable;
import powercrystals.minefactoryreloaded.api.IFactoryPlantable;
import powercrystals.minefactoryreloaded.api.IFactoryRanchable;
import powercrystals.minefactoryreloaded.api.ILiquidDrinkHandler;
import powercrystals.minefactoryreloaded.api.IMobEggHandler;
import powercrystals.minefactoryreloaded.api.IMobSpawnHandler;
import powercrystals.minefactoryreloaded.api.IRandomMobProvider;
import powercrystals.minefactoryreloaded.api.ISafariNetHandler;
import powercrystals.minefactoryreloaded.api.ValuedItem;
import powercrystals.minefactoryreloaded.api.rednet.IRedNetLogicCircuit;
import powercrystals.minefactoryreloaded.farmables.fertilizables.FertilizableCocoa;
import powercrystals.minefactoryreloaded.farmables.fertilizables.FertilizableCropPlant;
import powercrystals.minefactoryreloaded.farmables.fertilizables.FertilizableGrass;
import powercrystals.minefactoryreloaded.farmables.fertilizables.FertilizableStandard;
import powercrystals.minefactoryreloaded.farmables.fertilizables.FertilizableStemPlants;
import powercrystals.minefactoryreloaded.farmables.fertilizables.FertilizerStandard;
import powercrystals.minefactoryreloaded.farmables.harvestables.HarvestableCropPlant;
import powercrystals.minefactoryreloaded.farmables.harvestables.HarvestableGourd;
import powercrystals.minefactoryreloaded.farmables.harvestables.HarvestableMushroom;
import powercrystals.minefactoryreloaded.farmables.harvestables.HarvestableShrub;
import powercrystals.minefactoryreloaded.farmables.harvestables.HarvestableStandard;
import powercrystals.minefactoryreloaded.farmables.harvestables.HarvestableStemPlant;
import powercrystals.minefactoryreloaded.farmables.harvestables.HarvestableTreeLeaves;
import powercrystals.minefactoryreloaded.farmables.harvestables.HarvestableVine;
import powercrystals.minefactoryreloaded.farmables.harvestables.HarvestableWood;
import powercrystals.minefactoryreloaded.farmables.plantables.PlantableCropPlant;
import powercrystals.minefactoryreloaded.farmables.plantables.PlantableSapling;
import powercrystals.minefactoryreloaded.farmables.plantables.PlantableStandard;

public class IMCHandler {
    public static void processIMC(List<FMLInterModComms.IMCMessage> list) {
        Logger logger = MineFactoryReloadedCore.instance().getLogger();
        for (FMLInterModComms.IMCMessage iMCMessage : list) {
            try {
                Object object;
                String string = iMCMessage.key;
                logger.debug("[IMCHandler] %s from %s", new Object[]{string, iMCMessage.getSender()});
                if ("addLaserPreferredOre".equals(string)) {
                    if (iMCMessage.isNBTMessage()) {
                        object = iMCMessage.getNBTValue();
                        MFRRegistry.addLaserPreferredOre(object.func_74762_e("value"), ItemStack.func_77949_a((NBTTagCompound)object));
                        continue;
                    }
                    object = (ValuedItem)IMCHandler.getValue(iMCMessage);
                    MFRRegistry.addLaserPreferredOre(object.value, object.item);
                    continue;
                }
                if ("registerAutoSpawnerBlacklist".equals(string)) {
                    if (iMCMessage.isStringMessage()) {
                        MFRRegistry.registerAutoSpawnerBlacklist(iMCMessage.getStringValue());
                        continue;
                    }
                    MFRRegistry.registerAutoSpawnerBlacklistClass((Class)IMCHandler.getValue(iMCMessage));
                    continue;
                }
                if ("registerFertilizable".equals(string)) {
                    MFRRegistry.registerFertilizable((IFactoryFertilizable)IMCHandler.getValue(iMCMessage));
                    continue;
                }
                if ("registerFertilizer".equals(string)) {
                    MFRRegistry.registerFertilizer((IFactoryFertilizer)IMCHandler.getValue(iMCMessage));
                    continue;
                }
                if ("registerFruitLog".equals(string)) {
                    MFRRegistry.registerFruitLogBlock(Block.func_149684_b((String)iMCMessage.getStringValue()));
                    continue;
                }
                if ("registerGrindable".equals(string)) {
                    MFRRegistry.registerGrindable((IFactoryGrindable)IMCHandler.getValue(iMCMessage));
                    continue;
                }
                if ("registerGrinderBlacklist".equals(string)) {
                    MFRRegistry.registerGrinderBlacklist((Class)IMCHandler.getValue(iMCMessage));
                    continue;
                }
                if ("registerHarvestable".equals(string)) {
                    MFRRegistry.registerHarvestable((IFactoryHarvestable)IMCHandler.getValue(iMCMessage));
                    continue;
                }
                if ("registerLaserOre".equals(string)) {
                    if (iMCMessage.isNBTMessage()) {
                        object = iMCMessage.getNBTValue();
                        MFRRegistry.registerLaserOre(object.func_74762_e("value"), ItemStack.func_77949_a((NBTTagCompound)object));
                        continue;
                    }
                    object = (ValuedItem)IMCHandler.getValue(iMCMessage);
                    MFRRegistry.registerLaserOre(object.value, object.item);
                    continue;
                }
                if ("registerLiquidDrinkHandler".equals(string)) {
                    object = (ValuedItem)IMCHandler.getValue(iMCMessage);
                    MFRRegistry.registerLiquidDrinkHandler(object.key, (ILiquidDrinkHandler)object.object);
                    continue;
                }
                if ("registerMobEggHandler".equals(string)) {
                    MFRRegistry.registerMobEggHandler((IMobEggHandler)IMCHandler.getValue(iMCMessage));
                    continue;
                }
                if ("registerPickableFruit".equals(string)) {
                    MFRRegistry.registerFruit((IFactoryFruit)IMCHandler.getValue(iMCMessage));
                    continue;
                }
                if ("registerPlantable".equals(string)) {
                    MFRRegistry.registerPlantable((IFactoryPlantable)IMCHandler.getValue(iMCMessage));
                    continue;
                }
                if ("registerRanchable".equals(string)) {
                    MFRRegistry.registerRanchable((IFactoryRanchable)IMCHandler.getValue(iMCMessage));
                    continue;
                }
                if ("registerRedNetLogicCircuit".equals(string)) {
                    if (iMCMessage.isStringMessage()) {
                        MFRRegistry.registerRedNetLogicCircuit((IRedNetLogicCircuit)Class.forName(iMCMessage.getStringValue()).newInstance());
                        continue;
                    }
                    MFRRegistry.registerRedNetLogicCircuit((IRedNetLogicCircuit)IMCHandler.getValue(iMCMessage));
                    continue;
                }
                if ("registerRubberTreeBiome".equals(string)) {
                    MFRRegistry.registerRubberTreeBiome(iMCMessage.getStringValue());
                    continue;
                }
                if ("registerSafariNetBlacklist".equals(string)) {
                    MFRRegistry.registerSafariNetBlacklist((Class)IMCHandler.getValue(iMCMessage));
                    continue;
                }
                if ("registerSafariNetHandler".equals(string)) {
                    MFRRegistry.registerSafariNetHandler((ISafariNetHandler)IMCHandler.getValue(iMCMessage));
                    continue;
                }
                if ("registerSludgeDrop".equals(string)) {
                    if (iMCMessage.isNBTMessage()) {
                        object = iMCMessage.getNBTValue();
                        MFRRegistry.registerSludgeDrop(object.func_74762_e("value"), ItemStack.func_77949_a((NBTTagCompound)object));
                        continue;
                    }
                    object = (ValuedItem)IMCHandler.getValue(iMCMessage);
                    MFRRegistry.registerSludgeDrop(object.value, object.item);
                    continue;
                }
                if ("registerSpawnHandler".equals(string)) {
                    MFRRegistry.registerSpawnHandler((IMobSpawnHandler)IMCHandler.getValue(iMCMessage));
                    continue;
                }
                if ("registerVillagerTradeMob".equals(string)) {
                    MFRRegistry.registerRandomMobProvider((IRandomMobProvider)IMCHandler.getValue(iMCMessage));
                    continue;
                }
                if ("registerHarvestable_Standard".equals(string)) {
                    MFRRegistry.registerHarvestable(new HarvestableStandard(Block.func_149684_b((String)iMCMessage.getStringValue())));
                    continue;
                }
                if ("registerHarvestable_Log".equals(string)) {
                    MFRRegistry.registerHarvestable(new HarvestableWood(Block.func_149684_b((String)iMCMessage.getStringValue())));
                    continue;
                }
                if ("registerHarvestable_Leaves".equals(string)) {
                    MFRRegistry.registerHarvestable(new HarvestableTreeLeaves(Block.func_149684_b((String)iMCMessage.getStringValue())));
                    continue;
                }
                if ("registerHarvestable_Vine".equals(string)) {
                    MFRRegistry.registerHarvestable(new HarvestableVine(Block.func_149684_b((String)iMCMessage.getStringValue())));
                    continue;
                }
                if ("registerHarvestable_Shrub".equals(string)) {
                    MFRRegistry.registerHarvestable(new HarvestableShrub(Block.func_149684_b((String)iMCMessage.getStringValue())));
                    continue;
                }
                if ("registerHarvestable_Mushroom".equals(string)) {
                    MFRRegistry.registerHarvestable(new HarvestableMushroom(Block.func_149684_b((String)iMCMessage.getStringValue())));
                    continue;
                }
                if ("registerHarvestable_Crop".equals(string)) {
                    if (iMCMessage.isItemStackMessage()) {
                        object = iMCMessage.getItemStackValue();
                        MFRRegistry.registerHarvestable(new HarvestableCropPlant(Block.func_149634_a((Item)object.func_77973_b()), object.func_77960_j()));
                        continue;
                    }
                    object = (ValuedItem)IMCHandler.getValue(iMCMessage);
                    MFRRegistry.registerHarvestable(new HarvestableCropPlant((Block)object.object, object.value));
                    continue;
                }
                if ("registerHarvestable_Gourd".equals(string)) {
                    object = iMCMessage.getNBTValue();
                    MFRRegistry.registerHarvestable(new HarvestableStemPlant(Block.func_149684_b((String)object.func_74779_i("stem")), Block.func_149684_b((String)object.func_74779_i("fruit"))));
                    MFRRegistry.registerHarvestable(new HarvestableGourd(Block.func_149684_b((String)object.func_74779_i("fruit"))));
                    continue;
                }
                if ("registerPlantable_Crop".equals(string)) {
                    object = iMCMessage.getNBTValue();
                    if (object.func_74764_b("meta")) {
                        MFRRegistry.registerPlantable(new PlantableCropPlant((Item)Item.field_150901_e.func_82594_a(object.func_74779_i("seed")), Block.func_149684_b((String)object.func_74779_i("crop")), object.func_74762_e("meta")));
                        continue;
                    }
                    MFRRegistry.registerPlantable(new PlantableCropPlant((Item)Item.field_150901_e.func_82594_a(object.func_74779_i("seed")), Block.func_149684_b((String)object.func_74779_i("crop"))));
                    continue;
                }
                if ("registerPlantable_Sapling".equals(string)) {
                    object = iMCMessage.getNBTValue();
                    if (object.func_74764_b("seed")) {
                        MFRRegistry.registerPlantable(new PlantableSapling((Item)Item.field_150901_e.func_82594_a(object.func_74779_i("seed")), Block.func_149684_b((String)object.func_74779_i("sapling"))));
                        continue;
                    }
                    MFRRegistry.registerPlantable(new PlantableSapling(Block.func_149684_b((String)object.func_74779_i("sapling"))));
                    continue;
                }
                if ("registerPlantable_Standard".equals(string)) {
                    object = iMCMessage.getNBTValue();
                    if (object.func_74764_b("meta")) {
                        MFRRegistry.registerPlantable(new PlantableStandard((Item)Item.field_150901_e.func_82594_a(object.func_74779_i("seed")), Block.func_149684_b((String)object.func_74779_i("crop")), object.func_74762_e("meta")));
                        continue;
                    }
                    MFRRegistry.registerPlantable(new PlantableStandard((Item)Item.field_150901_e.func_82594_a(object.func_74779_i("seed")), Block.func_149684_b((String)object.func_74779_i("crop"))));
                    continue;
                }
                if ("registerFertilizer_Standard".equals(string)) {
                    object = iMCMessage.getNBTValue();
                    MFRRegistry.registerFertilizer(new FertilizerStandard((Item)Item.field_150901_e.func_82594_a(object.func_74779_i("fert")), object.func_74762_e("meta"), FertilizerType.values()[object.func_74762_e("type")]));
                    continue;
                }
                if ("registerFertilizable_Grass".equals(string)) {
                    MFRRegistry.registerFertilizable(new FertilizableGrass(Block.func_149684_b((String)iMCMessage.getStringValue())));
                    continue;
                }
                if ("registerFertilizable_Gourd".equals(string)) {
                    MFRRegistry.registerFertilizable(new FertilizableStemPlants((IGrowable)Block.func_149684_b((String)iMCMessage.getStringValue())));
                    continue;
                }
                if ("registerFertilizable_Crop".equals(string)) {
                    object = iMCMessage.getNBTValue();
                    if (object.func_74764_b("type")) {
                        MFRRegistry.registerFertilizable(new FertilizableCropPlant((IGrowable)Block.func_149684_b((String)object.func_74779_i("plant")), FertilizerType.values()[object.func_74762_e("type")], object.func_74762_e("meta")));
                        continue;
                    }
                    MFRRegistry.registerFertilizable(new FertilizableCropPlant((IGrowable)Block.func_149684_b((String)object.func_74779_i("plant")), object.func_74762_e("meta")));
                    continue;
                }
                if ("registerFertilizable_Cocoa".equals(string)) {
                    object = iMCMessage.getNBTValue();
                    if (object.func_74764_b("type")) {
                        MFRRegistry.registerFertilizable(new FertilizableCocoa(Block.func_149684_b((String)object.func_74779_i("plant")), FertilizerType.values()[object.func_74762_e("type")]));
                        continue;
                    }
                    MFRRegistry.registerFertilizable(new FertilizableCocoa(Block.func_149684_b((String)object.func_74779_i("plant"))));
                    continue;
                }
                if ("registerFertilizable_Standard".equals(string)) {
                    object = iMCMessage.getNBTValue();
                    if (object.func_74764_b("type")) {
                        MFRRegistry.registerFertilizable(new FertilizableStandard((IGrowable)Block.func_149684_b((String)object.func_74779_i("plant")), FertilizerType.values()[object.func_74762_e("type")]));
                        continue;
                    }
                    MFRRegistry.registerFertilizable(new FertilizableStandard((IGrowable)Block.func_149684_b((String)object.func_74779_i("plant"))));
                    continue;
                }
                IMCHandler.bigWarning(logger, Level.WARN, "Unknown IMC message (%s)\nfrom %s", string, iMCMessage.getSender());
            }
            catch (Throwable throwable) {
                IMCHandler.bigWarning(logger, Level.ERROR, "Bad IMC message (%s)\nfrom %s", iMCMessage.key, iMCMessage.getSender());
                logger.catching(throwable);
            }
        }
    }

    private static Object getValue(FMLInterModComms.IMCMessage iMCMessage) {
        return ReflectionHelper.getPrivateValue(FMLInterModComms.IMCMessage.class, (Object)iMCMessage, (String[])new String[]{"value"});
    }

    private static void bigWarning(Logger logger, Level level, String string, Object ... objectArray) {
        String string2 = String.format(string, objectArray);
        String string3 = "************************";
        string3 = string3 + string3;
        logger.log(level, string3);
        logger.log(level, string3);
        for (String string4 : string2.split("\n", 0)) {
            logger.log(level, string4);
        }
        logger.log(level, string3);
        logger.log(level, string3);
    }
}

