/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.block;

import cofh.api.block.IDismantleable;
import cofh.core.render.hitbox.CustomHitBox;
import cofh.core.render.hitbox.ICustomHitBox;
import cofh.core.render.hitbox.RenderHitbox;
import cofh.lib.util.position.IRotateableTile;
import cofh.repack.codechicken.lib.raytracer.IndexedCuboid6;
import cofh.repack.codechicken.lib.raytracer.RayTracer;
import cofh.repack.codechicken.lib.vec.BlockCoord;
import cofh.repack.codechicken.lib.vec.Vector3;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.IFluidContainerItem;
import powercrystals.minefactoryreloaded.api.rednet.connectivity.IRedNetConnection;
import powercrystals.minefactoryreloaded.api.rednet.connectivity.RedNetConnectionType;
import powercrystals.minefactoryreloaded.core.IEntityCollidable;
import powercrystals.minefactoryreloaded.core.ITankContainerBucketable;
import powercrystals.minefactoryreloaded.core.ITraceable;
import powercrystals.minefactoryreloaded.core.MFRLiquidMover;
import powercrystals.minefactoryreloaded.core.MFRUtil;
import powercrystals.minefactoryreloaded.gui.MFRCreativeTab;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityBase;

public class BlockFactory
extends Block
implements IRedNetConnection,
IDismantleable,
ITileEntityProvider {
    protected boolean providesPower;
    protected ThreadLocal<Boolean> draw = new ThreadLocal();

    protected BlockFactory(float f) {
        super(Machine.MATERIAL);
        this.func_149711_c(f);
        this.func_149672_a(Block.field_149777_j);
        this.func_149647_a(MFRCreativeTab.tab);
        this.setHarvestLevel("pickaxe", 0);
    }

    protected BlockFactory(Material material) {
        super(material);
        this.func_149647_a(MFRCreativeTab.tab);
        this.setHarvestLevel("pickaxe", 0);
    }

    protected static final TileEntity getTile(World world, int n, int n2, int n3) {
        return MFRUtil.getTile(world, n, n2, n3);
    }

    public void func_149681_a(World world, int n, int n2, int n3, int n4, EntityPlayer entityPlayer) {
        if (!entityPlayer.field_71075_bZ.field_75098_d) {
            this.harvesters.set(entityPlayer);
            this.func_149697_b(world, n, n2, n3, n4, EnchantmentHelper.func_77517_e((EntityLivingBase)entityPlayer));
            this.harvesters.set(null);
            world.func_147465_d(n, n2, n3, Blocks.field_150350_a, 0, 7);
        }
    }

    public void func_149636_a(World world, EntityPlayer entityPlayer, int n, int n2, int n3, int n4) {
    }

    public boolean rotateBlock(World world, int n, int n2, int n3, ForgeDirection forgeDirection) {
        IRotateableTile iRotateableTile;
        if (world.field_72995_K) {
            return false;
        }
        TileEntity tileEntity = BlockFactory.getTile(world, n, n2, n3);
        if (tileEntity instanceof IRotateableTile && (iRotateableTile = (IRotateableTile)tileEntity).canRotate(forgeDirection)) {
            iRotateableTile.rotate(forgeDirection);
            return true;
        }
        return false;
    }

    public void func_149689_a(World world, int n, int n2, int n3, EntityLivingBase entityLivingBase, ItemStack itemStack) {
        TileEntity tileEntity = BlockFactory.getTile(world, n, n2, n3);
        if (tileEntity instanceof TileEntityBase && itemStack.func_77978_p() != null) {
            tileEntity.func_145839_a(itemStack.func_77978_p());
        }
    }

    public final boolean func_149727_a(World world, int n, int n2, int n3, EntityPlayer entityPlayer, int n4, float f, float f2, float f3) {
        PlayerInteractEvent playerInteractEvent = new PlayerInteractEvent(entityPlayer, PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK, n, n2, n3, n4, world);
        if (MinecraftForge.EVENT_BUS.post((Event)playerInteractEvent) || playerInteractEvent.getResult() == Event.Result.DENY || playerInteractEvent.useBlock == Event.Result.DENY) {
            return false;
        }
        this.activationOffsets(f, f2, f3);
        return this.activated(world, n, n2, n3, entityPlayer, n4);
    }

    protected void activationOffsets(float f, float f2, float f3) {
    }

    protected boolean activated(World world, int n, int n2, int n3, EntityPlayer entityPlayer, int n4) {
        TileEntity tileEntity = world.func_147438_o(n, n2, n3);
        if (tileEntity == null) {
            return false;
        }
        ItemStack itemStack = entityPlayer.field_71071_by.func_70448_g();
        if (itemStack != null && tileEntity instanceof ITankContainerBucketable) {
            boolean bl = itemStack.func_77973_b() instanceof IFluidContainerItem;
            if ((bl || FluidContainerRegistry.isEmptyContainer((ItemStack)itemStack)) && ((ITankContainerBucketable)tileEntity).allowBucketDrain(itemStack) && MFRLiquidMover.manuallyDrainTank((ITankContainerBucketable)tileEntity, entityPlayer)) {
                return true;
            }
            if ((bl || FluidContainerRegistry.isFilledContainer((ItemStack)itemStack)) && ((ITankContainerBucketable)tileEntity).allowBucketFill(itemStack) && MFRLiquidMover.manuallyFillTank((ITankContainerBucketable)tileEntity, entityPlayer)) {
                return true;
            }
        }
        return false;
    }

    public boolean canDismantle(EntityPlayer entityPlayer, World world, int n, int n2, int n3) {
        return true;
    }

    public ArrayList<ItemStack> dismantleBlock(EntityPlayer entityPlayer, World world, int n, int n2, int n3, boolean bl) {
        ArrayList<ItemStack> arrayList = this.getDrops(world, n, n2, n3, world.func_72805_g(n, n2, n3), 0);
        world.func_147468_f(n, n2, n3);
        if (!bl) {
            for (ItemStack itemStack : arrayList) {
                this.func_149642_a(world, n, n2, n3, itemStack);
            }
        }
        return arrayList;
    }

    public ArrayList<ItemStack> getDrops(World world, int n, int n2, int n3, int n4, int n5) {
        ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
        ItemStack itemStack = new ItemStack(this.func_149650_a(n4, world.field_73012_v, n5), 1, this.func_149692_a(n4));
        TileEntity tileEntity = BlockFactory.getTile(world, n, n2, n3);
        if (tileEntity instanceof TileEntityBase) {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            ((TileEntityBase)tileEntity).writeItemNBT(nBTTagCompound);
            if (!nBTTagCompound.func_82582_d()) {
                itemStack.func_77982_d(nBTTagCompound);
            }
        }
        arrayList.add(itemStack);
        return arrayList;
    }

    public void getBlockInfo(IBlockAccess iBlockAccess, int n, int n2, int n3, ForgeDirection forgeDirection, EntityPlayer entityPlayer, List<IChatComponent> list, boolean bl) {
        TileEntity tileEntity = iBlockAccess.func_147438_o(n, n2, n3);
        if (tileEntity instanceof TileEntityBase) {
            ((TileEntityBase)tileEntity).getTileInfo(list, forgeDirection, entityPlayer, bl);
        }
    }

    public void func_149726_b(World world, int n, int n2, int n3) {
        this.func_149695_a(world, n, n2, n3, this);
    }

    public void func_149695_a(World world, int n, int n2, int n3, Block block) {
        super.func_149695_a(world, n, n2, n3, block);
        if (world.field_72995_K) {
            return;
        }
        TileEntity tileEntity = BlockFactory.getTile(world, n, n2, n3);
        if (tileEntity instanceof TileEntityBase) {
            if (block != this) {
                ((TileEntityBase)tileEntity).onNeighborBlockChange();
            } else {
                ((TileEntityBase)tileEntity).onMatchedNeighborBlockChange();
            }
        }
    }

    public void onNeighborChange(IBlockAccess iBlockAccess, int n, int n2, int n3, int n4, int n5, int n6) {
        TileEntity tileEntity;
        TileEntity tileEntity2 = tileEntity = iBlockAccess instanceof World ? BlockFactory.getTile((World)iBlockAccess, n, n2, n3) : iBlockAccess.func_147438_o(n, n2, n3);
        if (tileEntity instanceof TileEntityBase) {
            ((TileEntityBase)tileEntity).onNeighborTileChange(n4, n5, n6);
        }
    }

    public AxisAlignedBB func_149668_a(World world, int n, int n2, int n3) {
        TileEntity tileEntity = BlockFactory.getTile(world, n, n2, n3);
        if (tileEntity instanceof IEntityCollidable) {
            float f = 0.125f;
            return AxisAlignedBB.func_72330_a((double)((float)n + f), (double)((float)n2 + f), (double)((float)n3 + f), (double)((float)(n + 1) - f), (double)((float)(n2 + 1) - f), (double)((float)(n3 + 1) - f));
        }
        return super.func_149668_a(world, n, n2, n3);
    }

    public void func_149670_a(World world, int n, int n2, int n3, Entity entity) {
        if (world.field_72995_K) {
            return;
        }
        TileEntity tileEntity = BlockFactory.getTile(world, n, n2, n3);
        if (tileEntity instanceof IEntityCollidable) {
            ((IEntityCollidable)tileEntity).onEntityCollided(entity);
        }
        super.func_149670_a(world, n, n2, n3, entity);
    }

    public void func_149743_a(World world, int n, int n2, int n3, AxisAlignedBB axisAlignedBB, List list, Entity entity) {
        TileEntity tileEntity = BlockFactory.getTile(world, n, n2, n3);
        if (tileEntity instanceof ITraceable) {
            LinkedList<IndexedCuboid6> linkedList = new LinkedList<IndexedCuboid6>();
            ((ITraceable)tileEntity).addTraceableCuboids(linkedList, false, false);
            for (IndexedCuboid6 indexedCuboid6 : linkedList) {
                AxisAlignedBB axisAlignedBB2 = indexedCuboid6.toAABB();
                if (!axisAlignedBB.func_72326_a(axisAlignedBB2)) continue;
                list.add(axisAlignedBB2);
            }
        } else {
            super.func_149743_a(world, n, n2, n3, axisAlignedBB, list, entity);
        }
    }

    public MovingObjectPosition func_149731_a(World world, int n, int n2, int n3, Vec3 vec3, Vec3 vec32) {
        MovingObjectPosition movingObjectPosition = this.collisionRayTrace((IBlockAccess)world, n, n2, n3, vec3, vec32);
        return movingObjectPosition;
    }

    public MovingObjectPosition collisionRayTrace(IBlockAccess iBlockAccess, int n, int n2, int n3, Vec3 vec3, Vec3 vec32) {
        TileEntity tileEntity = iBlockAccess.func_147438_o(n, n2, n3);
        if (tileEntity instanceof ITraceable) {
            LinkedList<IndexedCuboid6> linkedList = new LinkedList<IndexedCuboid6>();
            ((ITraceable)tileEntity).addTraceableCuboids(linkedList, true, this.draw.get() == Boolean.TRUE);
            return RayTracer.instance().rayTraceCuboids(new Vector3(vec3), new Vector3(vec32), linkedList, new BlockCoord(n, n2, n3), (Block)this);
        }
        if (iBlockAccess instanceof World) {
            return super.func_149731_a((World)iBlockAccess, n, n2, n3, vec3, vec32);
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onBlockHighlight(DrawBlockHighlightEvent drawBlockHighlightEvent) {
        MovingObjectPosition movingObjectPosition = drawBlockHighlightEvent.target;
        int n = movingObjectPosition.field_72311_b;
        int n2 = movingObjectPosition.field_72312_c;
        int n3 = movingObjectPosition.field_72309_d;
        if (movingObjectPosition.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) {
            return;
        }
        EntityPlayer entityPlayer = drawBlockHighlightEvent.player;
        World world = entityPlayer.field_70170_p;
        TileEntity tileEntity = BlockFactory.getTile(world, n, n2, n3);
        if (tileEntity instanceof ITraceable) {
            ICustomHitBox iCustomHitBox;
            MovingObjectPosition movingObjectPosition2 = RayTracer.retraceBlock((World)world, (EntityPlayer)entityPlayer, (int)n, (int)n2, (int)n3);
            if (movingObjectPosition2 == null) {
                return;
            }
            int n4 = movingObjectPosition2.subHit;
            if (tileEntity instanceof ICustomHitBox && (iCustomHitBox = (ICustomHitBox)tileEntity).shouldRenderCustomHitBox(n4, entityPlayer)) {
                drawBlockHighlightEvent.setCanceled(true);
                RenderHitbox.drawSelectionBox((EntityPlayer)entityPlayer, (MovingObjectPosition)movingObjectPosition, (float)drawBlockHighlightEvent.partialTicks, (CustomHitBox)iCustomHitBox.getCustomHitBox(n4, entityPlayer));
                return;
            }
            if (((ITraceable)tileEntity).isLargePart(entityPlayer, n4)) {
                this.draw.set(Boolean.TRUE);
                RayTracer.retraceBlock((World)world, (EntityPlayer)entityPlayer, (int)n, (int)n2, (int)n3);
                this.draw.set(null);
            }
        }
    }

    public int func_149709_b(IBlockAccess iBlockAccess, int n, int n2, int n3, int n4) {
        return 0;
    }

    public int func_149748_c(IBlockAccess iBlockAccess, int n, int n2, int n3, int n4) {
        return this.func_149709_b(iBlockAccess, n, n2, n3, n4);
    }

    public boolean isSideSolid(IBlockAccess iBlockAccess, int n, int n2, int n3, ForgeDirection forgeDirection) {
        return true;
    }

    public boolean func_149721_r() {
        return !this.providesPower;
    }

    public boolean func_149744_f() {
        return this.providesPower;
    }

    public int func_149692_a(int n) {
        return n;
    }

    public TileEntity func_149915_a(World world, int n) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iIconRegister) {
        this.field_149761_L = iIconRegister.func_94245_a("minefactoryreloaded:" + this.func_149739_a());
    }

    @Override
    public RedNetConnectionType getConnectionType(World world, int n, int n2, int n3, ForgeDirection forgeDirection) {
        if (this.providesPower) {
            return RedNetConnectionType.DecorativeSingle;
        }
        return RedNetConnectionType.ForcedDecorativeSingle;
    }
}

