/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.block.transport;

import cofh.api.block.IBlockInfo;
import cofh.repack.codechicken.lib.raytracer.RayTracer;
import cofh.repack.codechicken.lib.vec.Cuboid6;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import powercrystals.minefactoryreloaded.MineFactoryReloadedCore;
import powercrystals.minefactoryreloaded.api.rednet.IRedNetInfo;
import powercrystals.minefactoryreloaded.api.rednet.IRedNetNetworkContainer;
import powercrystals.minefactoryreloaded.api.rednet.connectivity.RedNetConnectionType;
import powercrystals.minefactoryreloaded.block.BlockFactory;
import powercrystals.minefactoryreloaded.core.MFRUtil;
import powercrystals.minefactoryreloaded.item.tool.ItemRedNetMeter;
import powercrystals.minefactoryreloaded.render.block.RedNetCableRenderer;
import powercrystals.minefactoryreloaded.setup.MFRConfig;
import powercrystals.minefactoryreloaded.tile.rednet.RedstoneNetwork;
import powercrystals.minefactoryreloaded.tile.rednet.TileEntityRedNetCable;
import powercrystals.minefactoryreloaded.tile.rednet.TileEntityRedNetEnergy;

public class BlockRedNetCable
extends BlockFactory
implements IRedNetNetworkContainer,
IBlockInfo,
IRedNetInfo {
    public static final String[] _names = new String[]{null, "glass", "energy", "energyglass"};
    private static float _wireSize = 0.25f;
    private static float _cageSize = 0.375f;
    private static float _gripWidth = 0.5f;
    private static float _plateWidth = 0.875f;
    private static float _plateDepth = 0.125f;
    private static float _bandWidth = 0.3125f;
    private static float _bandOffset = 0.125f;
    private static float _bandDepth = 0.0625f;
    private static float _wireStart = 0.5f - _wireSize / 2.0f;
    private static float _wireEnd = 0.5f + _wireSize / 2.0f;
    private static float _cageStart = 0.5f - _cageSize / 2.0f;
    private static float _cageEnd = 0.5f + _cageSize / 2.0f;
    private static float _gripStart = 0.5f - _gripWidth / 2.0f;
    private static float _gripEnd = 0.5f + _gripWidth / 2.0f;
    private static float _plateStart = 0.5f - _plateWidth / 2.0f;
    private static float _plateEnd = 0.5f + _plateWidth / 2.0f;
    private static float _bandWidthStart = 0.5f - _bandWidth / 2.0f;
    private static float _bandWidthEnd = 0.5f + _bandWidth / 2.0f;
    private static float _bandDepthStart = _bandOffset;
    private static float _bandDepthEnd = _bandOffset + _bandDepth;
    static int[] _subSideMappings = new int[]{6, 6, 0, 1, 2, 3, 4, 5, 0, 1, 2, 3, 4, 5, 0, 1, 2, 3, 4, 5, 0, 1, 2, 3, 4, 5, 0, 1, 2, 3, 4, 5, 0, 1, 2, 3, 4, 5};
    public static Cuboid6[] subSelection = new Cuboid6[38];

    public BlockRedNetCable() {
        super(0.8f);
        this.func_149663_c("mfr.cable.redstone");
        this.providesPower = true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean activated(World world, int n, int n2, int n3, EntityPlayer entityPlayer, int n4) {
        TileEntity tileEntity = world.func_147438_o(n, n2, n3);
        if (!(tileEntity instanceof TileEntityRedNetCable)) return false;
        TileEntityRedNetCable tileEntityRedNetCable = (TileEntityRedNetCable)tileEntity;
        MovingObjectPosition movingObjectPosition = this.func_149731_a(world, n, n2, n3, RayTracer.getStartVec((EntityPlayer)entityPlayer), RayTracer.getEndVec((EntityPlayer)entityPlayer));
        if (movingObjectPosition == null) {
            return false;
        }
        int n5 = movingObjectPosition.subHit;
        if (n5 < 0) {
            MineFactoryReloadedCore.instance().getLogger().error("subHit was " + n5, new Throwable());
            return false;
        }
        n4 = _subSideMappings[n5];
        ItemStack itemStack = entityPlayer.field_71071_by.func_70448_g();
        if (tileEntityRedNetCable.onPartHit(entityPlayer, n4, n5)) {
            return false;
        }
        if (n5 >= 14 && n5 < 20) {
            int n6;
            if (!MFRUtil.isHoldingUsableTool(entityPlayer, n, n2, n3)) {
                if (itemStack == null) return false;
                if (!itemStack.func_77973_b().equals(Items.field_151100_aR)) return false;
                if (world.field_72995_K) return false;
                tileEntityRedNetCable.setSideColor(ForgeDirection.getOrientation((int)n4), 15 - itemStack.func_77960_j());
                return true;
            }
            if (world.field_72995_K) return false;
            if (!entityPlayer.func_70093_af()) {
                n6 = tileEntityRedNetCable.getSideColor(ForgeDirection.getOrientation((int)n4)) + 1;
                if (n6 > 15) {
                    n6 = 0;
                }
            } else {
                n6 = tileEntityRedNetCable.getSideColor(ForgeDirection.getOrientation((int)n4)) - 1;
                if (n6 < 0) {
                    n6 = 15;
                }
            }
            tileEntityRedNetCable.setSideColor(ForgeDirection.getOrientation((int)n4), n6);
            return true;
        }
        if (n5 < 0) return false;
        if (n5 >= 14) return false;
        if (!MFRUtil.isHoldingUsableTool(entityPlayer, n, n2, n3)) {
            if (itemStack == null) return false;
            if (!itemStack.func_77973_b().equals(Items.field_151100_aR)) return false;
            if (world.field_72995_K) return false;
            tileEntityRedNetCable.setSideColor(ForgeDirection.getOrientation((int)n4), 15 - itemStack.func_77960_j());
            world.func_147471_g(n, n2, n3);
            return true;
        }
        byte by = tileEntityRedNetCable.getMode(n4);
        by = (byte)(by + 1);
        if (!world.field_72995_K) {
            if (n4 == 6) {
                if (by > 1) {
                    by = 0;
                }
                tileEntityRedNetCable.setMode(n4, by);
                switch (by) {
                    case 0: {
                        entityPlayer.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.info.mfr.rednet.tile.standard", new Object[0]));
                        return false;
                    }
                    case 1: {
                        entityPlayer.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.info.mfr.rednet.tile.cableonly", new Object[0]));
                        return false;
                    }
                }
                return false;
            }
            if (by > 3) {
                by = 0;
            }
            tileEntityRedNetCable.setMode(n4, by);
            switch (by) {
                case 0: {
                    entityPlayer.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.info.mfr.rednet.connection.standard", new Object[0]));
                    break;
                }
                case 1: {
                    entityPlayer.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.info.mfr.rednet.connection.forced", new Object[0]));
                    break;
                }
                case 2: {
                    entityPlayer.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.info.mfr.rednet.connection.forcedstrong", new Object[0]));
                    break;
                }
                case 3: {
                    entityPlayer.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.info.mfr.rednet.connection.cableonly", new Object[0]));
                    break;
                }
            }
        }
        MFRUtil.usedWrench(entityPlayer, n, n2, n3);
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public void func_149714_e(World world, int n, int n2, int n3, int n4) {
        TileEntity tileEntity;
        if (MFRConfig.defaultRedNetCableOnly.getBoolean(false) && (tileEntity = world.func_147438_o(n, n2, n3)) instanceof TileEntityRedNetCable) {
            TileEntityRedNetCable tileEntityRedNetCable = (TileEntityRedNetCable)tileEntity;
            tileEntityRedNetCable.setMode(6, (byte)1);
        }
    }

    public void func_149749_a(World world, int n, int n2, int n3, Block block, int n4) {
        super.func_149749_a(world, n, n2, n3, block, n4);
        MFRUtil.wideNotifyNearbyBlocksExcept(world, n, n2, n3, block);
    }

    @Override
    public boolean canDismantle(EntityPlayer entityPlayer, World world, int n, int n2, int n3) {
        MovingObjectPosition movingObjectPosition = this.func_149731_a(world, n, n2, n3, RayTracer.getStartVec((EntityPlayer)entityPlayer), RayTracer.getEndVec((EntityPlayer)entityPlayer));
        if (movingObjectPosition == null) {
            return false;
        }
        int n4 = movingObjectPosition.subHit;
        return n4 < 14 | n4 > 20;
    }

    @Override
    public int func_149709_b(IBlockAccess iBlockAccess, int n, int n2, int n3, int n4) {
        int n5 = 0;
        TileEntity tileEntity = iBlockAccess.func_147438_o(n, n2, n3);
        if (tileEntity instanceof TileEntityRedNetCable) {
            n5 = ((TileEntityRedNetCable)tileEntity).getWeakPower(ForgeDirection.getOrientation((int)n4).getOpposite());
        }
        return n5;
    }

    @Override
    public int func_149748_c(IBlockAccess iBlockAccess, int n, int n2, int n3, int n4) {
        int n5 = 0;
        TileEntity tileEntity = iBlockAccess.func_147438_o(n, n2, n3);
        if (tileEntity instanceof TileEntityRedNetCable) {
            n5 = ((TileEntityRedNetCable)tileEntity).getStrongPower(ForgeDirection.getOrientation((int)n4).getOpposite());
        }
        return n5;
    }

    @Override
    public boolean isSideSolid(IBlockAccess iBlockAccess, int n, int n2, int n3, ForgeDirection forgeDirection) {
        TileEntity tileEntity = iBlockAccess.func_147438_o(n, n2, n3);
        if (tileEntity instanceof TileEntityRedNetCable) {
            return ((TileEntityRedNetCable)tileEntity).isSolidOnSide(forgeDirection.ordinal());
        }
        return false;
    }

    @Override
    public TileEntity func_149915_a(World world, int n) {
        switch (n) {
            default: {
                return new TileEntityRedNetCable();
            }
            case 2: 
        }
        return new TileEntityRedNetEnergy();
    }

    public int func_149645_b() {
        return MineFactoryReloadedCore.renderIdRedNet;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iIconRegister) {
        this.field_149761_L = iIconRegister.func_94245_a("minefactoryreloaded:" + this.func_149739_a());
        RedNetCableRenderer.updateUVT(this.field_149761_L);
    }

    @Override
    public void updateNetwork(World world, int n, int n2, int n3, ForgeDirection forgeDirection) {
        TileEntity tileEntity = world.func_147438_o(n, n2, n3);
        if (tileEntity instanceof TileEntityRedNetCable) {
            ((TileEntityRedNetCable)tileEntity).updateNearbyNode(forgeDirection);
        }
    }

    @Override
    public void updateNetwork(World world, int n, int n2, int n3, int n4, ForgeDirection forgeDirection) {
        TileEntity tileEntity = world.func_147438_o(n, n2, n3);
        if (tileEntity instanceof TileEntityRedNetCable) {
            ((TileEntityRedNetCable)tileEntity).updateNearbyNode(n4, forgeDirection);
        }
    }

    @Override
    public RedNetConnectionType getConnectionType(World world, int n, int n2, int n3, ForgeDirection forgeDirection) {
        return RedNetConnectionType.CableAll;
    }

    @Override
    public void getBlockInfo(IBlockAccess iBlockAccess, int n, int n2, int n3, ForgeDirection forgeDirection, EntityPlayer entityPlayer, List<IChatComponent> list, boolean bl) {
        TileEntity tileEntity = iBlockAccess.func_147438_o(n, n2, n3);
        if (tileEntity instanceof TileEntityRedNetCable) {
            MovingObjectPosition movingObjectPosition = this.collisionRayTrace(iBlockAccess, n, n2, n3, RayTracer.getStartVec((EntityPlayer)entityPlayer), RayTracer.getEndVec((EntityPlayer)entityPlayer));
            if (movingObjectPosition == null) {
                return;
            }
            int n4 = movingObjectPosition.subHit;
            forgeDirection = ForgeDirection.getOrientation((int)_subSideMappings[n4]);
            ((TileEntityRedNetCable)tileEntity).getTileInfo(list, forgeDirection, entityPlayer, bl);
        }
    }

    @Override
    public void getRedNetInfo(IBlockAccess iBlockAccess, int n, int n2, int n3, ForgeDirection forgeDirection, EntityPlayer entityPlayer, List<IChatComponent> list) {
        TileEntity tileEntity = iBlockAccess.func_147438_o(n, n2, n3);
        if (tileEntity instanceof TileEntityRedNetCable) {
            MovingObjectPosition movingObjectPosition = this.collisionRayTrace(iBlockAccess, n, n2, n3, RayTracer.getStartVec((EntityPlayer)entityPlayer), RayTracer.getEndVec((EntityPlayer)entityPlayer));
            if (movingObjectPosition == null) {
                return;
            }
            int n4 = movingObjectPosition.subHit;
            forgeDirection = ForgeDirection.getOrientation((int)_subSideMappings[n4]);
            list.add((IChatComponent)new ChatComponentText(((TileEntityRedNetCable)tileEntity).getRedNetInfo(forgeDirection, entityPlayer)));
            int n5 = 0;
            RedstoneNetwork redstoneNetwork = ((TileEntityRedNetCable)tileEntity).getNetwork();
            for (int i = 0; i < 16; ++i) {
                int n6 = redstoneNetwork.getPowerLevelOutput(i);
                if (n6 == 0) continue;
                list.add(new ChatComponentText(ItemRedNetMeter._colorNames[i]).func_150258_a(": " + n6));
                ++n5;
            }
            if (n5 == 0) {
                list.add((IChatComponent)new ChatComponentTranslation("chat.info.mfr.rednet.meter.cable.allzero", new Object[0]));
            } else if (n5 < 16) {
                list.add((IChatComponent)new ChatComponentTranslation("chat.info.mfr.rednet.meter.cable.restzero", new Object[0]));
            }
        }
    }

    static {
        int n = 0;
        BlockRedNetCable.subSelection[n++] = new Cuboid6((double)_wireStart, (double)_wireStart, (double)_wireStart, (double)_wireEnd, (double)_wireEnd, (double)_wireEnd);
        BlockRedNetCable.subSelection[n++] = new Cuboid6((double)_cageStart, (double)_cageStart, (double)_cageStart, (double)_cageEnd, (double)_cageEnd, (double)_cageEnd);
        BlockRedNetCable.subSelection[n++] = new Cuboid6((double)_gripStart, 0.0, (double)_gripStart, (double)_gripEnd, (double)_plateDepth, (double)_gripEnd);
        BlockRedNetCable.subSelection[n++] = new Cuboid6((double)_gripStart, (double)(1.0f - _plateDepth), (double)_gripStart, (double)_gripEnd, 1.0, (double)_gripEnd);
        BlockRedNetCable.subSelection[n++] = new Cuboid6((double)_gripStart, (double)_gripStart, 0.0, (double)_gripEnd, (double)_gripEnd, (double)_plateDepth);
        BlockRedNetCable.subSelection[n++] = new Cuboid6((double)_gripStart, (double)_gripStart, (double)(1.0f - _plateDepth), (double)_gripEnd, (double)_gripEnd, 1.0);
        BlockRedNetCable.subSelection[n++] = new Cuboid6(0.0, (double)_gripStart, (double)_gripStart, (double)_plateDepth, (double)_gripEnd, (double)_gripEnd);
        BlockRedNetCable.subSelection[n++] = new Cuboid6((double)(1.0f - _plateDepth), (double)_gripStart, (double)_gripStart, 1.0, (double)_gripEnd, (double)_gripEnd);
        BlockRedNetCable.subSelection[n++] = new Cuboid6((double)_plateStart, 0.0, (double)_plateStart, (double)_plateEnd, (double)_plateDepth, (double)_plateEnd);
        BlockRedNetCable.subSelection[n++] = new Cuboid6((double)_plateStart, (double)(1.0f - _plateDepth), (double)_plateStart, (double)_plateEnd, 1.0, (double)_plateEnd);
        BlockRedNetCable.subSelection[n++] = new Cuboid6((double)_plateStart, (double)_plateStart, 0.0, (double)_plateEnd, (double)_plateEnd, (double)_plateDepth);
        BlockRedNetCable.subSelection[n++] = new Cuboid6((double)_plateStart, (double)_plateStart, (double)(1.0f - _plateDepth), (double)_plateEnd, (double)_plateEnd, 1.0);
        BlockRedNetCable.subSelection[n++] = new Cuboid6(0.0, (double)_plateStart, (double)_plateStart, (double)_plateDepth, (double)_plateEnd, (double)_plateEnd);
        BlockRedNetCable.subSelection[n++] = new Cuboid6((double)(1.0f - _plateDepth), (double)_plateStart, (double)_plateStart, 1.0, (double)_plateEnd, (double)_plateEnd);
        BlockRedNetCable.subSelection[n++] = new Cuboid6((double)_bandWidthStart, (double)_bandDepthStart, (double)_bandWidthStart, (double)_bandWidthEnd, (double)_bandDepthEnd, (double)_bandWidthEnd);
        BlockRedNetCable.subSelection[n++] = new Cuboid6((double)_bandWidthStart, (double)(1.0f - _bandDepthEnd), (double)_bandWidthStart, (double)_bandWidthEnd, (double)(1.0f - _bandDepthStart), (double)_bandWidthEnd);
        BlockRedNetCable.subSelection[n++] = new Cuboid6((double)_bandWidthStart, (double)_bandWidthStart, (double)_bandDepthStart, (double)_bandWidthEnd, (double)_bandWidthEnd, (double)_bandDepthEnd);
        BlockRedNetCable.subSelection[n++] = new Cuboid6((double)_bandWidthStart, (double)_bandWidthStart, (double)(1.0f - _bandDepthEnd), (double)_bandWidthEnd, (double)_bandWidthEnd, (double)(1.0f - _bandDepthStart));
        BlockRedNetCable.subSelection[n++] = new Cuboid6((double)_bandDepthStart, (double)_bandWidthStart, (double)_bandWidthStart, (double)_bandDepthEnd, (double)_bandWidthEnd, (double)_bandWidthEnd);
        BlockRedNetCable.subSelection[n++] = new Cuboid6((double)(1.0f - _bandDepthEnd), (double)_bandWidthStart, (double)_bandWidthStart, (double)(1.0f - _bandDepthStart), (double)_bandWidthEnd, (double)_bandWidthEnd);
        BlockRedNetCable.subSelection[n++] = new Cuboid6((double)_wireStart, (double)_plateDepth, (double)_wireStart, (double)_wireEnd, (double)_wireStart, (double)_wireEnd);
        BlockRedNetCable.subSelection[n++] = new Cuboid6((double)_wireStart, (double)_wireEnd, (double)_wireStart, (double)_wireEnd, (double)(1.0f - _plateDepth), (double)_wireEnd);
        BlockRedNetCable.subSelection[n++] = new Cuboid6((double)_wireStart, (double)_wireStart, (double)_plateDepth, (double)_wireEnd, (double)_wireEnd, (double)_wireStart);
        BlockRedNetCable.subSelection[n++] = new Cuboid6((double)_wireStart, (double)_wireStart, (double)_wireEnd, (double)_wireEnd, (double)_wireEnd, (double)(1.0f - _plateDepth));
        BlockRedNetCable.subSelection[n++] = new Cuboid6((double)_plateDepth, (double)_wireStart, (double)_wireStart, (double)_wireStart, (double)_wireEnd, (double)_wireEnd);
        BlockRedNetCable.subSelection[n++] = new Cuboid6((double)_wireEnd, (double)_wireStart, (double)_wireStart, (double)(1.0f - _plateDepth), (double)_wireEnd, (double)_wireEnd);
        BlockRedNetCable.subSelection[n++] = new Cuboid6((double)_cageStart, (double)_bandDepthEnd, (double)_cageStart, (double)_cageEnd, (double)_cageStart, (double)_cageEnd);
        BlockRedNetCable.subSelection[n++] = new Cuboid6((double)_cageStart, (double)_cageEnd, (double)_cageStart, (double)_cageEnd, (double)(1.0f - _bandDepthEnd), (double)_cageEnd);
        BlockRedNetCable.subSelection[n++] = new Cuboid6((double)_cageStart, (double)_cageStart, (double)_bandDepthEnd, (double)_cageEnd, (double)_cageEnd, (double)_cageStart);
        BlockRedNetCable.subSelection[n++] = new Cuboid6((double)_cageStart, (double)_cageStart, (double)_cageEnd, (double)_cageEnd, (double)_cageEnd, (double)(1.0f - _bandDepthEnd));
        BlockRedNetCable.subSelection[n++] = new Cuboid6((double)_bandDepthEnd, (double)_cageStart, (double)_cageStart, (double)_cageStart, (double)_cageEnd, (double)_cageEnd);
        BlockRedNetCable.subSelection[n++] = new Cuboid6((double)_cageEnd, (double)_cageStart, (double)_cageStart, (double)(1.0f - _bandDepthEnd), (double)_cageEnd, (double)_cageEnd);
        BlockRedNetCable.subSelection[n++] = new Cuboid6((double)_cageStart, (double)_plateDepth, (double)_cageStart, (double)_cageEnd, (double)_cageStart, (double)_cageEnd);
        BlockRedNetCable.subSelection[n++] = new Cuboid6((double)_cageStart, (double)_cageEnd, (double)_cageStart, (double)_cageEnd, (double)(1.0f - _plateDepth), (double)_cageEnd);
        BlockRedNetCable.subSelection[n++] = new Cuboid6((double)_cageStart, (double)_cageStart, (double)_plateDepth, (double)_cageEnd, (double)_cageEnd, (double)_cageStart);
        BlockRedNetCable.subSelection[n++] = new Cuboid6((double)_cageStart, (double)_cageStart, (double)_cageEnd, (double)_cageEnd, (double)_cageEnd, (double)(1.0f - _plateDepth));
        BlockRedNetCable.subSelection[n++] = new Cuboid6((double)_plateDepth, (double)_cageStart, (double)_cageStart, (double)_cageStart, (double)_cageEnd, (double)_cageEnd);
        BlockRedNetCable.subSelection[n++] = new Cuboid6((double)_cageEnd, (double)_cageStart, (double)_cageStart, (double)(1.0f - _plateDepth), (double)_cageEnd, (double)_cageEnd);
    }
}

