/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.solids;

import appeng.api.util.IOrientable;
import appeng.api.util.IOrientableBlock;
import appeng.block.AEBaseBlock;
import appeng.core.AppEng;
import appeng.core.WorldSettings;
import appeng.core.features.AEFeature;
import appeng.helpers.LocationRotation;
import appeng.helpers.NullRotation;
import appeng.integration.IntegrationType;
import appeng.integration.abstraction.IRB;
import appeng.util.Platform;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import rblocks.api.RotatableBlockEnable;

@RotatableBlockEnable
public class BlockSkyStone
extends AEBaseBlock
implements IOrientableBlock {
    @SideOnly(value=Side.CLIENT)
    IIcon Block;
    @SideOnly(value=Side.CLIENT)
    IIcon Brick;
    @SideOnly(value=Side.CLIENT)
    IIcon SmallBrick;

    public BlockSkyStone() {
        super(BlockSkyStone.class, Material.rock);
        this.setHardness(50.0f);
        this.hasSubtypes = true;
        this.blockResistance = 150.0f;
        this.setHarvestLevel("pickaxe", 3, 0);
        this.setFeature(EnumSet.of(AEFeature.Core));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void breakFaster(PlayerEvent.BreakSpeed Ev) {
        if (Ev.block == this && Ev.entityPlayer != null) {
            ItemStack is = Ev.entityPlayer.inventory.getCurrentItem();
            int level = -1;
            if (is != null) {
                level = is.getItem().getHarvestLevel(is, "pickaxe");
            }
            if (Ev.metadata > 0 || level >= 3 || (double)Ev.originalSpeed > 7.0) {
                Ev.newSpeed = (float)((double)Ev.newSpeed / 0.1);
            }
        }
    }

    public int damageDropped(int meta) {
        return meta;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z, EntityPlayer player) {
        ItemStack is = super.getPickBlock(target, world, x, y, z, player);
        is.setItemDamage(world.getBlockMetadata(x, y, z));
        return is;
    }

    public void onBlockAdded(World w, int x, int y, int z) {
        super.onBlockAdded(w, x, y, z);
        if (Platform.isServer()) {
            WorldSettings.getInstance().getCompass().updateArea(w, x, y, z);
        }
    }

    int getRealRenderType() {
        return this.getRenderType();
    }

    @Override
    public boolean usesMetadata() {
        return false;
    }

    @Override
    public IOrientable getOrientable(IBlockAccess w, int x, int y, int z) {
        IOrientable out;
        TileEntity te;
        if (AppEng.instance.isIntegrationEnabled(IntegrationType.RB) && (te = w.getTileEntity(x, y, z)) != null && (out = ((IRB)AppEng.instance.getIntegration(IntegrationType.RB)).getOrientable(te)) != null) {
            return out;
        }
        if (w.getBlockMetadata(x, y, z) == 0) {
            return new LocationRotation(w, x, y, z);
        }
        return new NullRotation();
    }

    @Override
    public String getUnlocalizedName(ItemStack is) {
        if (is.getItemDamage() == 1) {
            return this.getUnlocalizedName() + ".Block";
        }
        if (is.getItemDamage() == 2) {
            return this.getUnlocalizedName() + ".Brick";
        }
        if (is.getItemDamage() == 3) {
            return this.getUnlocalizedName() + ".SmallBrick";
        }
        return this.getUnlocalizedName();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister ir) {
        super.registerBlockIcons(ir);
        this.Block = ir.registerIcon(this.getTextureName() + ".Block");
        this.Brick = ir.registerIcon(this.getTextureName() + ".Brick");
        this.SmallBrick = ir.registerIcon(this.getTextureName() + ".SmallBrick");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int direction, int metadata) {
        if (metadata == 1) {
            return this.Block;
        }
        if (metadata == 2) {
            return this.Brick;
        }
        if (metadata == 3) {
            return this.SmallBrick;
        }
        return super.getIcon(direction, metadata);
    }

    @Override
    public void setRenderStateByMeta(int metadata) {
        this.getRendererInstance().setTemporaryRenderIcon(this.getIcon(0, metadata));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getCheckedSubBlocks(Item item, CreativeTabs tabs, List<ItemStack> itemStacks) {
        super.getCheckedSubBlocks(item, tabs, itemStacks);
        itemStacks.add(new ItemStack(item, 1, 1));
        itemStacks.add(new ItemStack(item, 1, 2));
        itemStacks.add(new ItemStack(item, 1, 3));
    }

    @Override
    public void breakBlock(World w, int x, int y, int z, Block b, int WTF) {
        super.breakBlock(w, x, y, z, b, WTF);
        if (Platform.isServer()) {
            WorldSettings.getInstance().getCompass().updateArea(w, x, y, z);
        }
    }
}

