/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.api.AEApi;
import appeng.client.gui.AEBaseGui;
import appeng.client.gui.widgets.GuiScrollbar;
import appeng.client.gui.widgets.MEGuiTextField;
import appeng.client.me.ClientDCInternalInv;
import appeng.client.me.SlotDisconnected;
import appeng.container.implementations.ContainerInterfaceTerminal;
import appeng.core.localization.GuiText;
import appeng.parts.reporting.PartMonitor;
import appeng.util.Platform;
import com.google.common.collect.HashMultimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import org.lwjgl.opengl.GL11;

public class GuiInterfaceTerminal
extends AEBaseGui {
    private static final int LINES_ON_PAGE = 6;
    final int offsetX = 9;
    private final HashMap<Long, ClientDCInternalInv> byId = new HashMap();
    private final HashMultimap<String, ClientDCInternalInv> byName = HashMultimap.create();
    private final ArrayList<String> names = new ArrayList();
    private final ArrayList<Object> lines = new ArrayList();
    private final Map<String, Set<Object>> cachedSearches = new WeakHashMap<String, Set<Object>>();
    private boolean refreshList = false;
    private MEGuiTextField searchField;

    public GuiInterfaceTerminal(InventoryPlayer inventoryPlayer, PartMonitor te) {
        super(new ContainerInterfaceTerminal(inventoryPlayer, te));
        this.myScrollBar = new GuiScrollbar();
        this.xSize = 195;
        this.ySize = 222;
    }

    @Override
    public void initGui() {
        super.initGui();
        this.myScrollBar.setLeft(175);
        this.myScrollBar.setHeight(106);
        this.myScrollBar.setTop(18);
        this.searchField = new MEGuiTextField(this.fontRendererObj, this.guiLeft + Math.max(104, this.offsetX), this.guiTop + 4, 65, 12);
        this.searchField.setEnableBackgroundDrawing(false);
        this.searchField.setMaxStringLength(25);
        this.searchField.setTextColor(0xFFFFFF);
        this.searchField.setVisible(true);
        this.searchField.setFocused(true);
    }

    @Override
    public void drawFG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.fontRendererObj.drawString(this.getGuiDisplayName(GuiText.InterfaceTerminal.getLocal()), 8, 6, 0x404040);
        this.fontRendererObj.drawString(GuiText.inventory.getLocal(), 8, this.ySize - 96 + 3, 0x404040);
        int offset = 17;
        int ex = this.myScrollBar.getCurrentScroll();
        Iterator o = this.inventorySlots.inventorySlots.iterator();
        while (o.hasNext()) {
            if (!(o.next() instanceof SlotDisconnected)) continue;
            o.remove();
        }
        for (int x = 0; x < 6 && ex + x < this.lines.size(); ++x) {
            Object lineObj = this.lines.get(ex + x);
            if (lineObj instanceof ClientDCInternalInv) {
                ClientDCInternalInv inv = (ClientDCInternalInv)lineObj;
                for (int z = 0; z < inv.inv.getSizeInventory(); ++z) {
                    this.inventorySlots.inventorySlots.add(new SlotDisconnected(inv, z, z * 18 + 8, 1 + offset));
                }
            } else if (lineObj instanceof String) {
                String name = (String)lineObj;
                int rows = this.byName.get((Object)name).size();
                if (rows > 1) {
                    name = name + " (" + rows + ')';
                }
                while (name.length() > 2 && this.fontRendererObj.getStringWidth(name) > 155) {
                    name = name.substring(0, name.length() - 1);
                }
                this.fontRendererObj.drawString(name, 10, 6 + offset, 0x404040);
            }
            offset += 18;
        }
    }

    @Override
    protected void mouseClicked(int xCoord, int yCoord, int btn) {
        this.searchField.mouseClicked(xCoord, yCoord, btn);
        if (btn == 1 && this.searchField.isMouseIn(xCoord, yCoord)) {
            this.searchField.setText("");
            this.refreshList();
        }
        super.mouseClicked(xCoord, yCoord, btn);
    }

    @Override
    public void drawBG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.bindTexture("guis/interfaceterminal.png");
        this.drawTexturedModalRect(offsetX, offsetY, 0, 0, this.xSize, this.ySize);
        int offset = 17;
        int ex = this.myScrollBar.getCurrentScroll();
        for (int x = 0; x < 6 && ex + x < this.lines.size(); ++x) {
            Object lineObj = this.lines.get(ex + x);
            if (lineObj instanceof ClientDCInternalInv) {
                ClientDCInternalInv inv = (ClientDCInternalInv)lineObj;
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                int width = inv.inv.getSizeInventory() * 18;
                this.drawTexturedModalRect(offsetX + 7, offsetY + offset, 7, 139, width, 18);
            }
            offset += 18;
        }
        if (this.searchField != null) {
            this.searchField.drawTextBox();
        }
    }

    protected void keyTyped(char character, int key) {
        if (!this.checkHotbarKeys(key)) {
            if (character == ' ' && this.searchField.getText().length() == 0) {
                return;
            }
            if (this.searchField.textboxKeyTyped(character, key)) {
                this.refreshList();
            } else {
                super.keyTyped(character, key);
            }
        }
    }

    public void postUpdate(NBTTagCompound in) {
        if (in.getBoolean("clear")) {
            this.byId.clear();
            this.refreshList = true;
        }
        for (Object oKey : in.func_150296_c()) {
            String key = (String)oKey;
            if (!key.startsWith("=")) continue;
            try {
                long id = Long.parseLong(key.substring(1), 36);
                NBTTagCompound invData = in.getCompoundTag(key);
                ClientDCInternalInv current = this.getById(id, invData.getLong("sortBy"), invData.getString("un"));
                for (int x = 0; x < current.inv.getSizeInventory(); ++x) {
                    String which = Integer.toString(x);
                    if (!invData.hasKey(which)) continue;
                    current.inv.setInventorySlotContents(x, ItemStack.loadItemStackFromNBT((NBTTagCompound)invData.getCompoundTag(which)));
                }
            }
            catch (NumberFormatException ignored) {
            }
        }
        if (this.refreshList) {
            this.refreshList = false;
            this.cachedSearches.clear();
            this.refreshList();
        }
    }

    private void refreshList() {
        this.byName.clear();
        String searchFilterLowerCase = this.searchField.getText().toLowerCase();
        Set<Object> cachedSearch = this.getCacheForSearchTerm(searchFilterLowerCase);
        boolean rebuild = cachedSearch.isEmpty();
        for (ClientDCInternalInv entry : this.byId.values()) {
            if (!rebuild && !cachedSearch.contains(entry)) continue;
            boolean found = searchFilterLowerCase.isEmpty();
            if (!found && !searchFilterLowerCase.isEmpty()) {
                ItemStack itemStack;
                Iterator<ItemStack> i$ = entry.inv.iterator();
                while (i$.hasNext() && !(found = this.itemStackMatchesSearchTerm(itemStack = i$.next(), searchFilterLowerCase))) {
                }
            }
            if (found || entry.getName().toLowerCase().contains(searchFilterLowerCase)) {
                this.byName.put((Object)entry.getName(), (Object)entry);
                cachedSearch.add(entry);
                continue;
            }
            cachedSearch.remove(entry);
        }
        this.names.clear();
        this.names.addAll(this.byName.keySet());
        Collections.sort(this.names);
        this.lines.clear();
        this.lines.ensureCapacity(this.getMaxRows());
        for (String n : this.names) {
            this.lines.add(n);
            ArrayList clientInventories = new ArrayList();
            clientInventories.addAll(this.byName.get((Object)n));
            Collections.sort(clientInventories);
            this.lines.addAll(clientInventories);
        }
        this.myScrollBar.setRange(0, this.lines.size() - 6, 2);
    }

    private boolean itemStackMatchesSearchTerm(ItemStack itemStack, String searchTerm) {
        if (itemStack == null) {
            return false;
        }
        NBTTagCompound encodedValue = itemStack.getTagCompound();
        if (encodedValue == null) {
            return false;
        }
        NBTTagList outTag = encodedValue.getTagList("out", 10);
        for (int i = 0; i < outTag.tagCount(); ++i) {
            String displayName;
            ItemStack parsedItemStack = ItemStack.loadItemStackFromNBT((NBTTagCompound)outTag.getCompoundTagAt(i));
            if (parsedItemStack == null || !(displayName = Platform.getItemDisplayName(AEApi.instance().storage().createItemStack(parsedItemStack)).toLowerCase()).contains(searchTerm)) continue;
            return true;
        }
        return false;
    }

    private Set<Object> getCacheForSearchTerm(String searchTerm) {
        Set<Object> cache;
        if (!this.cachedSearches.containsKey(searchTerm)) {
            this.cachedSearches.put(searchTerm, new HashSet());
        }
        if ((cache = this.cachedSearches.get(searchTerm)).isEmpty() && searchTerm.length() > 1) {
            cache.addAll(this.getCacheForSearchTerm(searchTerm.substring(0, searchTerm.length() - 1)));
            return cache;
        }
        return cache;
    }

    private int getMaxRows() {
        return this.names.size() + this.byId.size();
    }

    private ClientDCInternalInv getById(long id, long sortBy, String string) {
        ClientDCInternalInv o = this.byId.get(id);
        if (o == null) {
            o = new ClientDCInternalInv(9, id, sortBy, string);
            this.byId.put(id, o);
            this.refreshList = true;
        }
        return o;
    }
}

