/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.api.config.Settings;
import appeng.client.gui.AEBaseGui;
import appeng.client.gui.widgets.GuiImgButton;
import appeng.container.implementations.ContainerSpatialIOPort;
import appeng.core.AEConfig;
import appeng.core.localization.GuiText;
import appeng.tile.spatial.TileSpatialIOPort;
import appeng.util.Platform;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import org.lwjgl.input.Mouse;

public class GuiSpatialIOPort
extends AEBaseGui {
    final ContainerSpatialIOPort container;
    GuiImgButton units;

    public GuiSpatialIOPort(InventoryPlayer inventoryPlayer, TileSpatialIOPort te) {
        super(new ContainerSpatialIOPort(inventoryPlayer, te));
        this.ySize = 199;
        this.container = (ContainerSpatialIOPort)this.inventorySlots;
    }

    protected void actionPerformed(GuiButton btn) {
        super.actionPerformed(btn);
        boolean backwards = Mouse.isButtonDown((int)1);
        if (btn == this.units) {
            AEConfig.instance.nextPowerUnit(backwards);
            this.units.set(AEConfig.instance.selectedPowerUnit());
        }
    }

    @Override
    public void initGui() {
        super.initGui();
        this.units = new GuiImgButton(this.guiLeft - 18, this.guiTop + 8, Settings.POWER_UNITS, AEConfig.instance.selectedPowerUnit());
        this.buttonList.add(this.units);
    }

    @Override
    public void drawFG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.fontRendererObj.drawString(GuiText.StoredPower.getLocal() + ": " + Platform.formatPowerLong(this.container.currentPower, false), 13, 21, 0x404040);
        this.fontRendererObj.drawString(GuiText.MaxPower.getLocal() + ": " + Platform.formatPowerLong(this.container.maxPower, false), 13, 31, 0x404040);
        this.fontRendererObj.drawString(GuiText.RequiredPower.getLocal() + ": " + Platform.formatPowerLong(this.container.reqPower, false), 13, 78, 0x404040);
        this.fontRendererObj.drawString(GuiText.Efficiency.getLocal() + ": " + (float)this.container.eff / 100.0f + '%', 13, 88, 0x404040);
        this.fontRendererObj.drawString(this.getGuiDisplayName(GuiText.SpatialIOPort.getLocal()), 8, 6, 0x404040);
        this.fontRendererObj.drawString(GuiText.inventory.getLocal(), 8, this.ySize - 96, 0x404040);
    }

    @Override
    public void drawBG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.bindTexture("guis/spatialio.png");
        this.drawTexturedModalRect(offsetX, offsetY, 0, 0, this.xSize, this.ySize);
    }
}

