/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render;

import appeng.block.AEBaseBlock;
import appeng.client.render.BaseBlockRender;
import appeng.core.AELog;
import appeng.tile.AEBaseTile;
import appeng.util.Platform;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class TESRWrapper
extends TileEntitySpecialRenderer {
    public final RenderBlocks renderBlocksInstance = new RenderBlocks();
    final BaseBlockRender blkRender;
    final double MAX_DISTANCE;

    public TESRWrapper(BaseBlockRender render) {
        this.blkRender = render;
        this.MAX_DISTANCE = this.blkRender.getTesrRenderDistance();
    }

    public final void renderTileEntityAt(TileEntity te, double x, double y, double z, float f) {
        Block b;
        if (te instanceof AEBaseTile && (b = te.getBlockType()) instanceof AEBaseBlock && ((AEBaseTile)te).requiresTESR()) {
            if (Math.abs(x) > this.MAX_DISTANCE || Math.abs(y) > this.MAX_DISTANCE || Math.abs(z) > this.MAX_DISTANCE) {
                return;
            }
            Tessellator tess = Tessellator.instance;
            if (Platform.isDrawing(tess)) {
                return;
            }
            try {
                GL11.glPushMatrix();
                GL11.glPushAttrib((int)1048575);
                this.renderBlocksInstance.blockAccess = te.getWorldObj();
                this.blkRender.renderTile((AEBaseBlock)b, (AEBaseTile)te, tess, x, y, z, f, this.renderBlocksInstance);
                if (Platform.isDrawing(tess)) {
                    throw new RuntimeException("Error during rendering.");
                }
                GL11.glPopAttrib();
                GL11.glPopMatrix();
            }
            catch (Throwable t) {
                AELog.severe("Hi, Looks like there was a crash while rendering something...", new Object[0]);
                t.printStackTrace();
                AELog.severe("MC will now crash ( probably )!", new Object[0]);
                throw new RuntimeException(t);
            }
        }
    }
}

