/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.blocks;

import appeng.block.AEBaseBlock;
import appeng.client.render.BaseBlockRender;
import appeng.client.texture.ExtraBlockTextures;
import appeng.tile.networking.TileController;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;

public class RenderBlockController
extends BaseBlockRender {
    public RenderBlockController() {
        super(false, 20.0);
    }

    @Override
    public boolean renderInWorld(AEBaseBlock blk, IBlockAccess world, int x, int y, int z, RenderBlocks renderer) {
        boolean xx = this.getTileEntity(world, x - 1, y, z) instanceof TileController && this.getTileEntity(world, x + 1, y, z) instanceof TileController;
        boolean yy = this.getTileEntity(world, x, y - 1, z) instanceof TileController && this.getTileEntity(world, x, y + 1, z) instanceof TileController;
        boolean zz = this.getTileEntity(world, x, y, z - 1) instanceof TileController && this.getTileEntity(world, x, y, z + 1) instanceof TileController;
        int meta = world.getBlockMetadata(x, y, z);
        boolean hasPower = meta > 0;
        boolean isConflict = meta == 2;
        ExtraBlockTextures lights = null;
        if (xx && !yy && !zz) {
            if (hasPower) {
                blk.getRendererInstance().setTemporaryRenderIcon(ExtraBlockTextures.BlockControllerColumnPowered.getIcon());
                lights = isConflict ? ExtraBlockTextures.BlockControllerColumnConflict : ExtraBlockTextures.BlockControllerColumnLights;
            } else {
                blk.getRendererInstance().setTemporaryRenderIcon(ExtraBlockTextures.BlockControllerColumn.getIcon());
            }
            renderer.uvRotateEast = 1;
            renderer.uvRotateWest = 1;
            renderer.uvRotateTop = 1;
            renderer.uvRotateBottom = 1;
        } else if (!xx && yy && !zz) {
            if (hasPower) {
                blk.getRendererInstance().setTemporaryRenderIcon(ExtraBlockTextures.BlockControllerColumnPowered.getIcon());
                lights = isConflict ? ExtraBlockTextures.BlockControllerColumnConflict : ExtraBlockTextures.BlockControllerColumnLights;
            } else {
                blk.getRendererInstance().setTemporaryRenderIcon(ExtraBlockTextures.BlockControllerColumn.getIcon());
            }
            renderer.uvRotateEast = 0;
            renderer.uvRotateNorth = 0;
        } else if (!xx && !yy && zz) {
            if (hasPower) {
                blk.getRendererInstance().setTemporaryRenderIcon(ExtraBlockTextures.BlockControllerColumnPowered.getIcon());
                lights = isConflict ? ExtraBlockTextures.BlockControllerColumnConflict : ExtraBlockTextures.BlockControllerColumnLights;
            } else {
                blk.getRendererInstance().setTemporaryRenderIcon(ExtraBlockTextures.BlockControllerColumn.getIcon());
            }
            renderer.uvRotateNorth = 1;
            renderer.uvRotateSouth = 1;
            renderer.uvRotateTop = 0;
        } else if ((xx ? 1 : 0) + (yy ? 1 : 0) + (zz ? 1 : 0) >= 2) {
            int v = (Math.abs(x) + Math.abs(y) + Math.abs(z)) % 2;
            renderer.uvRotateWest = 0;
            renderer.uvRotateTop = 0;
            renderer.uvRotateSouth = 0;
            renderer.uvRotateNorth = 0;
            renderer.uvRotateBottom = 0;
            renderer.uvRotateEast = 0;
            if (v == 0) {
                blk.getRendererInstance().setTemporaryRenderIcon(ExtraBlockTextures.BlockControllerInsideA.getIcon());
            } else {
                blk.getRendererInstance().setTemporaryRenderIcon(ExtraBlockTextures.BlockControllerInsideB.getIcon());
            }
        } else if (hasPower) {
            blk.getRendererInstance().setTemporaryRenderIcon(ExtraBlockTextures.BlockControllerPowered.getIcon());
            lights = isConflict ? ExtraBlockTextures.BlockControllerConflict : ExtraBlockTextures.BlockControllerLights;
        } else {
            blk.getRendererInstance().setTemporaryRenderIcon(null);
        }
        boolean out = renderer.renderStandardBlock((Block)blk, x, y, z);
        if (lights != null) {
            Tessellator.instance.setColorOpaque_F(1.0f, 1.0f, 1.0f);
            Tessellator.instance.setBrightness(0xE000E0);
            renderer.renderFaceXNeg((Block)blk, (double)x, (double)y, (double)z, lights.getIcon());
            renderer.renderFaceXPos((Block)blk, (double)x, (double)y, (double)z, lights.getIcon());
            renderer.renderFaceYNeg((Block)blk, (double)x, (double)y, (double)z, lights.getIcon());
            renderer.renderFaceYPos((Block)blk, (double)x, (double)y, (double)z, lights.getIcon());
            renderer.renderFaceZNeg((Block)blk, (double)x, (double)y, (double)z, lights.getIcon());
            renderer.renderFaceZPos((Block)blk, (double)x, (double)y, (double)z, lights.getIcon());
        }
        blk.getRendererInstance().setTemporaryRenderIcon(null);
        renderer.uvRotateWest = 0;
        renderer.uvRotateTop = 0;
        renderer.uvRotateSouth = 0;
        renderer.uvRotateNorth = 0;
        renderer.uvRotateBottom = 0;
        renderer.uvRotateEast = 0;
        return out;
    }

    private TileEntity getTileEntity(IBlockAccess world, int x, int y, int z) {
        if (y >= 0) {
            return world.getTileEntity(x, y, z);
        }
        return null;
    }
}

