/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.blocks;

import appeng.block.AEBaseBlock;
import appeng.client.render.BaseBlockRender;
import appeng.tile.AEBaseTile;
import appeng.tile.storage.TileSkyChest;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelChest;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class RenderBlockSkyChest
extends BaseBlockRender {
    final ModelChest model = new ModelChest();

    public RenderBlockSkyChest() {
        super(true, 80.0);
    }

    @Override
    public void renderInventory(AEBaseBlock blk, ItemStack is, RenderBlocks renderer, IItemRenderer.ItemRenderType type, Object[] obj) {
        GL11.glEnable((int)32826);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ResourceLocation loc = is.getItemDamage() == 1 ? new ResourceLocation("appliedenergistics2", "textures/models/skyblockchest.png") : new ResourceLocation("appliedenergistics2", "textures/models/skychest.png");
        Minecraft.getMinecraft().getTextureManager().bindTexture(loc);
        float lidAngle = 0.0f;
        GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        GL11.glTranslatef((float)-0.0f, (float)-1.0f, (float)-1.0f);
        this.model.chestLid.offsetY = -0.05625f;
        this.model.chestLid.rotateAngleX = -(lidAngle * 3.141593f / 2.0f);
        this.model.renderAll();
        GL11.glDisable((int)32826);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public boolean renderInWorld(AEBaseBlock blk, IBlockAccess world, int x, int y, int z, RenderBlocks renderer) {
        return true;
    }

    @Override
    public void renderTile(AEBaseBlock block, AEBaseTile tile, Tessellator tess, double x, double y, double z, float partialTick, RenderBlocks renderer) {
        if (!(tile instanceof TileSkyChest)) {
            return;
        }
        TileSkyChest skyChest = (TileSkyChest)tile;
        if (!skyChest.hasWorldObj()) {
            return;
        }
        GL11.glEnable((int)32826);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ResourceLocation loc = tile.getWorldObj().getBlockMetadata(tile.xCoord, tile.yCoord, tile.zCoord) == 1 ? new ResourceLocation("appliedenergistics2", "textures/models/skyblockchest.png") : new ResourceLocation("appliedenergistics2", "textures/models/skychest.png");
        Minecraft.getMinecraft().getTextureManager().bindTexture(loc);
        this.applyTESRRotation(x, y, z, skyChest.getForward(), skyChest.getUp());
        GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        GL11.glTranslatef((float)-0.0f, (float)-1.0f, (float)-1.0f);
        long now = System.currentTimeMillis();
        long distance = now - skyChest.lastEvent;
        skyChest.lidAngle = skyChest.playerOpen > 0 ? (float)((double)skyChest.lidAngle + (double)distance * 1.0E-4) : (float)((double)skyChest.lidAngle - (double)distance * 1.0E-4);
        if (skyChest.lidAngle > 0.5f) {
            skyChest.lidAngle = 0.5f;
        }
        if (skyChest.lidAngle < 0.0f) {
            skyChest.lidAngle = 0.0f;
        }
        float lidAngle = skyChest.lidAngle;
        lidAngle = 1.0f - lidAngle;
        lidAngle = 1.0f - lidAngle * lidAngle * lidAngle;
        this.model.chestLid.offsetY = -0.063125f;
        this.model.chestLid.rotateAngleX = -(lidAngle * 3.141593f / 2.0f);
        this.model.renderAll();
        GL11.glDisable((int)32826);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

