/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.effects;

import appeng.client.texture.ExtraBlockTextures;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.particle.EntityBreakingFX;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.Item;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@SideOnly(value=Side.CLIENT)
public class CraftingFx
extends EntityBreakingFX {
    private final IIcon particleTextureIndex;
    private final int startBlkX;
    private final int startBlkY;
    private final int startBlkZ;

    public CraftingFx(World par1World, double par2, double par4, double par6, Item par8Item) {
        super(par1World, par2, par4, par6, par8Item);
        this.particleGravity = 0.0f;
        this.particleBlue = 1.0f;
        this.particleGreen = 0.9f;
        this.particleRed = 1.0f;
        this.particleAlpha = 1.3f;
        this.particleScale = 1.5f;
        this.particleTextureIndex = ExtraBlockTextures.BlockEnergyParticle.getIcon();
        this.particleMaxAge = (int)((double)this.particleMaxAge / 1.2);
        this.startBlkX = MathHelper.floor_double((double)this.posX);
        this.startBlkY = MathHelper.floor_double((double)this.posY);
        this.startBlkZ = MathHelper.floor_double((double)this.posZ);
        this.noClip = true;
    }

    public int getFXLayer() {
        return 1;
    }

    public void renderParticle(Tessellator par1Tessellator, float partialTick, float x, float y, float z, float rx, float rz) {
        if (partialTick < 0.0f || partialTick > 1.0f) {
            return;
        }
        float f6 = this.particleTextureIndex.getMinU();
        float f7 = this.particleTextureIndex.getMaxU();
        float f8 = this.particleTextureIndex.getMinV();
        float f9 = this.particleTextureIndex.getMaxV();
        float scale = 0.1f * this.particleScale;
        float offX = (float)(this.prevPosX + (this.posX - this.prevPosX) * (double)partialTick);
        float offY = (float)(this.prevPosY + (this.posY - this.prevPosY) * (double)partialTick);
        float offZ = (float)(this.prevPosZ + (this.posZ - this.prevPosZ) * (double)partialTick);
        float f14 = 1.0f;
        int blkX = MathHelper.floor_double((double)offX);
        int blkY = MathHelper.floor_double((double)offY);
        int blkZ = MathHelper.floor_double((double)offZ);
        if (blkX == this.startBlkX && blkY == this.startBlkY && blkZ == this.startBlkZ) {
            offX = (float)((double)offX - interpPosX);
            offY = (float)((double)offY - interpPosY);
            offZ = (float)((double)offZ - interpPosZ);
            par1Tessellator.setColorRGBA_F(this.particleRed * f14, this.particleGreen * f14, this.particleBlue * f14, this.particleAlpha);
            par1Tessellator.addVertexWithUV((double)(offX - x * scale - rx * scale), (double)(offY - y * scale), (double)(offZ - z * scale - rz * scale), (double)f7, (double)f9);
            par1Tessellator.addVertexWithUV((double)(offX - x * scale + rx * scale), (double)(offY + y * scale), (double)(offZ - z * scale + rz * scale), (double)f7, (double)f8);
            par1Tessellator.addVertexWithUV((double)(offX + x * scale + rx * scale), (double)(offY + y * scale), (double)(offZ + z * scale + rz * scale), (double)f6, (double)f8);
            par1Tessellator.addVertexWithUV((double)(offX + x * scale - rx * scale), (double)(offY - y * scale), (double)(offZ + z * scale - rz * scale), (double)f6, (double)f9);
        }
    }

    public void fromItem(ForgeDirection d) {
        this.posX += 0.2 * (double)d.offsetX;
        this.posY += 0.2 * (double)d.offsetY;
        this.posZ += 0.2 * (double)d.offsetZ;
        this.particleScale *= 0.8f;
    }

    public void onUpdate() {
        super.onUpdate();
        this.particleScale *= 0.51f;
        this.particleAlpha *= 0.51f;
    }
}

