/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.definitions.IDefinitions;
import appeng.api.networking.security.MachineSource;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.container.ContainerNull;
import appeng.container.guisync.GuiSync;
import appeng.container.implementations.ContainerMEMonitorable;
import appeng.container.slot.IOptionalSlotHost;
import appeng.container.slot.OptionalSlotFake;
import appeng.container.slot.SlotFake;
import appeng.container.slot.SlotFakeCraftingMatrix;
import appeng.container.slot.SlotPatternOutputs;
import appeng.container.slot.SlotPatternTerm;
import appeng.container.slot.SlotRestrictedInput;
import appeng.core.sync.packets.PacketPatternSlot;
import appeng.helpers.IContainerCraftingPacket;
import appeng.items.storage.ItemViewCell;
import appeng.parts.reporting.PartPatternTerminal;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.IAEAppEngInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.inv.AdaptorPlayerHand;
import appeng.util.item.AEItemStack;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.ForgeDirection;

public class ContainerPatternTerm
extends ContainerMEMonitorable
implements IAEAppEngInventory,
IOptionalSlotHost,
IContainerCraftingPacket {
    public final PartPatternTerminal ct;
    final AppEngInternalInventory cOut = new AppEngInternalInventory(null, 1);
    final IInventory crafting;
    final SlotFakeCraftingMatrix[] craftingSlots = new SlotFakeCraftingMatrix[9];
    final OptionalSlotFake[] outputSlots = new OptionalSlotFake[3];
    final SlotPatternTerm craftSlot;
    final SlotRestrictedInput patternSlotIN;
    final SlotRestrictedInput patternSlotOUT;
    @GuiSync(value=97)
    public boolean craftingMode = true;

    public ContainerPatternTerm(InventoryPlayer ip, ITerminalHost monitorable) {
        super(ip, monitorable, false);
        int y;
        this.ct = (PartPatternTerminal)monitorable;
        IInventory patternInv = this.ct.getInventoryByName("pattern");
        IInventory output = this.ct.getInventoryByName("output");
        this.crafting = this.ct.getInventoryByName("crafting");
        for (y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                SlotFakeCraftingMatrix slotFakeCraftingMatrix = new SlotFakeCraftingMatrix(this.crafting, x + y * 3, 18 + x * 18, -76 + y * 18);
                this.craftingSlots[x + y * 3] = slotFakeCraftingMatrix;
                this.addSlotToContainer(slotFakeCraftingMatrix);
            }
        }
        this.craftSlot = new SlotPatternTerm(ip.player, this.mySrc, this.powerSrc, monitorable, this.crafting, patternInv, this.cOut, 110, -58, this, 2, this);
        this.addSlotToContainer(this.craftSlot);
        this.craftSlot.IIcon = -1;
        for (y = 0; y < 3; ++y) {
            this.outputSlots[y] = new SlotPatternOutputs(output, this, y, 110, -76 + y * 18, 0, 0, 1);
            this.addSlotToContainer(this.outputSlots[y]);
            this.outputSlots[y].renderDisabled = false;
            this.outputSlots[y].IIcon = -1;
        }
        this.patternSlotIN = new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.BLANK_PATTERN, patternInv, 0, 147, -81, this.invPlayer);
        this.addSlotToContainer(this.patternSlotIN);
        this.patternSlotOUT = new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.ENCODED_PATTERN, patternInv, 1, 147, -38, this.invPlayer);
        this.addSlotToContainer(this.patternSlotOUT);
        this.patternSlotOUT.setStackLimit(1);
        this.bindPlayerInventory(ip, 0, 0);
        this.updateOrderOfOutputSlots();
    }

    private void updateOrderOfOutputSlots() {
        if (!this.craftingMode) {
            this.craftSlot.xDisplayPosition = -9000;
            for (int y = 0; y < 3; ++y) {
                this.outputSlots[y].xDisplayPosition = this.outputSlots[y].defX;
            }
        } else {
            this.craftSlot.xDisplayPosition = this.craftSlot.defX;
            for (int y = 0; y < 3; ++y) {
                this.outputSlots[y].xDisplayPosition = -9000;
            }
        }
    }

    public void putStackInSlot(int par1, ItemStack par2ItemStack) {
        super.putStackInSlot(par1, par2ItemStack);
        this.getAndUpdateOutput();
    }

    public void putStacksInSlots(ItemStack[] par1ArrayOfItemStack) {
        super.putStacksInSlots(par1ArrayOfItemStack);
        this.getAndUpdateOutput();
    }

    public ItemStack getAndUpdateOutput() {
        InventoryCrafting ic = new InventoryCrafting((Container)this, 3, 3);
        for (int x = 0; x < ic.getSizeInventory(); ++x) {
            ic.setInventorySlotContents(x, this.crafting.getStackInSlot(x));
        }
        ItemStack is = CraftingManager.getInstance().findMatchingRecipe(ic, this.getPlayerInv().player.worldObj);
        this.cOut.setInventorySlotContents(0, is);
        return is;
    }

    @Override
    public void saveChanges() {
    }

    @Override
    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
    }

    public void encode() {
        ItemStack output = this.patternSlotOUT.getStack();
        ItemStack[] in = this.getInputs();
        ItemStack[] out = this.getOutputs();
        if (in == null || out == null) {
            return;
        }
        if (output != null && !this.isPattern(output)) {
            return;
        }
        if (output == null) {
            output = this.patternSlotIN.getStack();
            if (output == null || !this.isPattern(output)) {
                return;
            }
            --output.stackSize;
            if (output.stackSize == 0) {
                this.patternSlotIN.putStack(null);
            }
            Iterator i$ = AEApi.instance().definitions().items().encodedPattern().maybeStack(1).asSet().iterator();
            while (i$.hasNext()) {
                ItemStack encodedPatternStack;
                output = encodedPatternStack = (ItemStack)i$.next();
                this.patternSlotOUT.putStack(output);
            }
        }
        NBTTagCompound encodedValue = new NBTTagCompound();
        NBTTagList tagIn = new NBTTagList();
        NBTTagList tagOut = new NBTTagList();
        for (ItemStack i : in) {
            tagIn.appendTag(this.createItemTag(i));
        }
        for (ItemStack i : out) {
            tagOut.appendTag(this.createItemTag(i));
        }
        encodedValue.setTag("in", (NBTBase)tagIn);
        encodedValue.setTag("out", (NBTBase)tagOut);
        encodedValue.setBoolean("crafting", this.craftingMode);
        output.setTagCompound(encodedValue);
    }

    private ItemStack[] getInputs() {
        ItemStack[] input = new ItemStack[9];
        boolean hasValue = false;
        for (int x = 0; x < this.craftingSlots.length; ++x) {
            input[x] = this.craftingSlots[x].getStack();
            if (input[x] == null) continue;
            hasValue = true;
        }
        if (hasValue) {
            return input;
        }
        return null;
    }

    private ItemStack[] getOutputs() {
        if (this.craftingMode) {
            ItemStack out = this.getAndUpdateOutput();
            if (out != null && out.stackSize > 0) {
                return new ItemStack[]{out};
            }
        } else {
            ArrayList<ItemStack> list = new ArrayList<ItemStack>(3);
            boolean hasValue = false;
            for (OptionalSlotFake outputSlot : this.outputSlots) {
                ItemStack out = outputSlot.getStack();
                if (out == null || out.stackSize <= 0) continue;
                list.add(out);
                hasValue = true;
            }
            if (hasValue) {
                return list.toArray(new ItemStack[list.size()]);
            }
        }
        return null;
    }

    private boolean isPattern(ItemStack output) {
        if (output == null) {
            return false;
        }
        IDefinitions definitions = AEApi.instance().definitions();
        boolean isPattern = definitions.items().encodedPattern().isSameAs(output);
        return isPattern |= definitions.materials().blankPattern().isSameAs(output);
    }

    private NBTBase createItemTag(ItemStack i) {
        NBTTagCompound c = new NBTTagCompound();
        if (i != null) {
            i.writeToNBT(c);
        }
        return c;
    }

    @Override
    public boolean isSlotEnabled(int idx) {
        if (idx == 1) {
            return Platform.isServer() ? !this.ct.isCraftingRecipe() : !this.craftingMode;
        }
        if (idx == 2) {
            return Platform.isServer() ? this.ct.isCraftingRecipe() : this.craftingMode;
        }
        return false;
    }

    public void craftOrGetItem(PacketPatternSlot packetPatternSlot) {
        if (packetPatternSlot.slotItem != null && this.cellInv != null) {
            IAEItemStack out = packetPatternSlot.slotItem.copy();
            InventoryAdaptor inv = new AdaptorPlayerHand(this.getPlayerInv().player);
            InventoryAdaptor playerInv = InventoryAdaptor.getAdaptor(this.getPlayerInv().player, ForgeDirection.UNKNOWN);
            if (packetPatternSlot.shift) {
                inv = playerInv;
            }
            if (inv.simulateAdd(out.getItemStack()) != null) {
                return;
            }
            IAEItemStack extracted = Platform.poweredExtraction(this.powerSrc, this.cellInv, out, this.mySrc);
            EntityPlayer p = this.getPlayerInv().player;
            if (extracted != null) {
                inv.addItems(extracted.getItemStack());
                if (p instanceof EntityPlayerMP) {
                    this.updateHeld((EntityPlayerMP)p);
                }
                this.detectAndSendChanges();
                return;
            }
            InventoryCrafting ic = new InventoryCrafting((Container)new ContainerNull(), 3, 3);
            InventoryCrafting real = new InventoryCrafting((Container)new ContainerNull(), 3, 3);
            for (int x = 0; x < 9; ++x) {
                ic.setInventorySlotContents(x, packetPatternSlot.pattern[x] == null ? null : packetPatternSlot.pattern[x].getItemStack());
            }
            IRecipe r = Platform.findMatchingRecipe(ic, p.worldObj);
            if (r == null) {
                return;
            }
            IMEMonitor storage = this.ct.getItemInventory();
            IItemList<IAEItemStack> all = storage.getStorageList();
            ItemStack is = r.getCraftingResult(ic);
            for (int x = 0; x < ic.getSizeInventory(); ++x) {
                if (ic.getStackInSlot(x) == null) continue;
                ItemStack pulled = Platform.extractItemsByRecipe(this.powerSrc, this.mySrc, storage, p.worldObj, r, is, ic, ic.getStackInSlot(x), x, all, Actionable.MODULATE, ItemViewCell.createFilter(this.getViewCells()));
                real.setInventorySlotContents(x, pulled);
            }
            IRecipe rr = Platform.findMatchingRecipe(real, p.worldObj);
            if (rr == r && Platform.isSameItemPrecise(rr.getCraftingResult(real), is)) {
                SlotCrafting sc = new SlotCrafting(p, (IInventory)real, (IInventory)this.cOut, 0, 0, 0);
                sc.onPickupFromSlot(p, is);
                for (int x = 0; x < real.getSizeInventory(); ++x) {
                    ItemStack failed = playerInv.addItems(real.getStackInSlot(x));
                    if (failed == null) continue;
                    p.dropPlayerItemWithRandomChoice(failed, false);
                }
                inv.addItems(is);
                if (p instanceof EntityPlayerMP) {
                    this.updateHeld((EntityPlayerMP)p);
                }
                this.detectAndSendChanges();
            } else {
                for (int x = 0; x < real.getSizeInventory(); ++x) {
                    ItemStack failed = real.getStackInSlot(x);
                    if (failed == null) continue;
                    this.cellInv.injectItems(AEItemStack.create(failed), Actionable.MODULATE, new MachineSource(this.ct));
                }
            }
        }
    }

    @Override
    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        if (Platform.isServer() && this.craftingMode != this.ct.isCraftingRecipe()) {
            this.craftingMode = this.ct.isCraftingRecipe();
            this.updateOrderOfOutputSlots();
        }
    }

    @Override
    public void onUpdate(String field, Object oldValue, Object newValue) {
        super.onUpdate(field, oldValue, newValue);
        if (field.equals("craftingMode")) {
            this.getAndUpdateOutput();
            this.updateOrderOfOutputSlots();
        }
    }

    @Override
    public void onSlotChange(Slot s) {
        if (s == this.patternSlotOUT && Platform.isServer()) {
            for (Object crafter : this.crafters) {
                ICrafting icrafting = (ICrafting)crafter;
                for (Object g : this.inventorySlots) {
                    if (!(g instanceof OptionalSlotFake) && !(g instanceof SlotFakeCraftingMatrix)) continue;
                    Slot sri = (Slot)g;
                    icrafting.sendSlotContents((Container)this, sri.slotNumber, sri.getStack());
                }
                ((EntityPlayerMP)icrafting).isChangingQuantityOnly = false;
            }
            this.detectAndSendChanges();
        }
    }

    public void clear() {
        for (SlotFakeCraftingMatrix slotFakeCraftingMatrix : this.craftingSlots) {
            slotFakeCraftingMatrix.putStack(null);
        }
        for (SlotFake slotFake : this.outputSlots) {
            slotFake.putStack(null);
        }
        this.detectAndSendChanges();
        this.getAndUpdateOutput();
    }

    @Override
    public IInventory getInventoryByName(String name) {
        if (name.equals("player")) {
            return this.invPlayer;
        }
        return this.ct.getInventoryByName(name);
    }

    @Override
    public boolean useRealItems() {
        return false;
    }
}

