/*
 * Decompiled with CFR 0.152.
 */
package appeng.core;

import appeng.api.util.WorldCoord;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.CommonHelper;
import appeng.core.PlayerMappings;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketNewStorageDimension;
import appeng.hooks.TickHandler;
import appeng.me.GridStorage;
import appeng.me.GridStorageSearch;
import appeng.services.CompassService;
import com.google.common.base.Optional;
import com.mojang.authlib.GameProfile;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class WorldSettings
extends Configuration {
    private static final String SPAWNDATA_FOLDER = "spawndata";
    private static final String COMPASS_FOLDER = "compass";
    private static WorldSettings instance;
    private final List<Integer> storageCellDims = new ArrayList<Integer>();
    private final File spawnDataFolder;
    private final CompassService compass;
    private final PlayerMappings mappings;
    private final Map<GridStorageSearch, WeakReference<GridStorageSearch>> loadedStorage = new WeakHashMap<GridStorageSearch, WeakReference<GridStorageSearch>>();
    private long lastGridStorage;
    private int lastPlayer;

    public WorldSettings(File aeFolder) {
        super(new File(aeFolder.getPath(), "settings.cfg"));
        this.spawnDataFolder = new File(aeFolder, SPAWNDATA_FOLDER);
        this.compass = new CompassService(aeFolder);
        for (int dimID : this.get("DimensionManager", "StorageCells", new int[0]).getIntList()) {
            this.storageCellDims.add(dimID);
            DimensionManager.registerDimension((int)dimID, (int)AEConfig.instance.storageProviderID);
        }
        try {
            this.lastGridStorage = Long.parseLong(this.get("Counters", "lastGridStorage", 0).getString());
            this.lastPlayer = this.get("Counters", "lastPlayer", 0).getInt();
        }
        catch (NumberFormatException err) {
            this.lastGridStorage = 0L;
            this.lastPlayer = 0;
        }
        ConfigCategory playerList = this.getCategory("players");
        this.mappings = new PlayerMappings(playerList, AELog.INSTANCE);
    }

    public static WorldSettings getInstance() {
        if (instance == null) {
            File world = DimensionManager.getCurrentSaveRootDirectory();
            File aeBaseFolder = new File(world.getPath(), "AE2");
            if (!aeBaseFolder.isDirectory() && !aeBaseFolder.mkdir()) {
                throw new RuntimeException("Failed to create " + aeBaseFolder.getAbsolutePath());
            }
            File compass = new File(aeBaseFolder, COMPASS_FOLDER);
            if (!compass.isDirectory() && !compass.mkdir()) {
                throw new RuntimeException("Failed to create " + compass.getAbsolutePath());
            }
            File spawnData = new File(aeBaseFolder, SPAWNDATA_FOLDER);
            if (!spawnData.isDirectory() && !spawnData.mkdir()) {
                throw new RuntimeException("Failed to create " + spawnData.getAbsolutePath());
            }
            instance = new WorldSettings(aeBaseFolder);
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<NBTTagCompound> getNearByMeteorites(int dim, int chunkX, int chunkZ) {
        LinkedList<NBTTagCompound> ll = new LinkedList<NBTTagCompound>();
        Class<WorldSettings> clazz = WorldSettings.class;
        synchronized (WorldSettings.class) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    int cx = x + (chunkX >> 4);
                    int cz = z + (chunkZ >> 4);
                    NBTTagCompound data = this.loadSpawnData(dim, cx << 4, cz << 4);
                    if (data == null) continue;
                    int size = data.getInteger("num");
                    for (int s = 0; s < size; ++s) {
                        ll.add(data.getCompoundTag(String.valueOf(s)));
                    }
                }
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return ll;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NBTTagCompound loadSpawnData(int dim, int chunkX, int chunkZ) {
        if (!Thread.holdsLock(WorldSettings.class)) {
            throw new RuntimeException("Invalid Request");
        }
        NBTTagCompound data = null;
        File file = new File(this.spawnDataFolder, dim + 95 + (chunkX >> 4) + 95 + (chunkZ >> 4) + ".dat");
        if (file.isFile()) {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                data = CompressedStreamTools.readCompressed((InputStream)fileInputStream);
            }
            catch (Throwable e) {
                data = new NBTTagCompound();
                AELog.error(e);
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException e) {
                        AELog.error(e);
                    }
                }
            }
        } else {
            data = new NBTTagCompound();
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasGenerated(int dim, int chunkX, int chunkZ) {
        Class<WorldSettings> clazz = WorldSettings.class;
        synchronized (WorldSettings.class) {
            NBTTagCompound data = this.loadSpawnData(dim, chunkX, chunkZ);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return data.getBoolean(chunkX + "," + chunkZ);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGenerated(int dim, int chunkX, int chunkZ) {
        Class<WorldSettings> clazz = WorldSettings.class;
        synchronized (WorldSettings.class) {
            NBTTagCompound data = this.loadSpawnData(dim, chunkX, chunkZ);
            data.setBoolean(chunkX + "," + chunkZ, true);
            this.writeSpawnData(dim, chunkX, chunkZ, data);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeSpawnData(int dim, int chunkX, int chunkZ, NBTTagCompound data) {
        if (!Thread.holdsLock(WorldSettings.class)) {
            throw new RuntimeException("Invalid Request");
        }
        File file = new File(this.spawnDataFolder, dim + 95 + (chunkX >> 4) + 95 + (chunkZ >> 4) + ".dat");
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            CompressedStreamTools.writeCompressed((NBTTagCompound)data, (OutputStream)fileOutputStream);
        }
        catch (Throwable e) {
            AELog.error(e);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException e) {
                    AELog.error(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addNearByMeteorites(int dim, int chunkX, int chunkZ, NBTTagCompound newData) {
        Class<WorldSettings> clazz = WorldSettings.class;
        synchronized (WorldSettings.class) {
            NBTTagCompound data = this.loadSpawnData(dim, chunkX, chunkZ);
            int size = data.getInteger("num");
            data.setTag(String.valueOf(size), (NBTBase)newData);
            data.setInteger("num", size + 1);
            this.writeSpawnData(dim, chunkX, chunkZ, data);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return true;
        }
    }

    public void shutdown() {
        this.save();
        for (Integer dimID : this.storageCellDims) {
            DimensionManager.unregisterDimension((int)dimID);
        }
        this.storageCellDims.clear();
        this.compass.kill();
        instance = null;
    }

    public void save() {
        for (GridStorageSearch gs : this.loadedStorage.keySet()) {
            GridStorage thisStorage = (GridStorage)gs.gridStorage.get();
            if (thisStorage == null || thisStorage.getGrid() == null || thisStorage.getGrid().isEmpty()) continue;
            String value = thisStorage.getValue();
            this.get("gridstorage", String.valueOf(thisStorage.getID()), value).set(value);
        }
        if (this.hasChanged()) {
            super.save();
        }
    }

    public void addStorageCellDim(int newDim) {
        this.storageCellDims.add(newDim);
        DimensionManager.registerDimension((int)newDim, (int)AEConfig.instance.storageProviderID);
        NetworkHandler.instance.sendToAll(new PacketNewStorageDimension(newDim));
        String[] values = new String[this.storageCellDims.size()];
        for (int x = 0; x < values.length; ++x) {
            values[x] = String.valueOf(this.storageCellDims.get(x));
        }
        this.get("DimensionManager", "StorageCells", new int[0]).set(values);
        this.save();
    }

    public CompassService getCompass() {
        return this.compass;
    }

    public void sendToPlayer(NetworkManager manager) {
        if (manager != null) {
            for (int newDim : this.get("DimensionManager", "StorageCells", new int[0]).getIntList()) {
                manager.scheduleOutboundPacket((Packet)new PacketNewStorageDimension(newDim).getProxy(), new GenericFutureListener[0]);
            }
        } else {
            for (TickHandler.PlayerColor pc : TickHandler.INSTANCE.getPlayerColors().values()) {
                NetworkHandler.instance.sendToAll(pc.getPacket());
            }
        }
    }

    public void init() {
        this.save();
    }

    public WorldCoord getStoredSize(int dim) {
        int x = this.get("StorageCell" + dim, "scaleX", 0).getInt();
        int y = this.get("StorageCell" + dim, "scaleY", 0).getInt();
        int z = this.get("StorageCell" + dim, "scaleZ", 0).getInt();
        return new WorldCoord(x, y, z);
    }

    public void setStoredSize(int dim, int targetX, int targetY, int targetZ) {
        this.get("StorageCell" + dim, "scaleX", 0).set(targetX);
        this.get("StorageCell" + dim, "scaleY", 0).set(targetY);
        this.get("StorageCell" + dim, "scaleZ", 0).set(targetZ);
        this.save();
    }

    public GridStorage getGridStorage(long storageID) {
        GridStorageSearch gss = new GridStorageSearch(storageID);
        WeakReference<GridStorageSearch> result = this.loadedStorage.get(gss);
        if (result == null || result.get() == null) {
            String id = String.valueOf(storageID);
            String Data = this.get("gridstorage", id, "").getString();
            GridStorage thisStorage = new GridStorage(Data, storageID, gss);
            gss.gridStorage = new WeakReference<GridStorage>(thisStorage);
            this.loadedStorage.put(gss, new WeakReference<GridStorageSearch>(gss));
            return thisStorage;
        }
        return (GridStorage)((GridStorageSearch)result.get()).gridStorage.get();
    }

    public GridStorage getNewGridStorage() {
        long storageID = this.nextGridStorage();
        GridStorageSearch gss = new GridStorageSearch(storageID);
        GridStorage newStorage = new GridStorage(storageID, gss);
        gss.gridStorage = new WeakReference<GridStorage>(newStorage);
        this.loadedStorage.put(gss, new WeakReference<GridStorageSearch>(gss));
        return newStorage;
    }

    private long nextGridStorage() {
        long r = this.lastGridStorage++;
        this.get("Counters", "lastGridStorage", this.lastGridStorage).set(Long.toString(this.lastGridStorage));
        return r;
    }

    public void destroyGridStorage(long id) {
        String stringID = String.valueOf(id);
        this.getCategory("gridstorage").remove((Object)stringID);
    }

    public int getNextOrderedValue(String name) {
        Property p = this.get("orderedValues", name, 0);
        int myValue = p.getInt();
        p.set(myValue + 1);
        return myValue;
    }

    public int getPlayerID(GameProfile profile) {
        ConfigCategory playerList = this.getCategory("players");
        if (playerList == null || profile == null || !profile.isComplete()) {
            return -1;
        }
        String uuid = profile.getId().toString();
        Property prop = playerList.get(uuid);
        if (prop != null && prop.isIntValue()) {
            return prop.getInt();
        }
        prop = new Property(uuid, String.valueOf(this.nextPlayer()), Property.Type.INTEGER);
        playerList.put(uuid, prop);
        this.mappings.put(prop.getInt(), profile.getId());
        this.save();
        return prop.getInt();
    }

    private long nextPlayer() {
        long r = this.lastPlayer;
        ++this.lastPlayer;
        this.get("Counters", "lastPlayer", this.lastPlayer).set(this.lastPlayer);
        return r;
    }

    public EntityPlayer getPlayerFromID(int playerID) {
        Optional<UUID> maybe = this.mappings.get(playerID);
        if (maybe.isPresent()) {
            UUID uuid = (UUID)maybe.get();
            for (EntityPlayer player : CommonHelper.proxy.getPlayers()) {
                if (!player.getUniqueID().equals(uuid)) continue;
                return player;
            }
        }
        return null;
    }
}

