/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.features;

import appeng.api.definitions.IBlockDefinition;
import appeng.core.CreativeTab;
import appeng.core.features.AEFeature;
import appeng.core.features.ActivityState;
import appeng.core.features.BlockDefinition;
import appeng.core.features.FeatureNameExtractor;
import appeng.core.features.FeaturedActiveChecker;
import appeng.core.features.IFeatureHandler;
import com.google.common.base.Optional;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.EnumSet;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStairs;
import net.minecraft.creativetab.CreativeTabs;

public class StairBlockFeatureHandler
implements IFeatureHandler {
    private final BlockStairs stairs;
    private final FeatureNameExtractor extractor;
    private final boolean enabled;
    private final BlockDefinition definition;

    public StairBlockFeatureHandler(EnumSet<AEFeature> features, BlockStairs stairs, Optional<String> subName) {
        ActivityState state = new FeaturedActiveChecker(features).getActivityState();
        this.stairs = stairs;
        this.extractor = new FeatureNameExtractor(stairs.getClass(), subName);
        this.enabled = state == ActivityState.Enabled;
        this.definition = new BlockDefinition((Block)stairs, state);
    }

    @Override
    public final boolean isFeatureAvailable() {
        return this.enabled;
    }

    @Override
    public final IBlockDefinition getDefinition() {
        return this.definition;
    }

    @Override
    public final void register() {
        if (this.enabled) {
            String name = this.extractor.get();
            this.stairs.setCreativeTab((CreativeTabs)CreativeTab.instance);
            this.stairs.setBlockName("appliedenergistics2." + name);
            this.stairs.setBlockTextureName("appliedenergistics2:" + name);
            GameRegistry.registerBlock((Block)this.stairs, (String)("tile." + name));
        }
    }
}

