/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.api.storage.data.IAEItemStack;
import appeng.client.EffectType;
import appeng.core.CommonHelper;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.network.INetworkInfo;
import appeng.util.item.AEItemStack;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;

public class PacketAssemblerAnimation
extends AppEngPacket {
    public final int x;
    public final int y;
    public final int z;
    public final byte rate;
    public final IAEItemStack is;

    public PacketAssemblerAnimation(ByteBuf stream) throws IOException {
        this.x = stream.readInt();
        this.y = stream.readInt();
        this.z = stream.readInt();
        this.rate = stream.readByte();
        this.is = AEItemStack.loadItemStackFromPacket(stream);
    }

    public PacketAssemblerAnimation(int x, int y, int z, byte rate, IAEItemStack is) throws IOException {
        ByteBuf data = Unpooled.buffer();
        data.writeInt(this.getPacketID());
        this.x = x;
        data.writeInt(this.x);
        this.y = y;
        data.writeInt(this.y);
        this.z = z;
        data.writeInt(this.z);
        this.rate = rate;
        data.writeByte((int)this.rate);
        is.writeToPacket(data);
        this.is = is;
        this.configureWrite(data);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void clientPacketData(INetworkInfo network, AppEngPacket packet, EntityPlayer player) {
        double d0 = 0.5;
        double d1 = 0.5;
        double d2 = 0.5;
        CommonHelper.proxy.spawnEffect(EffectType.Assembler, player.getEntityWorld(), (double)this.x + d0, (double)this.y + d1, (double)this.z + d2, this);
    }
}

