/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.container.AEBaseContainer;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.network.INetworkInfo;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;

public class PacketProgressBar
extends AppEngPacket {
    final short id;
    final long value;

    public PacketProgressBar(ByteBuf stream) {
        this.id = stream.readShort();
        this.value = stream.readLong();
    }

    public PacketProgressBar(int short_id, long value) {
        this.id = (short)short_id;
        this.value = value;
        ByteBuf data = Unpooled.buffer();
        data.writeInt(this.getPacketID());
        data.writeShort(short_id);
        data.writeLong(value);
        this.configureWrite(data);
    }

    @Override
    public void serverPacketData(INetworkInfo manager, AppEngPacket packet, EntityPlayer player) {
        Container c = player.openContainer;
        if (c instanceof AEBaseContainer) {
            ((AEBaseContainer)c).updateFullProgressBar(this.id, this.value);
        }
    }

    @Override
    public void clientPacketData(INetworkInfo network, AppEngPacket packet, EntityPlayer player) {
        Container c = player.openContainer;
        if (c instanceof AEBaseContainer) {
            ((AEBaseContainer)c).updateFullProgressBar(this.id, this.value);
        }
    }
}

