/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.client.ClientHelper;
import appeng.client.render.effects.EnergyFx;
import appeng.core.CommonHelper;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.network.INetworkInfo;
import appeng.util.Platform;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class PacketTransitionEffect
extends AppEngPacket {
    public final boolean mode;
    final double x;
    final double y;
    final double z;
    final ForgeDirection d;

    public PacketTransitionEffect(ByteBuf stream) {
        this.x = stream.readFloat();
        this.y = stream.readFloat();
        this.z = stream.readFloat();
        this.d = ForgeDirection.getOrientation((int)stream.readByte());
        this.mode = stream.readBoolean();
    }

    public PacketTransitionEffect(double x, double y, double z, ForgeDirection dir, boolean wasBlock) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.d = dir;
        this.mode = wasBlock;
        ByteBuf data = Unpooled.buffer();
        data.writeInt(this.getPacketID());
        data.writeFloat((float)x);
        data.writeFloat((float)y);
        data.writeFloat((float)z);
        data.writeByte(this.d.ordinal());
        data.writeBoolean(wasBlock);
        this.configureWrite(data);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void clientPacketData(INetworkInfo network, AppEngPacket packet, EntityPlayer player) {
        World world = ClientHelper.proxy.getWorld();
        for (int zz = 0; zz < (this.mode ? 32 : 8); ++zz) {
            if (!CommonHelper.proxy.shouldAddParticles(Platform.getRandom())) continue;
            EnergyFx fx = new EnergyFx(world, this.x + (this.mode ? (double)(Platform.getRandomInt() % 100) * 0.01 : (double)(Platform.getRandomInt() % 100) * 0.005 - 0.25), this.y + (this.mode ? (double)(Platform.getRandomInt() % 100) * 0.01 : (double)(Platform.getRandomInt() % 100) * 0.005 - 0.25), this.z + (this.mode ? (double)(Platform.getRandomInt() % 100) * 0.01 : (double)(Platform.getRandomInt() % 100) * 0.005 - 0.25), Items.diamond);
            if (!this.mode) {
                fx.fromItem(this.d);
            }
            fx.motionX = -0.1 * (double)this.d.offsetX;
            fx.motionY = -0.1 * (double)this.d.offsetY;
            fx.motionZ = -0.1 * (double)this.d.offsetZ;
            Minecraft.getMinecraft().effectRenderer.addEffect((EntityFX)fx);
        }
        if (this.mode) {
            Block block = world.getBlock((int)this.x, (int)this.y, (int)this.z);
            Minecraft.getMinecraft().getSoundHandler().playSound((ISound)new PositionedSoundRecord(new ResourceLocation(block.stepSound.getBreakSound()), (block.stepSound.getVolume() + 1.0f) / 2.0f, block.stepSound.getPitch() * 0.8f, (float)this.x + 0.5f, (float)this.y + 0.5f, (float)this.z + 0.5f));
        }
    }
}

