/*
 * Decompiled with CFR 0.152.
 */
package appeng.debug;

import appeng.core.CommonHelper;
import appeng.tile.AEBaseTile;
import appeng.tile.TileEvent;
import appeng.tile.events.TileEventType;
import appeng.util.Platform;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.util.ForgeDirection;

public class TileCubeGenerator
extends AEBaseTile {
    int size = 3;
    ItemStack is = null;
    int countdown = 200;
    EntityPlayer who;

    @TileEvent(value=TileEventType.TICK)
    public void TCG_Tick() {
        if (this.is != null && Platform.isServer()) {
            --this.countdown;
            if (this.countdown % 20 == 0) {
                for (EntityPlayer e : CommonHelper.proxy.getPlayers()) {
                    e.addChatMessage((IChatComponent)new ChatComponentText("Spawning in... " + this.countdown / 20));
                }
            }
            if (this.countdown <= 0) {
                this.spawn();
            }
        }
    }

    void spawn() {
        this.worldObj.setBlock(this.xCoord, this.yCoord, this.zCoord, Platform.AIR, 0, 3);
        Item i = this.is.getItem();
        int side = ForgeDirection.UP.ordinal();
        int half = (int)Math.floor(this.size / 2);
        for (int y = 0; y < this.size; ++y) {
            for (int x = -half; x < half; ++x) {
                for (int z = -half; z < half; ++z) {
                    i.onItemUse(this.is.copy(), this.who, this.worldObj, x + this.xCoord, y + this.yCoord - 1, z + this.zCoord, side, 0.5f, 0.0f, 0.5f);
                }
            }
        }
    }

    public void click(EntityPlayer player) {
        if (Platform.isServer()) {
            ItemStack hand = player.inventory.getCurrentItem();
            this.who = player;
            if (hand == null) {
                this.is = null;
                this.size = player.isSneaking() ? --this.size : ++this.size;
                if (this.size < 3) {
                    this.size = 3;
                }
                if (this.size > 64) {
                    this.size = 64;
                }
                player.addChatMessage((IChatComponent)new ChatComponentText("Size: " + this.size));
            } else {
                this.countdown = 200;
                this.is = hand;
            }
        }
    }
}

