/*
 * Decompiled with CFR 0.152.
 */
package appeng.helpers;

import appeng.api.util.AEColor;
import io.netty.buffer.ByteBuf;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;

public class Splotch {
    public final ForgeDirection side;
    public final boolean lumen;
    public final AEColor color;
    private final int pos;

    public Splotch(AEColor col, boolean lit, ForgeDirection side, Vec3 Pos2) {
        double y;
        double x;
        this.color = col;
        this.lumen = lit;
        if (side == ForgeDirection.SOUTH || side == ForgeDirection.NORTH) {
            x = Pos2.xCoord;
            y = Pos2.yCoord;
        } else if (side == ForgeDirection.UP || side == ForgeDirection.DOWN) {
            x = Pos2.xCoord;
            y = Pos2.zCoord;
        } else {
            x = Pos2.yCoord;
            y = Pos2.zCoord;
        }
        int a = (int)(x * 15.0);
        int b = (int)(y * 15.0);
        this.pos = a | b << 4;
        this.side = side;
    }

    public Splotch(ByteBuf data) {
        this.pos = data.readByte();
        byte val = data.readByte();
        this.side = ForgeDirection.getOrientation((int)(val & 7));
        this.color = AEColor.values()[val >> 3 & 0xF];
        this.lumen = (val >> 7 & 1) > 0;
    }

    public void writeToStream(ByteBuf stream) {
        stream.writeByte(this.pos);
        int val = this.side.ordinal() | this.color.ordinal() << 3 | (this.lumen ? 128 : 0);
        stream.writeByte(val);
    }

    public float x() {
        return (float)(this.pos & 0xF) / 15.0f;
    }

    public float y() {
        return (float)(this.pos >> 4 & 0xF) / 15.0f;
    }

    public int getSeed() {
        int val = this.side.ordinal() | this.color.ordinal() << 3 | (this.lumen ? 128 : 0);
        return Math.abs(this.pos + val);
    }
}

