/*
 * Decompiled with CFR 0.152.
 */
package appeng.hooks;

import appeng.api.AEApi;
import appeng.api.definitions.IItemDefinition;
import appeng.api.definitions.IMaterials;
import com.google.common.base.Optional;
import cpw.mods.fml.common.registry.VillagerRegistry;
import java.util.Random;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;

public class AETrading
implements VillagerRegistry.IVillageTradeHandler {
    public void manipulateTradesForVillager(EntityVillager villager, MerchantRecipeList recipeList, Random random) {
        IMaterials materials = AEApi.instance().definitions().materials();
        this.addMerchant(recipeList, materials.silicon(), 1, random, 2);
        this.addMerchant(recipeList, materials.certusQuartzCrystal(), 2, random, 4);
        this.addMerchant(recipeList, materials.certusQuartzDust(), 1, random, 3);
        this.addTrade(recipeList, materials.certusQuartzDust(), materials.certusQuartzCrystal(), random, 2);
    }

    private void addMerchant(MerchantRecipeList list, IItemDefinition item, int emera, Random rand, int greed) {
        for (ItemStack itemStack : item.maybeStack(1).asSet()) {
            ItemStack from = itemStack.copy();
            ItemStack to = new ItemStack(Items.emerald);
            int multiplier = Math.abs(rand.nextInt()) % 6;
            int emeraldCost = emera + Math.abs(rand.nextInt()) % greed - multiplier;
            int mood = rand.nextInt() % 2;
            from.stackSize = multiplier + mood;
            to.stackSize = multiplier * emeraldCost - mood;
            if (to.stackSize < 0) {
                from.stackSize -= to.stackSize;
                to.stackSize -= to.stackSize;
            }
            this.addToList(list, from, to);
            ItemStack reverseTo = from.copy();
            ItemStack reverseFrom = to.copy();
            reverseFrom.stackSize = (int)((float)reverseFrom.stackSize * (rand.nextFloat() * 3.0f + 1.0f));
            this.addToList(list, reverseFrom, reverseTo);
        }
    }

    private void addTrade(MerchantRecipeList list, IItemDefinition inputDefinition, IItemDefinition outputDefinition, Random rand, int conversionVariance) {
        Optional<ItemStack> maybeInputStack = inputDefinition.maybeStack(1);
        Optional<ItemStack> maybeOutputStack = outputDefinition.maybeStack(1);
        if (maybeInputStack.isPresent() && maybeOutputStack.isPresent()) {
            ItemStack inputStack = ((ItemStack)maybeInputStack.get()).copy();
            ItemStack outputStack = ((ItemStack)maybeOutputStack.get()).copy();
            inputStack.stackSize = 1 + Math.abs(rand.nextInt()) % (1 + conversionVariance);
            outputStack.stackSize = 1;
            this.addToList(list, inputStack, outputStack);
        }
    }

    private void addToList(MerchantRecipeList l, ItemStack a, ItemStack b) {
        if (a.stackSize < 1) {
            a.stackSize = 1;
        }
        if (b.stackSize < 1) {
            b.stackSize = 1;
        }
        if (a.stackSize > a.getMaxStackSize()) {
            a.stackSize = a.getMaxStackSize();
        }
        if (b.stackSize > b.getMaxStackSize()) {
            b.stackSize = b.getMaxStackSize();
        }
        l.add((Object)new MerchantRecipe(a, b));
    }
}

