/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.NEIHelpers;

import appeng.api.AEApi;
import appeng.api.features.IInscriberRecipe;
import appeng.client.gui.implementations.GuiInscriber;
import appeng.core.localization.GuiText;
import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.api.IRecipeOverlayRenderer;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class NEIInscriberRecipeHandler
extends TemplateRecipeHandler {
    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(84, 23, 24, 18), "inscriber", new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("inscriber") && ((Object)((Object)this)).getClass() == NEIInscriberRecipeHandler.class) {
            for (IInscriberRecipe recipe : AEApi.instance().registries().inscriber().getRecipes()) {
                CachedInscriberRecipe cachedRecipe = new CachedInscriberRecipe(recipe);
                cachedRecipe.computeVisuals();
                this.arecipes.add(cachedRecipe);
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (IInscriberRecipe recipe : AEApi.instance().registries().inscriber().getRecipes()) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)recipe.getOutput(), (ItemStack)result)) continue;
            CachedInscriberRecipe cachedRecipe = new CachedInscriberRecipe(recipe);
            cachedRecipe.computeVisuals();
            this.arecipes.add(cachedRecipe);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (IInscriberRecipe recipe : AEApi.instance().registries().inscriber().getRecipes()) {
            CachedInscriberRecipe cachedRecipe = new CachedInscriberRecipe(recipe);
            if (!cachedRecipe.contains(cachedRecipe.ingredients, ingredient.getItem())) continue;
            cachedRecipe.computeVisuals();
            if (!cachedRecipe.contains(cachedRecipe.ingredients, ingredient)) continue;
            cachedRecipe.setIngredientPermutation(cachedRecipe.ingredients, ingredient);
            this.arecipes.add(cachedRecipe);
        }
    }

    public String getGuiTexture() {
        ResourceLocation loc = new ResourceLocation("appliedenergistics2", "textures/guis/inscriber.png");
        return loc.toString();
    }

    public String getOverlayIdentifier() {
        return "inscriber";
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiInscriber.class;
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)5, (int)11, (int)166, (int)75);
    }

    public boolean hasOverlay(GuiContainer gui, Container container, int recipe) {
        return false;
    }

    public IRecipeOverlayRenderer getOverlayRenderer(GuiContainer gui, int recipe) {
        return null;
    }

    public IOverlayHandler getOverlayHandler(GuiContainer gui, int recipe) {
        return null;
    }

    public String getRecipeName() {
        return GuiText.Inscriber.getLocal();
    }

    public class CachedInscriberRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public final ArrayList<PositionedStack> ingredients;
        public final PositionedStack result;

        public CachedInscriberRecipe(IInscriberRecipe recipe) {
            super((TemplateRecipeHandler)NEIInscriberRecipeHandler.this);
            this.result = new PositionedStack((Object)recipe.getOutput(), 108, 29);
            this.ingredients = new ArrayList();
            for (ItemStack top : recipe.getTopOptional().asSet()) {
                this.ingredients.add(new PositionedStack((Object)top, 40, 5));
            }
            this.ingredients.add(new PositionedStack(recipe.getInputs(), 58, 28));
            for (ItemStack bot : recipe.getBottomOptional().asSet()) {
                this.ingredients.add(new PositionedStack((Object)bot, 40, 51));
            }
        }

        public PositionedStack getResult() {
            return this.result;
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(NEIInscriberRecipeHandler.this.cycleticks / 20, this.ingredients);
        }

        public void computeVisuals() {
            for (PositionedStack p : this.ingredients) {
                p.generatePermutations();
            }
            this.result.generatePermutations();
        }
    }
}

