/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.waila.part;

import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public final class Tracer {
    public MovingObjectPosition retraceBlock(World world, EntityPlayerMP player, int x, int y, int z) {
        Block block = world.getBlock(x, y, z);
        Vec3 headVec = this.getCorrectedHeadVec((EntityPlayer)player);
        Vec3 lookVec = player.getLook(1.0f);
        double reach = this.getBlockReachDistance_server(player);
        Vec3 endVec = headVec.addVector(lookVec.xCoord * reach, lookVec.yCoord * reach, lookVec.zCoord * reach);
        return block.collisionRayTrace(world, x, y, z, headVec, endVec);
    }

    private Vec3 getCorrectedHeadVec(EntityPlayer player) {
        Vec3 v = Vec3.createVectorHelper((double)player.posX, (double)player.posY, (double)player.posZ);
        if (player.worldObj.isRemote) {
            v.yCoord += (double)(player.getEyeHeight() - player.getDefaultEyeHeight());
        } else {
            v.yCoord += (double)player.getEyeHeight();
            if (player instanceof EntityPlayerMP && player.isSneaking()) {
                v.yCoord -= 0.08;
            }
        }
        return v;
    }

    private double getBlockReachDistance_server(EntityPlayerMP player) {
        return player.theItemInWorldManager.getBlockReachDistance();
    }
}

