/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.waila.tile;

import appeng.api.networking.energy.IAEPowerStorage;
import appeng.core.localization.WailaText;
import appeng.integration.modules.waila.BaseWailaDataProvider;
import appeng.util.Platform;
import gnu.trove.map.TObjectLongMap;
import gnu.trove.map.hash.TObjectLongHashMap;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public final class PowerStorageWailaDataProvider
extends BaseWailaDataProvider {
    private static final String ID_CURRENT_POWER = "currentPower";
    private final TObjectLongMap<TileEntity> cache = new TObjectLongHashMap();

    @Override
    public List<String> getWailaBody(ItemStack itemStack, List<String> currentToolTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        IAEPowerStorage storage;
        double maxPower;
        TileEntity te = accessor.getTileEntity();
        if (te instanceof IAEPowerStorage && (maxPower = (storage = (IAEPowerStorage)te).getAEMaxPower()) > 0.0) {
            NBTTagCompound tag = accessor.getNBTData();
            long internalCurrentPower = this.getInternalCurrentPower(tag, te);
            long internalMaxPower = (long)(100.0 * maxPower);
            String formatCurrentPower = Platform.formatPowerLong(internalCurrentPower, false);
            String formatMaxPower = Platform.formatPowerLong(internalMaxPower, false);
            currentToolTip.add(WailaText.Contains.getLocal() + ": " + formatCurrentPower + " / " + formatMaxPower);
        }
        return currentToolTip;
    }

    @Override
    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, int x, int y, int z) {
        IAEPowerStorage storage;
        if (te instanceof IAEPowerStorage && (storage = (IAEPowerStorage)te).getAEMaxPower() > 0.0) {
            long internalCurrentPower = (long)(100.0 * storage.getAECurrentPower());
            tag.setLong(ID_CURRENT_POWER, internalCurrentPower);
        }
        return tag;
    }

    private long getInternalCurrentPower(NBTTagCompound tag, TileEntity te) {
        long internalCurrentPower;
        if (tag.hasKey(ID_CURRENT_POWER)) {
            internalCurrentPower = tag.getLong(ID_CURRENT_POWER);
            this.cache.put((Object)te, internalCurrentPower);
        } else {
            internalCurrentPower = this.cache.containsKey((Object)te) ? this.cache.get((Object)te) : 0L;
        }
        return internalCurrentPower;
    }
}

