/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.misc;

import appeng.api.AEApi;
import appeng.api.definitions.IMaterials;
import appeng.api.implementations.items.IGrowableCrystal;
import appeng.api.recipes.ResolverResult;
import appeng.core.AppEng;
import appeng.core.features.AEFeature;
import appeng.core.localization.ButtonToolTips;
import appeng.entity.EntityGrowingCrystal;
import appeng.entity.EntityIds;
import appeng.items.AEBaseItem;
import appeng.util.Platform;
import cpw.mods.fml.common.registry.EntityRegistry;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class ItemCrystalSeed
extends AEBaseItem
implements IGrowableCrystal {
    public static final int LEVEL_OFFSET = 200;
    public static final int SINGLE_OFFSET = 600;
    public static final int Certus = 0;
    public static final int Nether = 600;
    public static final int Fluix = 1200;
    public static final int END = 1800;
    final IIcon[] certus = new IIcon[3];
    final IIcon[] fluix = new IIcon[3];
    final IIcon[] nether = new IIcon[3];

    public ItemCrystalSeed() {
        this.setHasSubtypes(true);
        this.setFeature(EnumSet.of(AEFeature.Core));
        EntityRegistry.registerModEntity(EntityGrowingCrystal.class, (String)EntityGrowingCrystal.class.getSimpleName(), (int)EntityIds.get(EntityGrowingCrystal.class), (Object)AppEng.instance, (int)16, (int)4, (boolean)true);
    }

    @Nullable
    public static ResolverResult getResolver(int certus2) {
        ResolverResult resolver = null;
        for (ItemStack crystalSeedStack : AEApi.instance().definitions().items().crystalSeed().maybeStack(1).asSet()) {
            crystalSeedStack.setItemDamage(certus2);
            crystalSeedStack = ItemCrystalSeed.newStyle(crystalSeedStack);
            resolver = new ResolverResult("ItemCrystalSeed", crystalSeedStack.getItemDamage(), crystalSeedStack.getTagCompound());
        }
        return resolver;
    }

    private static ItemStack newStyle(ItemStack itemStack) {
        ((ItemCrystalSeed)itemStack.getItem()).getProgress(itemStack);
        return itemStack;
    }

    private int getProgress(ItemStack is) {
        if (is.hasTagCompound()) {
            return is.getTagCompound().getInteger("progress");
        }
        NBTTagCompound comp = Platform.openNbtData(is);
        int progress = is.getItemDamage();
        comp.setInteger("progress", progress);
        is.setItemDamage(is.getItemDamage() / 600 * 600);
        return progress;
    }

    @Override
    @Nullable
    public ItemStack triggerGrowth(ItemStack is) {
        Iterator i$;
        int newDamage = this.getProgress(is) + 1;
        IMaterials materials = AEApi.instance().definitions().materials();
        int size = is.stackSize;
        if (newDamage == 600 && (i$ = materials.purifiedCertusQuartzCrystal().maybeStack(size).asSet().iterator()).hasNext()) {
            ItemStack quartzStack = (ItemStack)i$.next();
            return quartzStack;
        }
        if (newDamage == 1200 && (i$ = materials.purifiedNetherQuartzCrystal().maybeStack(size).asSet().iterator()).hasNext()) {
            ItemStack quartzStack = (ItemStack)i$.next();
            return quartzStack;
        }
        if (newDamage == 1800 && (i$ = materials.purifiedFluixCrystal().maybeStack(size).asSet().iterator()).hasNext()) {
            ItemStack quartzStack = (ItemStack)i$.next();
            return quartzStack;
        }
        if (newDamage > 1800) {
            return null;
        }
        this.setProgress(is, newDamage);
        return is;
    }

    private void setProgress(ItemStack is, int newDamage) {
        NBTTagCompound comp = Platform.openNbtData(is);
        comp.setInteger("progress", newDamage);
        is.setItemDamage(is.getItemDamage() / 200 * 200);
    }

    @Override
    public float getMultiplier(Block blk, Material mat) {
        return 0.5f;
    }

    @Override
    public void addCheckedInformation(ItemStack stack, EntityPlayer player, List<String> lines, boolean displayAdditionalInformation) {
        lines.add(ButtonToolTips.DoesntDespawn.getLocal());
        int progress = this.getProgress(stack) % 600;
        lines.add(Math.floor((float)progress / 6.0f) + "%");
        super.addCheckedInformation(stack, player, lines, displayAdditionalInformation);
    }

    public int getEntityLifespan(ItemStack itemStack, World world) {
        return Integer.MAX_VALUE;
    }

    public String getUnlocalizedName(ItemStack is) {
        int damage = this.getProgress(is);
        if (damage < 600) {
            return this.getUnlocalizedName() + ".Certus";
        }
        if (damage < 1200) {
            return this.getUnlocalizedName() + ".Nether";
        }
        if (damage < 1800) {
            return this.getUnlocalizedName() + ".Fluix";
        }
        return this.getUnlocalizedName();
    }

    public boolean isDamageable() {
        return false;
    }

    public boolean isDamaged(ItemStack stack) {
        return false;
    }

    public int getMaxDamage(ItemStack stack) {
        return 1800;
    }

    public IIcon getIcon(ItemStack stack, int pass) {
        return this.getIconIndex(stack);
    }

    public IIcon getIconIndex(ItemStack stack) {
        IIcon[] list = null;
        int damage = this.getProgress(stack);
        if (damage < 600) {
            list = this.certus;
        } else if (damage < 1200) {
            damage -= 600;
            list = this.nether;
        } else if (damage < 1800) {
            damage -= 1200;
            list = this.fluix;
        }
        if (list == null) {
            return Items.diamond.getIconFromDamage(0);
        }
        if (damage < 200) {
            return list[0];
        }
        if (damage < 400) {
            return list[1];
        }
        return list[2];
    }

    public void registerIcons(IIconRegister ir) {
        String preFix = "appliedenergistics2:ItemCrystalSeed.";
        this.certus[0] = ir.registerIcon(preFix + "Certus");
        this.certus[1] = ir.registerIcon(preFix + "Certus2");
        this.certus[2] = ir.registerIcon(preFix + "Certus3");
        this.nether[0] = ir.registerIcon(preFix + "Nether");
        this.nether[1] = ir.registerIcon(preFix + "Nether2");
        this.nether[2] = ir.registerIcon(preFix + "Nether3");
        this.fluix[0] = ir.registerIcon(preFix + "Fluix");
        this.fluix[1] = ir.registerIcon(preFix + "Fluix2");
        this.fluix[2] = ir.registerIcon(preFix + "Fluix3");
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    public Entity createEntity(World world, Entity location, ItemStack itemstack) {
        EntityGrowingCrystal egc = new EntityGrowingCrystal(world, location.posX, location.posY, location.posZ, itemstack);
        egc.motionX = location.motionX;
        egc.motionY = location.motionY;
        egc.motionZ = location.motionZ;
        if (location instanceof EntityItem) {
            egc.delayBeforeCanPickup = ((EntityItem)location).delayBeforeCanPickup;
        }
        return egc;
    }

    public void getSubItems(Item i, CreativeTabs t, List l) {
        l.add(ItemCrystalSeed.newStyle(new ItemStack((Item)this, 1, 0)));
        l.add(ItemCrystalSeed.newStyle(new ItemStack((Item)this, 1, 600)));
        l.add(ItemCrystalSeed.newStyle(new ItemStack((Item)this, 1, 1200)));
        l.add(ItemCrystalSeed.newStyle(new ItemStack((Item)this, 1, 200)));
        l.add(ItemCrystalSeed.newStyle(new ItemStack((Item)this, 1, 800)));
        l.add(ItemCrystalSeed.newStyle(new ItemStack((Item)this, 1, 1400)));
        l.add(ItemCrystalSeed.newStyle(new ItemStack((Item)this, 1, 400)));
        l.add(ItemCrystalSeed.newStyle(new ItemStack((Item)this, 1, 1000)));
        l.add(ItemCrystalSeed.newStyle(new ItemStack((Item)this, 1, 1600)));
    }
}

