/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.parts;

import appeng.api.AEApi;
import appeng.api.implementations.items.IItemGroup;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHelper;
import appeng.api.parts.IPartItem;
import appeng.api.util.AEColor;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.features.AEFeature;
import appeng.core.features.ItemStackSrc;
import appeng.core.features.NameResolver;
import appeng.core.localization.GuiText;
import appeng.items.AEBaseItem;
import appeng.items.parts.PartType;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class ItemMultiPart
extends AEBaseItem
implements IPartItem,
IItemGroup {
    public static ItemMultiPart instance;
    private final NameResolver nameResolver;
    private final Map<Integer, PartTypeIst> dmgToPart = new HashMap<Integer, PartTypeIst>();

    public ItemMultiPart(IPartHelper partHelper) {
        this.nameResolver = new NameResolver(this.getClass());
        this.setFeature(EnumSet.of(AEFeature.Core));
        partHelper.setItemBusRenderer(this);
        this.setHasSubtypes(true);
        instance = this;
    }

    public final ItemStackSrc createPart(PartType mat) {
        int varID = 0;
        for (PartTypeIst p : this.dmgToPart.values()) {
            if (p.part != mat || p.variant != varID) continue;
            throw new RuntimeException("Cannot create the same material twice...");
        }
        boolean enabled = true;
        for (AEFeature f : mat.getFeature()) {
            enabled = enabled && AEConfig.instance.isFeatureEnabled(f);
        }
        int newPartNum = mat.baseDamage + varID;
        ItemStackSrc output = new ItemStackSrc(this, newPartNum);
        if (enabled) {
            PartTypeIst pti = new PartTypeIst();
            pti.part = mat;
            pti.variant = varID;
            if (this.dmgToPart.get(newPartNum) == null) {
                this.dmgToPart.put(newPartNum, pti);
                return output;
            }
            throw new RuntimeException("Meta Overlap detected.");
        }
        return output;
    }

    public ItemStackSrc createPart(PartType mat, Enum variant) {
        try {
            ItemStack is = new ItemStack((Item)this);
            mat.getPart().getConstructor(ItemStack.class).newInstance(is);
        }
        catch (Throwable e) {
            AELog.integration(e);
            e.printStackTrace();
            return null;
        }
        int varID = variant == null ? 0 : variant.ordinal();
        for (PartTypeIst p : this.dmgToPart.values()) {
            if (p.part != mat || p.variant != varID) continue;
            throw new RuntimeException("Cannot create the same material twice...");
        }
        boolean enabled = true;
        for (AEFeature f : mat.getFeature()) {
            enabled = enabled && AEConfig.instance.isFeatureEnabled(f);
        }
        if (enabled) {
            int newPartNum = mat.baseDamage + varID;
            ItemStackSrc output = new ItemStackSrc(this, newPartNum);
            PartTypeIst pti = new PartTypeIst();
            pti.part = mat;
            pti.variant = varID;
            if (this.dmgToPart.get(newPartNum) == null) {
                this.dmgToPart.put(newPartNum, pti);
                return output;
            }
            throw new RuntimeException("Meta Overlap detected.");
        }
        return null;
    }

    public int getDamageByType(PartType t) {
        for (Map.Entry<Integer, PartTypeIst> pt : this.dmgToPart.entrySet()) {
            if (pt.getValue().part != t) continue;
            return pt.getKey();
        }
        return -1;
    }

    @SideOnly(value=Side.CLIENT)
    public int getSpriteNumber() {
        return 0;
    }

    public IIcon getIconFromDamage(int dmg) {
        return this.dmgToPart.get(dmg).ico;
    }

    public boolean onItemUse(ItemStack is, EntityPlayer player, World w, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        return AEApi.instance().partHelper().placeBus(is, x, y, z, side, player, w);
    }

    public String getUnlocalizedName(ItemStack is) {
        return "item.appliedenergistics2." + this.getName(is);
    }

    public String getName(ItemStack is) {
        return this.nameResolver.getName(this.getTypeByStack(is).name());
    }

    @Nullable
    public PartType getTypeByStack(ItemStack is) {
        if (is == null) {
            return null;
        }
        PartTypeIst pt = this.dmgToPart.get(is.getItemDamage());
        if (pt != null) {
            return pt.part;
        }
        return null;
    }

    public String getItemStackDisplayName(ItemStack is) {
        PartType pt = this.getTypeByStack(is);
        if (pt == null) {
            return "Unnamed";
        }
        if (pt.isCable()) {
            AEColor[] variants = AEColor.values();
            return super.getItemStackDisplayName(is) + " - " + variants[this.dmgToPart.get(is.getItemDamage()).variant].toString();
        }
        if (pt.getExtraName() != null) {
            return super.getItemStackDisplayName(is) + " - " + pt.getExtraName().getLocal();
        }
        return super.getItemStackDisplayName(is);
    }

    public void getSubItems(Item number, CreativeTabs tab, List cList) {
        ArrayList<Map.Entry<Integer, PartTypeIst>> types = new ArrayList<Map.Entry<Integer, PartTypeIst>>(this.dmgToPart.entrySet());
        Collections.sort(types, new Comparator<Map.Entry<Integer, PartTypeIst>>(){

            @Override
            public int compare(Map.Entry<Integer, PartTypeIst> o1, Map.Entry<Integer, PartTypeIst> o2) {
                return o1.getValue().part.name().compareTo(o2.getValue().part.name());
            }
        });
        for (Map.Entry entry : types) {
            cList.add(new ItemStack((Item)this, 1, ((Integer)entry.getKey()).intValue()));
        }
    }

    public void registerIcons(IIconRegister par1IconRegister) {
        for (Map.Entry<Integer, PartTypeIst> part : this.dmgToPart.entrySet()) {
            String tex = "appliedenergistics2:" + this.getName(new ItemStack((Item)this, 1, part.getKey().intValue()));
            part.getValue().ico = par1IconRegister.registerIcon(tex);
        }
    }

    @Override
    public IPart createPartFromItemStack(ItemStack is) {
        try {
            PartType t = this.getTypeByStack(is);
            if (t != null) {
                if (t.constructor == null) {
                    t.constructor = t.getPart().getConstructor(ItemStack.class);
                }
                return t.constructor.newInstance(is);
            }
        }
        catch (Throwable e) {
            throw new RuntimeException("Unable to construct IBusPart from IBusItem : " + this.getTypeByStack(is).getPart().getName() + " ; Possibly didn't have correct constructor( ItemStack )", e);
        }
        return null;
    }

    public int variantOf(int itemDamage) {
        if (this.dmgToPart.containsKey(itemDamage)) {
            return this.dmgToPart.get(itemDamage).variant;
        }
        return 0;
    }

    @Override
    public String getUnlocalizedGroupName(Set<ItemStack> others, ItemStack is) {
        boolean importBus = false;
        boolean exportBus = false;
        boolean group = false;
        PartType u = this.getTypeByStack(is);
        for (ItemStack stack : others) {
            PartType pt;
            if (stack.getItem() != this || (pt = this.getTypeByStack(stack)) == null) continue;
            switch (pt) {
                case ImportBus: {
                    importBus = true;
                    if (u != pt) break;
                    group = true;
                    break;
                }
                case ExportBus: {
                    exportBus = true;
                    if (u != pt) break;
                    group = true;
                    break;
                }
            }
        }
        if (group && importBus && exportBus) {
            return GuiText.IOBuses.getUnlocalized();
        }
        return null;
    }

    public ItemStack getStackFromTypeAndVariant(PartType mt, int variant) {
        return new ItemStack((Item)this, 1, mt.baseDamage + variant);
    }

    private static class PartTypeIst {
        private PartType part;
        private int variant;
        @SideOnly(value=Side.CLIENT)
        private IIcon ico;

        private PartTypeIst() {
        }
    }
}

