/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools.powered;

import appeng.api.util.DimensionalCoord;
import appeng.block.misc.BlockTinyTNT;
import appeng.core.AEConfig;
import appeng.core.features.AEFeature;
import appeng.hooks.DispenserBlockTool;
import appeng.hooks.IBlockTool;
import appeng.items.tools.powered.powersink.AEBasePoweredItem;
import appeng.util.InWorldToolOperationResult;
import appeng.util.Platform;
import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockTNT;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ToolEntropyManipulator
extends AEBasePoweredItem
implements IBlockTool {
    private final Map<InWorldToolOperationIngredient, InWorldToolOperationResult> heatUp;
    private final Map<InWorldToolOperationIngredient, InWorldToolOperationResult> coolDown;

    public ToolEntropyManipulator() {
        super(AEConfig.instance.entropyManipulatorBattery, (Optional<String>)Optional.absent());
        this.setFeature(EnumSet.of(AEFeature.EntropyManipulator, AEFeature.PoweredTools));
        this.heatUp = new HashMap<InWorldToolOperationIngredient, InWorldToolOperationResult>();
        this.coolDown = new HashMap<InWorldToolOperationIngredient, InWorldToolOperationResult>();
        this.coolDown.put(new InWorldToolOperationIngredient(Blocks.stone, 0), new InWorldToolOperationResult(new ItemStack(Blocks.cobblestone)));
        this.coolDown.put(new InWorldToolOperationIngredient(Blocks.stonebrick, 0), new InWorldToolOperationResult(new ItemStack(Blocks.stonebrick, 1, 2)));
        this.coolDown.put(new InWorldToolOperationIngredient(Blocks.lava, Short.MAX_VALUE), new InWorldToolOperationResult(new ItemStack(Blocks.obsidian)));
        this.coolDown.put(new InWorldToolOperationIngredient((Block)Blocks.flowing_lava, Short.MAX_VALUE), new InWorldToolOperationResult(new ItemStack(Blocks.obsidian)));
        this.coolDown.put(new InWorldToolOperationIngredient((Block)Blocks.grass, Short.MAX_VALUE), new InWorldToolOperationResult(new ItemStack(Blocks.dirt)));
        ArrayList<ItemStack> snowBalls = new ArrayList<ItemStack>();
        snowBalls.add(new ItemStack(Items.snowball));
        this.coolDown.put(new InWorldToolOperationIngredient((Block)Blocks.flowing_water, Short.MAX_VALUE), new InWorldToolOperationResult(null, snowBalls));
        this.coolDown.put(new InWorldToolOperationIngredient(Blocks.water, Short.MAX_VALUE), new InWorldToolOperationResult(new ItemStack(Blocks.ice)));
        this.heatUp.put(new InWorldToolOperationIngredient(Blocks.ice, 0), new InWorldToolOperationResult(new ItemStack(Blocks.water)));
        this.heatUp.put(new InWorldToolOperationIngredient((Block)Blocks.flowing_water, Short.MAX_VALUE), new InWorldToolOperationResult());
        this.heatUp.put(new InWorldToolOperationIngredient(Blocks.water, Short.MAX_VALUE), new InWorldToolOperationResult());
        this.heatUp.put(new InWorldToolOperationIngredient(Blocks.snow, Short.MAX_VALUE), new InWorldToolOperationResult(new ItemStack((Block)Blocks.flowing_water)));
    }

    @Override
    public void postInit() {
        super.postInit();
        BlockDispenser.dispenseBehaviorRegistry.putObject((Object)this, (Object)new DispenserBlockTool());
    }

    private void heat(Block blockID, int metadata, World w, int x, int y, int z) {
        InWorldToolOperationResult r = this.heatUp.get(new InWorldToolOperationIngredient(blockID, metadata));
        if (r == null) {
            r = this.heatUp.get(new InWorldToolOperationIngredient(blockID, Short.MAX_VALUE));
        }
        if (r.BlockItem != null) {
            w.setBlock(x, y, z, Block.getBlockFromItem((Item)r.BlockItem.getItem()), r.BlockItem.getItemDamage(), 3);
        } else {
            w.setBlock(x, y, z, Platform.AIR, 0, 3);
        }
        if (r.Drops != null) {
            Platform.spawnDrops(w, x, y, z, r.Drops);
        }
    }

    private boolean canHeat(Block blockID, int metadata) {
        InWorldToolOperationResult r = this.heatUp.get(new InWorldToolOperationIngredient(blockID, metadata));
        if (r == null) {
            r = this.heatUp.get(new InWorldToolOperationIngredient(blockID, Short.MAX_VALUE));
        }
        return r != null;
    }

    private void cool(Block blockID, int metadata, World w, int x, int y, int z) {
        InWorldToolOperationResult r = this.coolDown.get(new InWorldToolOperationIngredient(blockID, metadata));
        if (r == null) {
            r = this.coolDown.get(new InWorldToolOperationIngredient(blockID, Short.MAX_VALUE));
        }
        if (r.BlockItem != null) {
            w.setBlock(x, y, z, Block.getBlockFromItem((Item)r.BlockItem.getItem()), r.BlockItem.getItemDamage(), 3);
        } else {
            w.setBlock(x, y, z, Platform.AIR, 0, 3);
        }
        if (r.Drops != null) {
            Platform.spawnDrops(w, x, y, z, r.Drops);
        }
    }

    private boolean canCool(Block blockID, int metadata) {
        InWorldToolOperationResult r = this.coolDown.get(new InWorldToolOperationIngredient(blockID, metadata));
        if (r == null) {
            r = this.coolDown.get(new InWorldToolOperationIngredient(blockID, Short.MAX_VALUE));
        }
        return r != null;
    }

    public boolean hitEntity(ItemStack item, EntityLivingBase target, EntityLivingBase hitter) {
        if (this.getAECurrentPower(item) > 1600.0) {
            this.extractAEPower(item, 1600.0);
            target.setFire(8);
        }
        return false;
    }

    public ItemStack onItemRightClick(ItemStack item, World w, EntityPlayer p) {
        int z;
        int y;
        int x;
        MovingObjectPosition target = this.getMovingObjectPositionFromPlayer(w, p, true);
        if (target == null) {
            return item;
        }
        if (target.typeOfHit == MovingObjectPosition.MovingObjectType.BLOCK && (w.getBlock(x = target.blockX, y = target.blockY, z = target.blockZ).getMaterial() == Material.lava || w.getBlock(x, y, z).getMaterial() == Material.water) && Platform.hasPermissions(new DimensionalCoord(w, x, y, z), p)) {
            this.onItemUse(item, p, w, x, y, z, 0, 0.0f, 0.0f, 0.0f);
        }
        return item;
    }

    @Override
    public boolean onItemUse(ItemStack item, EntityPlayer p, World w, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (this.getAECurrentPower(item) > 1600.0) {
            if (!p.canPlayerEdit(x, y, z, side, item)) {
                return false;
            }
            Block blockID = w.getBlock(x, y, z);
            int metadata = w.getBlockMetadata(x, y, z);
            if (p.isSneaking()) {
                if (this.canCool(blockID, metadata)) {
                    this.extractAEPower(item, 1600.0);
                    this.cool(blockID, metadata, w, x, y, z);
                    return true;
                }
            } else {
                if (blockID instanceof BlockTNT) {
                    w.setBlock(x, y, z, Platform.AIR, 0, 3);
                    ((BlockTNT)blockID).func_150114_a(w, x, y, z, 1, (EntityLivingBase)p);
                    return true;
                }
                if (blockID instanceof BlockTinyTNT) {
                    w.setBlock(x, y, z, Platform.AIR, 0, 3);
                    ((BlockTinyTNT)blockID).startFuse(w, x, y, z, (EntityLivingBase)p);
                    return true;
                }
                if (this.canHeat(blockID, metadata)) {
                    this.extractAEPower(item, 1600.0);
                    this.heat(blockID, metadata, w, x, y, z);
                    return true;
                }
                ItemStack[] stack = Platform.getBlockDrops(w, x, y, z);
                ArrayList<ItemStack> out = new ArrayList<ItemStack>();
                boolean hasFurnaceable = false;
                boolean canFurnaceable = true;
                for (ItemStack i : stack) {
                    ItemStack result = FurnaceRecipes.smelting().getSmeltingResult(i);
                    if (result != null) {
                        if (result.getItem() instanceof ItemBlock && Block.getBlockFromItem((Item)result.getItem()) == blockID && result.getItem().getDamage(result) == metadata) {
                            canFurnaceable = false;
                        }
                        hasFurnaceable = true;
                        out.add(result);
                        continue;
                    }
                    canFurnaceable = false;
                    out.add(i);
                }
                if (hasFurnaceable && canFurnaceable) {
                    this.extractAEPower(item, 1600.0);
                    InWorldToolOperationResult or = InWorldToolOperationResult.getBlockOperationResult(out.toArray(new ItemStack[out.size()]));
                    w.playSoundEffect((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "fire.ignite", 1.0f, itemRand.nextFloat() * 0.4f + 0.8f);
                    if (or.BlockItem == null) {
                        w.setBlock(x, y, z, Platform.AIR, 0, 3);
                    } else {
                        w.setBlock(x, y, z, Block.getBlockFromItem((Item)or.BlockItem.getItem()), or.BlockItem.getItemDamage(), 3);
                    }
                    if (or.Drops != null) {
                        Platform.spawnDrops(w, x, y, z, or.Drops);
                    }
                    return true;
                }
                ForgeDirection dir = ForgeDirection.getOrientation((int)side);
                if (!p.canPlayerEdit(x += dir.offsetX, y += dir.offsetY, z += dir.offsetZ, side, item)) {
                    return false;
                }
                if (w.isAirBlock(x, y, z)) {
                    this.extractAEPower(item, 1600.0);
                    w.playSoundEffect((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "fire.ignite", 1.0f, itemRand.nextFloat() * 0.4f + 0.8f);
                    w.setBlock(x, y, z, (Block)Blocks.fire);
                }
                return true;
            }
        }
        return false;
    }

    private static class InWorldToolOperationIngredient {
        private final Block blockID;
        private final int metadata;

        public InWorldToolOperationIngredient(Block blockID, int metadata) {
            this.blockID = blockID;
            this.metadata = metadata;
        }

        public int hashCode() {
            return this.blockID.hashCode() ^ this.metadata;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            InWorldToolOperationIngredient other = (InWorldToolOperationIngredient)obj;
            return this.blockID == other.blockID && this.metadata == other.metadata;
        }
    }
}

