/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.cluster.implementations;

import appeng.api.AEApi;
import appeng.api.definitions.IBlockDefinition;
import appeng.api.definitions.IBlocks;
import appeng.api.util.WorldCoord;
import appeng.me.cluster.IAECluster;
import appeng.me.cluster.IAEMultiBlock;
import appeng.me.cluster.MBCalculator;
import appeng.me.cluster.implementations.QuantumCluster;
import appeng.tile.qnb.TileQuantumBridge;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class QuantumCalculator
extends MBCalculator {
    private final TileQuantumBridge tqb;

    public QuantumCalculator(IAEMultiBlock t) {
        super(t);
        this.tqb = (TileQuantumBridge)t;
    }

    @Override
    public boolean checkMultiblockScale(WorldCoord min, WorldCoord max) {
        if ((max.x - min.x + 1) * (max.y - min.y + 1) * (max.z - min.z + 1) == 9) {
            int ones = (max.x - min.x == 0 ? 1 : 0) + (max.y - min.y == 0 ? 1 : 0) + (max.z - min.z == 0 ? 1 : 0);
            int threes = (max.x - min.x == 2 ? 1 : 0) + (max.y - min.y == 2 ? 1 : 0) + (max.z - min.z == 2 ? 1 : 0);
            return ones == 1 && threes == 2;
        }
        return false;
    }

    @Override
    public IAECluster createCluster(World w, WorldCoord min, WorldCoord max) {
        return new QuantumCluster(min, max);
    }

    @Override
    public boolean verifyInternalStructure(World w, WorldCoord min, WorldCoord max) {
        int num = 0;
        for (int x = min.x; x <= max.x; ++x) {
            for (int y = min.y; y <= max.y; ++y) {
                for (int z = min.z; z <= max.z; ++z) {
                    IAEMultiBlock te = (IAEMultiBlock)w.getTileEntity(x, y, z);
                    if (!te.isValid()) {
                        return false;
                    }
                    num = (byte)(num + 1);
                    IBlocks blocks = AEApi.instance().definitions().blocks();
                    if (!(num == 5 ? !this.isBlockAtLocation((IBlockAccess)w, x, y, z, blocks.quantumLink()) : !this.isBlockAtLocation((IBlockAccess)w, x, y, z, blocks.quantumRing()))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void disconnect() {
        this.tqb.disconnect(true);
    }

    @Override
    public void updateTiles(IAECluster cl, World w, WorldCoord min, WorldCoord max) {
        byte num = 0;
        int ringNum = 0;
        QuantumCluster c = (QuantumCluster)cl;
        for (int x = min.x; x <= max.x; ++x) {
            for (int y = min.y; y <= max.y; ++y) {
                for (int z = min.z; z <= max.z; ++z) {
                    byte flags;
                    TileQuantumBridge te = (TileQuantumBridge)w.getTileEntity(x, y, z);
                    if ((num = (byte)((byte)(num + 1))) == 5) {
                        flags = num;
                        c.setCenter(te);
                    } else {
                        flags = num == 1 || num == 3 || num == 7 || num == 9 ? (byte)(this.tqb.corner | num) : num;
                        c.Ring[ringNum] = te;
                        ringNum = (byte)(ringNum + 1);
                    }
                    te.updateStatus(c, flags, true);
                }
            }
        }
    }

    @Override
    public boolean isValidTile(TileEntity te) {
        return te instanceof TileQuantumBridge;
    }

    private boolean isBlockAtLocation(IBlockAccess w, int x, int y, int z, IBlockDefinition def) {
        Iterator i$ = def.maybeBlock().asSet().iterator();
        if (i$.hasNext()) {
            Block block = (Block)i$.next();
            return block == w.getBlock(x, y, z);
        }
        return false;
    }
}

