/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts;

import appeng.api.AEApi;
import appeng.api.definitions.IItems;
import appeng.api.definitions.ITileDefinition;
import appeng.api.parts.IFacadePart;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartItem;
import appeng.api.parts.PartItemStack;
import appeng.api.parts.SelectedPart;
import appeng.api.util.DimensionalCoord;
import appeng.core.AppEng;
import appeng.core.CommonHelper;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketClick;
import appeng.core.sync.packets.PacketPartPlacement;
import appeng.facade.IFacadeItem;
import appeng.integration.IntegrationType;
import appeng.integration.abstraction.IBC;
import appeng.integration.abstraction.IFMP;
import appeng.integration.abstraction.IImmibisMicroblocks;
import appeng.util.LookDirection;
import appeng.util.Platform;
import com.google.common.base.Optional;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.Iterator;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class PartPlacement {
    public static float eyeHeight = 0.0f;
    private final ThreadLocal<Object> placing = new ThreadLocal();
    private boolean wasCanceled = false;

    /*
     * Enabled aggressive block sorting
     */
    public static boolean place(ItemStack held, int x, int y, int z, int face, EntityPlayer player, World world, PlaceType pass, int depth) {
        DimensionalCoord dc;
        IFacadePart fp;
        if (depth > 3) {
            return false;
        }
        ForgeDirection side = ForgeDirection.getOrientation((int)face);
        if (held != null && Platform.isWrench(player, held, x, y, z) && player.isSneaking()) {
            if (!Platform.hasPermissions(new DimensionalCoord(world, x, y, z), player)) {
                return false;
            }
            Block block = world.getBlock(x, y, z);
            TileEntity tile = world.getTileEntity(x, y, z);
            IPartHost host = null;
            if (tile instanceof IPartHost) {
                host = (IPartHost)tile;
            }
            if (host == null) return false;
            if (world.isRemote) {
                player.swingItem();
                NetworkHandler.instance.sendToServer(new PacketPartPlacement(x, y, z, face, PartPlacement.getEyeOffset(player)));
                return true;
            }
            LookDirection dir = Platform.getPlayerRay(player, PartPlacement.getEyeOffset(player));
            MovingObjectPosition mop = block.collisionRayTrace(world, x, y, z, dir.a, dir.b);
            if (mop == null) return true;
            LinkedList<ItemStack> is = new LinkedList<ItemStack>();
            SelectedPart sp = PartPlacement.selectPart(player, host, mop.hitVec.addVector((double)(-mop.blockX), (double)(-mop.blockY), (double)(-mop.blockZ)));
            if (sp.part != null) {
                is.add(sp.part.getItemStack(PartItemStack.Wrench));
                sp.part.getDrops(is, true);
                host.removePart(sp.side, false);
            }
            if (sp.facade != null) {
                is.add(sp.facade.getItemStack());
                host.getFacadeContainer().removeFacade(host, sp.side);
                Platform.notifyBlocksOfNeighbors(world, x, y, z);
            }
            if (host.isEmpty()) {
                host.cleanup();
            }
            if (is.isEmpty()) return true;
            Platform.spawnDrops(world, x, y, z, is);
            return true;
        }
        TileEntity tile = world.getTileEntity(x, y, z);
        IPartHost host = null;
        if (tile instanceof IPartHost) {
            host = (IPartHost)tile;
        }
        if (held != null && (fp = PartPlacement.isFacade(held, side)) != null) {
            if (host == null) return false;
            if (world.isRemote) {
                player.swingItem();
                NetworkHandler.instance.sendToServer(new PacketPartPlacement(x, y, z, face, PartPlacement.getEyeOffset(player)));
                return true;
            }
            if (host.getPart(ForgeDirection.UNKNOWN) == null) {
                return false;
            }
            if (!host.canAddPart(held, side)) return false;
            if (!host.getFacadeContainer().addFacade(fp)) return false;
            host.markForUpdate();
            if (player.capabilities.isCreativeMode) return true;
            --held.stackSize;
            if (held.stackSize != 0) return true;
            player.inventory.mainInventory[player.inventory.currentItem] = null;
            MinecraftForge.EVENT_BUS.post((Event)new PlayerDestroyItemEvent(player, held));
            return true;
        }
        if (host == null && tile != null && AppEng.instance.isIntegrationEnabled(IntegrationType.FMP)) {
            host = ((IFMP)AppEng.instance.getIntegration(IntegrationType.FMP)).getOrCreateHost(tile);
        }
        if (host == null && tile != null && AppEng.instance.isIntegrationEnabled(IntegrationType.ImmibisMicroblocks)) {
            host = ((IImmibisMicroblocks)AppEng.instance.getIntegration(IntegrationType.ImmibisMicroblocks)).getOrCreateHost(player, face, tile);
        }
        Block block = world.getBlock(x, y, z);
        if (host != null && player.isSneaking() && block != null) {
            LookDirection dir = Platform.getPlayerRay(player, PartPlacement.getEyeOffset(player));
            MovingObjectPosition mop = block.collisionRayTrace(world, x, y, z, dir.a, dir.b);
            if (mop != null) {
                mop.hitVec = mop.hitVec.addVector((double)(-mop.blockX), (double)(-mop.blockY), (double)(-mop.blockZ));
                SelectedPart sPart = PartPlacement.selectPart(player, host, mop.hitVec);
                if (sPart != null && sPart.part != null && sPart.part.onShiftActivate(player, mop.hitVec)) {
                    if (!world.isRemote) return true;
                    NetworkHandler.instance.sendToServer(new PacketPartPlacement(x, y, z, face, PartPlacement.getEyeOffset(player)));
                    return true;
                }
            }
        }
        if (held == null) return false;
        if (!(held.getItem() instanceof IPartItem)) {
            return false;
        }
        int te_x = x;
        int te_y = y;
        int te_z = z;
        ITileDefinition multiPart = AEApi.instance().definitions().blocks().multiPart();
        if (host == null && pass == PlaceType.PLACE_ITEM) {
            ForgeDirection offset = ForgeDirection.UNKNOWN;
            Block blkID = world.getBlock(x, y, z);
            if (blkID != null && !blkID.isReplaceable((IBlockAccess)world, x, y, z)) {
                offset = side;
                if (Platform.isServer()) {
                    side = side.getOpposite();
                }
            }
            if ((tile = world.getTileEntity(te_x = x + offset.offsetX, te_y = y + offset.offsetY, te_z = z + offset.offsetZ)) instanceof IPartHost) {
                host = (IPartHost)tile;
            }
            if (host == null && tile != null && AppEng.instance.isIntegrationEnabled(IntegrationType.FMP)) {
                host = ((IFMP)AppEng.instance.getIntegration(IntegrationType.FMP)).getOrCreateHost(tile);
            }
            if (host == null && tile != null && AppEng.instance.isIntegrationEnabled(IntegrationType.ImmibisMicroblocks)) {
                host = ((IImmibisMicroblocks)AppEng.instance.getIntegration(IntegrationType.ImmibisMicroblocks)).getOrCreateHost(player, face, tile);
            }
            Optional<ItemStack> maybeMultiPartStack = multiPart.maybeStack(1);
            Optional<Block> maybeMultiPartBlock = multiPart.maybeBlock();
            Optional<ItemBlock> maybeMultiPartItemBlock = multiPart.maybeItemBlock();
            boolean hostIsNotPresent = host == null;
            boolean multiPartPresent = maybeMultiPartBlock.isPresent() && maybeMultiPartStack.isPresent() && maybeMultiPartItemBlock.isPresent();
            boolean canMultiPartBePlaced = ((Block)maybeMultiPartBlock.get()).canPlaceBlockAt(world, te_x, te_y, te_z);
            if (hostIsNotPresent && multiPartPresent && canMultiPartBePlaced && ((ItemBlock)maybeMultiPartItemBlock.get()).placeBlockAt((ItemStack)maybeMultiPartStack.get(), player, world, te_x, te_y, te_z, side.ordinal(), 0.5f, 0.5f, 0.5f, 0)) {
                if (world.isRemote) {
                    player.swingItem();
                    NetworkHandler.instance.sendToServer(new PacketPartPlacement(x, y, z, face, PartPlacement.getEyeOffset(player)));
                    return true;
                }
                tile = world.getTileEntity(te_x, te_y, te_z);
                if (tile instanceof IPartHost) {
                    host = (IPartHost)tile;
                }
                pass = PlaceType.INTERACT_SECOND_PASS;
            } else if (host != null && !host.canAddPart(held, side)) {
                return false;
            }
        }
        if (host == null) {
            return false;
        }
        if (!host.canAddPart(held, side)) {
            PlaceType placeType;
            if (pass != PlaceType.INTERACT_FIRST_PASS) {
                if (pass != PlaceType.PLACE_ITEM) return false;
            }
            te_x = x + side.offsetX;
            te_y = y + side.offsetY;
            te_z = z + side.offsetZ;
            Block blkID = world.getBlock(te_x, te_y, te_z);
            tile = world.getTileEntity(te_x, te_y, te_z);
            if (tile != null && AppEng.instance.isIntegrationEnabled(IntegrationType.FMP)) {
                host = ((IFMP)AppEng.instance.getIntegration(IntegrationType.FMP)).getOrCreateHost(tile);
            }
            if (blkID != null && !blkID.isReplaceable((IBlockAccess)world, te_x, te_y, te_z)) {
                if (host == null) return false;
            }
            if (side == ForgeDirection.UNKNOWN) return false;
            int n = side.getOpposite().ordinal();
            if (pass == PlaceType.INTERACT_FIRST_PASS) {
                placeType = PlaceType.INTERACT_SECOND_PASS;
                return PartPlacement.place(held, te_x, te_y, te_z, n, player, world, placeType, depth + 1);
            }
            placeType = PlaceType.PLACE_ITEM;
            return PartPlacement.place(held, te_x, te_y, te_z, n, player, world, placeType, depth + 1);
        }
        if (world.isRemote) {
            player.swingItem();
            NetworkHandler.instance.sendToServer(new PacketPartPlacement(x, y, z, face, PartPlacement.getEyeOffset(player)));
            return true;
        }
        Block block2 = world.getBlock(x, y, z);
        LookDirection dir = Platform.getPlayerRay(player, PartPlacement.getEyeOffset(player));
        MovingObjectPosition mop = block2.collisionRayTrace(world, x, y, z, dir.a, dir.b);
        if (mop != null) {
            SelectedPart sp = PartPlacement.selectPart(player, host, mop.hitVec.addVector((double)(-mop.blockX), (double)(-mop.blockY), (double)(-mop.blockZ)));
            if (sp.part != null && !player.isSneaking() && sp.part.onActivate(player, mop.hitVec)) {
                return false;
            }
        }
        if (!Platform.hasPermissions(dc = host.getLocation(), player)) {
            return false;
        }
        ForgeDirection mySide = host.addPart(held, side, player);
        if (mySide == null) return true;
        Iterator i$ = multiPart.maybeBlock().asSet().iterator();
        while (true) {
            if (!i$.hasNext()) {
                if (player.capabilities.isCreativeMode) return true;
                --held.stackSize;
                if (held.stackSize != 0) return true;
                player.inventory.mainInventory[player.inventory.currentItem] = null;
                MinecraftForge.EVENT_BUS.post((Event)new PlayerDestroyItemEvent(player, held));
                return true;
            }
            Block multiPartBlock = (Block)i$.next();
            Block.SoundType ss = multiPartBlock.stepSound;
            world.playSoundEffect(0.5 + (double)x, 0.5 + (double)y, 0.5 + (double)z, ss.func_150496_b(), (ss.getVolume() + 1.0f) / 2.0f, ss.getPitch() * 0.8f);
        }
    }

    private static float getEyeOffset(EntityPlayer p) {
        if (p.worldObj.isRemote) {
            return Platform.getEyeOffset(p);
        }
        return eyeHeight;
    }

    private static SelectedPart selectPart(EntityPlayer player, IPartHost host, Vec3 pos) {
        CommonHelper.proxy.updateRenderMode(player);
        SelectedPart sp = host.selectPart(pos);
        CommonHelper.proxy.updateRenderMode(null);
        return sp;
    }

    public static IFacadePart isFacade(ItemStack held, ForgeDirection side) {
        IBC bc;
        if (held.getItem() instanceof IFacadeItem) {
            return ((IFacadeItem)held.getItem()).createPartFromItemStack(held, side);
        }
        if (AppEng.instance.isIntegrationEnabled(IntegrationType.BC) && (bc = (IBC)AppEng.instance.getIntegration(IntegrationType.BC)).isFacade(held)) {
            return bc.createFacadePart(held, side);
        }
        return null;
    }

    @SubscribeEvent
    public void playerInteract(TickEvent.ClientTickEvent event) {
        this.wasCanceled = false;
    }

    @SubscribeEvent
    public void playerInteract(PlayerInteractEvent event) {
        if (event.action == PlayerInteractEvent.Action.RIGHT_CLICK_AIR && event.entityPlayer.worldObj.isRemote) {
            MovingObjectPosition mop = Platform.rayTrace(event.entityPlayer, true, false);
            Minecraft mc = Minecraft.getMinecraft();
            float f = 1.0f;
            double d0 = mc.playerController.getBlockReachDistance();
            Vec3 vec3 = mc.renderViewEntity.getPosition(f);
            if (mop != null && mop.hitVec.distanceTo(vec3) < d0) {
                World w = event.entity.worldObj;
                TileEntity te = w.getTileEntity(mop.blockX, mop.blockY, mop.blockZ);
                if (te instanceof IPartHost && this.wasCanceled) {
                    event.setCanceled(true);
                }
            } else {
                ItemStack held = event.entityPlayer.getHeldItem();
                IItems items = AEApi.instance().definitions().items();
                boolean supportedItem = items.memoryCard().isSameAs(held);
                if (event.entityPlayer.isSneaking() && held != null && (supportedItem |= items.colorApplicator().isSameAs(held))) {
                    NetworkHandler.instance.sendToServer(new PacketClick(event.x, event.y, event.z, event.face, 0.0f, 0.0f, 0.0f));
                }
            }
        } else if (event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && event.entityPlayer.worldObj.isRemote) {
            if (this.placing.get() != null) {
                return;
            }
            this.placing.set(event);
            ItemStack held = event.entityPlayer.getHeldItem();
            if (PartPlacement.place(held, event.x, event.y, event.z, event.face, event.entityPlayer, event.entityPlayer.worldObj, PlaceType.INTERACT_FIRST_PASS, 0)) {
                event.setCanceled(true);
                this.wasCanceled = true;
            }
            this.placing.set(null);
        }
    }

    public static enum PlaceType {
        PLACE_ITEM,
        INTERACT_FIRST_PASS,
        INTERACT_SECOND_PASS;

    }
}

