/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.automation;

import appeng.api.config.FuzzyMode;
import appeng.api.config.LevelType;
import appeng.api.config.RedstoneMode;
import appeng.api.config.Settings;
import appeng.api.config.Upgrades;
import appeng.api.config.YesNo;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.crafting.ICraftingProviderHelper;
import appeng.api.networking.crafting.ICraftingWatcher;
import appeng.api.networking.crafting.ICraftingWatcherHost;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergyWatcher;
import appeng.api.networking.energy.IEnergyWatcherHost;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkCraftingPatternChange;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.networking.storage.IStackWatcher;
import appeng.api.networking.storage.IStackWatcherHost;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartRenderHelper;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AECableType;
import appeng.api.util.IConfigManager;
import appeng.client.texture.CableBusTextures;
import appeng.core.sync.GuiBridge;
import appeng.me.GridAccessException;
import appeng.parts.automation.PartUpgradeable;
import appeng.tile.inventory.AppEngInternalAEInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.Platform;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collection;
import java.util.Random;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class PartLevelEmitter
extends PartUpgradeable
implements IEnergyWatcherHost,
IStackWatcherHost,
ICraftingWatcherHost,
IMEMonitorHandlerReceiver<IAEItemStack>,
ICraftingProvider {
    final int FLAG_ON = 4;
    final AppEngInternalAEInventory config = new AppEngInternalAEInventory(this, 1);
    boolean prevState = false;
    long lastReportedValue = 0L;
    long reportingValue = 0L;
    IStackWatcher myWatcher;
    IEnergyWatcher myEnergyWatcher;
    ICraftingWatcher myCraftingWatcher;
    double centerX;
    double centerY;
    double centerZ;
    boolean status = false;

    public PartLevelEmitter(ItemStack is) {
        super(is);
        this.getConfigManager().registerSetting(Settings.REDSTONE_EMITTER, RedstoneMode.HIGH_SIGNAL);
        this.getConfigManager().registerSetting(Settings.FUZZY_MODE, FuzzyMode.IGNORE_ALL);
        this.getConfigManager().registerSetting(Settings.LEVEL_TYPE, LevelType.ITEM_LEVEL);
        this.getConfigManager().registerSetting(Settings.CRAFT_VIA_REDSTONE, YesNo.NO);
    }

    public long getReportingValue() {
        return this.reportingValue;
    }

    public void setReportingValue(long v) {
        this.reportingValue = v;
        if (this.getConfigManager().getSetting(Settings.LEVEL_TYPE) == LevelType.ENERGY_LEVEL) {
            this.configureWatchers();
        } else {
            this.updateState();
        }
    }

    @MENetworkEventSubscribe
    public void powerChanged(MENetworkPowerStatusChange c) {
        this.updateState();
    }

    private void updateState() {
        boolean isOn = this.isLevelEmitterOn();
        if (this.prevState != isOn) {
            this.host.markForUpdate();
            TileEntity te = this.host.getTile();
            this.prevState = isOn;
            Platform.notifyBlocksOfNeighbors(te.getWorldObj(), te.xCoord, te.yCoord, te.zCoord);
            Platform.notifyBlocksOfNeighbors(te.getWorldObj(), te.xCoord + this.side.offsetX, te.yCoord + this.side.offsetY, te.zCoord + this.side.offsetZ);
        }
    }

    private boolean isLevelEmitterOn() {
        boolean flipState;
        if (Platform.isClient()) {
            return (this.clientFlags & this.FLAG_ON) == this.FLAG_ON;
        }
        if (!this.proxy.isActive()) {
            return false;
        }
        if (this.getInstalledUpgrades(Upgrades.CRAFTING) > 0) {
            try {
                return this.proxy.getCrafting().isRequesting(this.config.getAEStackInSlot(0));
            }
            catch (GridAccessException e) {
                return this.prevState;
            }
        }
        boolean bl = flipState = this.getConfigManager().getSetting(Settings.REDSTONE_EMITTER) == RedstoneMode.LOW_SIGNAL;
        return flipState ? this.reportingValue >= this.lastReportedValue + 1L : this.reportingValue < this.lastReportedValue + 1L;
    }

    @MENetworkEventSubscribe
    public void channelChanged(MENetworkChannelsChanged c) {
        this.updateState();
    }

    @Override
    protected int populateFlags(int cf) {
        return cf | (this.prevState ? this.FLAG_ON : 0);
    }

    @Override
    public IIcon getBreakingTexture() {
        return this.is.getIconIndex();
    }

    @Override
    public void updateWatcher(ICraftingWatcher newWatcher) {
        this.myCraftingWatcher = newWatcher;
        this.configureWatchers();
    }

    @Override
    public void onRequestChange(ICraftingGrid craftingGrid, IAEItemStack what) {
        this.updateState();
    }

    public void configureWatchers() {
        IAEItemStack myStack = this.config.getAEStackInSlot(0);
        if (this.myWatcher != null) {
            this.myWatcher.clear();
        }
        if (this.myEnergyWatcher != null) {
            this.myEnergyWatcher.clear();
        }
        if (this.myCraftingWatcher != null) {
            this.myCraftingWatcher.clear();
        }
        try {
            this.proxy.getGrid().postEvent(new MENetworkCraftingPatternChange(this, this.proxy.getNode()));
        }
        catch (GridAccessException e1) {
            // empty catch block
        }
        if (this.getInstalledUpgrades(Upgrades.CRAFTING) > 0) {
            if (this.myCraftingWatcher != null && myStack != null) {
                this.myCraftingWatcher.add(myStack);
            }
            return;
        }
        if (this.getConfigManager().getSetting(Settings.LEVEL_TYPE) == LevelType.ENERGY_LEVEL) {
            if (this.myEnergyWatcher != null) {
                this.myEnergyWatcher.add(Double.valueOf(this.reportingValue));
            }
            try {
                this.lastReportedValue = (long)this.proxy.getEnergy().getStoredPower();
                this.updateState();
                this.proxy.getStorage().getItemInventory().removeListener(this);
            }
            catch (GridAccessException e) {
                // empty catch block
            }
            return;
        }
        try {
            if (this.getInstalledUpgrades(Upgrades.FUZZY) > 0 || myStack == null) {
                this.proxy.getStorage().getItemInventory().addListener(this, this.proxy.getGrid());
            } else {
                this.proxy.getStorage().getItemInventory().removeListener(this);
                if (this.myWatcher != null) {
                    this.myWatcher.add(myStack);
                }
            }
            this.updateReportingValue(this.proxy.getStorage().getItemInventory());
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    private void updateReportingValue(IMEMonitor<IAEItemStack> monitor) {
        IAEItemStack myStack = this.config.getAEStackInSlot(0);
        if (myStack == null) {
            this.lastReportedValue = 0L;
            for (IAEItemStack st : monitor.getStorageList()) {
                this.lastReportedValue += st.getStackSize();
            }
        } else if (this.getInstalledUpgrades(Upgrades.FUZZY) > 0) {
            this.lastReportedValue = 0L;
            FuzzyMode fzMode = (FuzzyMode)this.getConfigManager().getSetting(Settings.FUZZY_MODE);
            Collection<IAEItemStack> fuzzyList = monitor.getStorageList().findFuzzy(myStack, fzMode);
            for (IAEItemStack st : fuzzyList) {
                this.lastReportedValue += st.getStackSize();
            }
        } else {
            IAEItemStack r = monitor.getStorageList().findPrecise(myStack);
            this.lastReportedValue = r == null ? 0L : r.getStackSize();
        }
        this.updateState();
    }

    @Override
    public void updateWatcher(IStackWatcher newWatcher) {
        this.myWatcher = newWatcher;
        this.configureWatchers();
    }

    @Override
    public void onStackChange(IItemList o, IAEStack fullStack, IAEStack diffStack, BaseActionSource src, StorageChannel chan) {
        if (chan == StorageChannel.ITEMS && fullStack.equals(this.config.getAEStackInSlot(0)) && this.getInstalledUpgrades(Upgrades.FUZZY) == 0) {
            this.lastReportedValue = fullStack.getStackSize();
            this.updateState();
        }
    }

    @Override
    public void updateWatcher(IEnergyWatcher newWatcher) {
        this.myEnergyWatcher = newWatcher;
        this.configureWatchers();
    }

    @Override
    public void onThresholdPass(IEnergyGrid energyGrid) {
        this.lastReportedValue = (long)energyGrid.getStoredPower();
        this.updateState();
    }

    @Override
    public boolean isValid(Object effectiveGrid) {
        try {
            return this.proxy.getGrid() == effectiveGrid;
        }
        catch (GridAccessException e) {
            return false;
        }
    }

    @Override
    public void postChange(IBaseMonitor<IAEItemStack> monitor, Iterable<IAEItemStack> change, BaseActionSource actionSource) {
        this.updateReportingValue((IMEMonitor)monitor);
    }

    @Override
    public void onListUpdate() {
        try {
            this.updateReportingValue(this.proxy.getStorage().getItemInventory());
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    @Override
    public AECableType getCableConnectionType(ForgeDirection dir) {
        return AECableType.SMART;
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(7.0, 7.0, 11.0, 9.0, 9.0, 16.0);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInventory(IPartRenderHelper rh, RenderBlocks renderer) {
        rh.setTexture(this.is.getIconIndex());
        Tessellator.instance.startDrawingQuads();
        this.renderTorchAtAngle(0.0, -0.5, 0.0);
        Tessellator.instance.draw();
    }

    public void renderTorchAtAngle(double baseX, double baseY, double baseZ) {
        boolean isOn = this.isLevelEmitterOn();
        IIcon offTexture = this.is.getIconIndex();
        IIcon IIcon2 = isOn ? CableBusTextures.LevelEmitterTorchOn.getIcon() : offTexture;
        this.centerX = baseX + 0.5;
        this.centerY = baseY + 0.5;
        this.centerZ = baseZ + 0.5;
        baseY += 0.4375;
        double par10 = 0.0;
        double Zero = 0.0;
        float var16 = IIcon2.getMinU();
        float var17 = IIcon2.getMaxU();
        float var18 = IIcon2.getMinV();
        float var19 = IIcon2.getMaxV();
        double var20b = offTexture.getInterpolatedU(7.0);
        double var24b = offTexture.getInterpolatedU(9.0);
        double var20 = IIcon2.getInterpolatedU(7.0);
        double var24 = IIcon2.getInterpolatedU(9.0);
        double var22 = IIcon2.getInterpolatedV(6.0 + (isOn ? 0.0 : 1.0));
        double var26 = IIcon2.getInterpolatedV(8.0 + (isOn ? 0.0 : 1.0));
        double var28 = IIcon2.getInterpolatedU(7.0);
        double var30 = IIcon2.getInterpolatedV(13.0);
        double var32 = IIcon2.getInterpolatedU(9.0);
        double var34 = IIcon2.getInterpolatedV(15.0);
        double var22b = IIcon2.getInterpolatedV(9.0);
        double var26b = IIcon2.getInterpolatedV(11.0);
        double var36 = (baseX += 0.5) - 0.5;
        double var38 = baseX + 0.5;
        double var40 = (baseZ += 0.5) - 0.5;
        double var42 = baseZ + 0.5;
        double var44 = 0.0625;
        double var422 = 0.254;
        double TorchLen = 0.625;
        double toff = 0.0;
        if (!isOn) {
            toff = 0.0625;
        }
        Tessellator var12 = Tessellator.instance;
        if (isOn) {
            var12.setColorOpaque_F(1.0f, 1.0f, 1.0f);
            var12.setBrightness(0xB000B0);
        }
        this.addVertexWithUV(baseX + Zero * (1.0 - TorchLen) - var44, baseY + TorchLen - toff, baseZ + par10 * (1.0 - TorchLen) - var44, var20, var22);
        this.addVertexWithUV(baseX + Zero * (1.0 - TorchLen) - var44, baseY + TorchLen - toff, baseZ + par10 * (1.0 - TorchLen) + var44, var20, var26);
        this.addVertexWithUV(baseX + Zero * (1.0 - TorchLen) + var44, baseY + TorchLen - toff, baseZ + par10 * (1.0 - TorchLen) + var44, var24, var26);
        this.addVertexWithUV(baseX + Zero * (1.0 - TorchLen) + var44, baseY + TorchLen - toff, baseZ + par10 * (1.0 - TorchLen) - var44, var24, var22);
        this.addVertexWithUV(baseX + Zero * (1.0 - TorchLen) + var44, baseY + var422, baseZ + par10 * (1.0 - TorchLen) - var44, var24b, var22b);
        this.addVertexWithUV(baseX + Zero * (1.0 - TorchLen) + var44, baseY + var422, baseZ + par10 * (1.0 - TorchLen) + var44, var24b, var26b);
        this.addVertexWithUV(baseX + Zero * (1.0 - TorchLen) - var44, baseY + var422, baseZ + par10 * (1.0 - TorchLen) + var44, var20b, var26b);
        this.addVertexWithUV(baseX + Zero * (1.0 - TorchLen) - var44, baseY + var422, baseZ + par10 * (1.0 - TorchLen) - var44, var20b, var22b);
        this.addVertexWithUV(baseX + var44 + Zero, baseY, baseZ - var44 + par10, var32, var30);
        this.addVertexWithUV(baseX + var44 + Zero, baseY, baseZ + var44 + par10, var32, var34);
        this.addVertexWithUV(baseX - var44 + Zero, baseY, baseZ + var44 + par10, var28, var34);
        this.addVertexWithUV(baseX - var44 + Zero, baseY, baseZ - var44 + par10, var28, var30);
        this.addVertexWithUV(baseX - var44, baseY + 1.0, var40, var16, var18);
        this.addVertexWithUV(baseX - var44 + Zero, baseY + 0.0, var40 + par10, var16, var19);
        this.addVertexWithUV(baseX - var44 + Zero, baseY + 0.0, var42 + par10, var17, var19);
        this.addVertexWithUV(baseX - var44, baseY + 1.0, var42, var17, var18);
        this.addVertexWithUV(baseX + var44, baseY + 1.0, var42, var16, var18);
        this.addVertexWithUV(baseX + Zero + var44, baseY + 0.0, var42 + par10, var16, var19);
        this.addVertexWithUV(baseX + Zero + var44, baseY + 0.0, var40 + par10, var17, var19);
        this.addVertexWithUV(baseX + var44, baseY + 1.0, var40, var17, var18);
        this.addVertexWithUV(var36, baseY + 1.0, baseZ + var44, var16, var18);
        this.addVertexWithUV(var36 + Zero, baseY + 0.0, baseZ + var44 + par10, var16, var19);
        this.addVertexWithUV(var38 + Zero, baseY + 0.0, baseZ + var44 + par10, var17, var19);
        this.addVertexWithUV(var38, baseY + 1.0, baseZ + var44, var17, var18);
        this.addVertexWithUV(var38, baseY + 1.0, baseZ - var44, var16, var18);
        this.addVertexWithUV(var38 + Zero, baseY + 0.0, baseZ - var44 + par10, var16, var19);
        this.addVertexWithUV(var36 + Zero, baseY + 0.0, baseZ - var44 + par10, var17, var19);
        this.addVertexWithUV(var36, baseY + 1.0, baseZ - var44, var17, var18);
    }

    public void addVertexWithUV(double x, double y, double z, double u, double v) {
        double m;
        Tessellator var12 = Tessellator.instance;
        x -= this.centerX;
        y -= this.centerY;
        z -= this.centerZ;
        if (this.side == ForgeDirection.DOWN) {
            y = -y;
            z = -z;
        }
        if (this.side == ForgeDirection.EAST) {
            m = x;
            x = y;
            y = m;
            y = -y;
        }
        if (this.side == ForgeDirection.WEST) {
            m = x;
            x = -y;
            y = m;
        }
        if (this.side == ForgeDirection.SOUTH) {
            m = z;
            z = y;
            y = m;
            y = -y;
        }
        if (this.side == ForgeDirection.NORTH) {
            m = z;
            z = -y;
            y = m;
        }
        var12.addVertexWithUV(x += this.centerX, y += this.centerY, z += this.centerZ, u, v);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderStatic(int x, int y, int z, IPartRenderHelper rh, RenderBlocks renderer) {
        rh.setTexture(this.is.getIconIndex());
        renderer.renderAllFaces = true;
        Tessellator tess = Tessellator.instance;
        tess.setBrightness(rh.getBlock().getMixedBrightnessForBlock((IBlockAccess)this.getHost().getTile().getWorldObj(), x, y, z));
        tess.setColorOpaque_F(1.0f, 1.0f, 1.0f);
        this.renderTorchAtAngle(x, y, z);
        renderer.renderAllFaces = false;
        rh.setBounds(7.0f, 7.0f, 11.0f, 9.0f, 9.0f, 12.0f);
        this.renderLights(x, y, z, rh, renderer);
    }

    @Override
    public int isProvidingStrongPower() {
        return this.prevState ? 15 : 0;
    }

    @Override
    public int isProvidingWeakPower() {
        return this.prevState ? 15 : 0;
    }

    @Override
    public void randomDisplayTick(World world, int x, int y, int z, Random r) {
        if (this.isLevelEmitterOn()) {
            ForgeDirection d = this.side;
            double d0 = (double)((float)d.offsetX * 0.45f) + (double)(r.nextFloat() - 0.5f) * 0.2;
            double d1 = (double)((float)d.offsetY * 0.45f) + (double)(r.nextFloat() - 0.5f) * 0.2;
            double d2 = (double)((float)d.offsetZ * 0.45f) + (double)(r.nextFloat() - 0.5f) * 0.2;
            world.spawnParticle("reddust", 0.5 + (double)x + d0, 0.5 + (double)y + d1, 0.5 + (double)z + d2, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public int cableConnectionRenderTo() {
        return 16;
    }

    @Override
    public boolean onPartActivate(EntityPlayer player, Vec3 pos) {
        if (!player.isSneaking()) {
            if (Platform.isClient()) {
                return true;
            }
            Platform.openGUI(player, this.getHost().getTile(), this.side, GuiBridge.GUI_LEVEL_EMITTER);
            return true;
        }
        return false;
    }

    @Override
    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
        this.configureWatchers();
    }

    @Override
    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
        if (inv == this.config) {
            this.configureWatchers();
        }
        super.onChangeInventory(inv, slot, mc, removedStack, newStack);
    }

    @Override
    public void upgradesChanged() {
        this.configureWatchers();
    }

    @Override
    public boolean canConnectRedstone() {
        return true;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.lastReportedValue = data.getLong("lastReportedValue");
        this.reportingValue = data.getLong("reportingValue");
        this.prevState = data.getBoolean("prevState");
        this.config.readFromNBT(data, "config");
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.setLong("lastReportedValue", this.lastReportedValue);
        data.setLong("reportingValue", this.reportingValue);
        data.setBoolean("prevState", this.prevState);
        this.config.writeToNBT(data, "config");
    }

    @Override
    public IInventory getInventoryByName(String name) {
        if (name.equals("config")) {
            return this.config;
        }
        return super.getInventoryByName(name);
    }

    @Override
    public boolean pushPattern(ICraftingPatternDetails patternDetails, InventoryCrafting table) {
        return false;
    }

    @Override
    public boolean isBusy() {
        return true;
    }

    @Override
    public void provideCrafting(ICraftingProviderHelper craftingTracker) {
        IAEItemStack what;
        if (this.getInstalledUpgrades(Upgrades.CRAFTING) > 0 && this.getConfigManager().getSetting(Settings.CRAFT_VIA_REDSTONE) == YesNo.YES && (what = this.config.getAEStackInSlot(0)) != null) {
            craftingTracker.setEmitable(what);
        }
    }
}

