/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes.game;

import appeng.api.AEApi;
import appeng.api.definitions.IBlocks;
import appeng.api.definitions.IDefinitions;
import appeng.api.definitions.IItemDefinition;
import appeng.api.definitions.IItems;
import appeng.api.definitions.IMaterials;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IItemList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;

public class DisassembleRecipe
implements IRecipe {
    private final IMaterials mats;
    private final IItems items;
    private final IBlocks blocks;
    private final Map<IItemDefinition, IItemDefinition> cellMappings;
    private final Map<IItemDefinition, IItemDefinition> nonCellMappings;

    public DisassembleRecipe() {
        IDefinitions definitions = AEApi.instance().definitions();
        this.blocks = definitions.blocks();
        this.items = definitions.items();
        this.mats = definitions.materials();
        this.cellMappings = new HashMap<IItemDefinition, IItemDefinition>(4);
        this.nonCellMappings = new HashMap<IItemDefinition, IItemDefinition>(5);
        this.cellMappings.put(this.items.cell1k(), this.mats.cell1kPart());
        this.cellMappings.put(this.items.cell4k(), this.mats.cell4kPart());
        this.cellMappings.put(this.items.cell16k(), this.mats.cell16kPart());
        this.cellMappings.put(this.items.cell64k(), this.mats.cell64kPart());
        this.nonCellMappings.put(this.items.encodedPattern(), this.mats.blankPattern());
        this.nonCellMappings.put(this.blocks.craftingStorage1k(), this.mats.cell1kPart());
        this.nonCellMappings.put(this.blocks.craftingStorage4k(), this.mats.cell4kPart());
        this.nonCellMappings.put(this.blocks.craftingStorage16k(), this.mats.cell16kPart());
        this.nonCellMappings.put(this.blocks.craftingStorage64k(), this.mats.cell64kPart());
    }

    public boolean matches(InventoryCrafting inv, World w) {
        return this.getOutput(inv, false) != null;
    }

    private ItemStack getOutput(InventoryCrafting inv, boolean createFacade) {
        ItemStack hasCell = null;
        for (int x = 0; x < inv.getSizeInventory(); ++x) {
            IItemList list;
            IMEInventoryHandler cellInv;
            ItemStack is = inv.getStackInSlot(x);
            if (is == null) continue;
            if (hasCell != null) {
                return null;
            }
            hasCell = this.getCellOutput(is);
            if (hasCell != null && (cellInv = AEApi.instance().registries().cell().getCellInventory(is, null, StorageChannel.ITEMS)) != null && !(list = cellInv.getAvailableItems(StorageChannel.ITEMS.createList())).isEmpty()) {
                return null;
            }
            hasCell = this.getNonCellOutput(is);
            if (hasCell != null) continue;
            return null;
        }
        return hasCell;
    }

    private ItemStack getCellOutput(ItemStack compared) {
        for (Map.Entry<IItemDefinition, IItemDefinition> entry : this.cellMappings.entrySet()) {
            if (!entry.getKey().isSameAs(compared)) continue;
            return (ItemStack)entry.getValue().maybeStack(1).get();
        }
        return null;
    }

    private ItemStack getNonCellOutput(ItemStack compared) {
        for (Map.Entry<IItemDefinition, IItemDefinition> entry : this.nonCellMappings.entrySet()) {
            if (!entry.getKey().isSameAs(compared)) continue;
            return (ItemStack)entry.getValue().maybeStack(1).get();
        }
        return null;
    }

    public ItemStack getCraftingResult(InventoryCrafting inv) {
        return this.getOutput(inv, true);
    }

    public int getRecipeSize() {
        return 1;
    }

    public ItemStack getRecipeOutput() {
        return null;
    }
}

